/*
 * Decompiled with CFR 0.152.
 */
package peridot;

import java.util.HashMap;
import java.util.Map;
import peridot.GeneIdType;
import peridot.Log;
import peridot.Organism;

public class AnalysisParameters {
    public Map<String, Class> requiredParameters = new HashMap<String, Class>();
    public Map<String, Object> parameters = new HashMap<String, Object>();
    public static HashMap<String, Class> availableParamTypes = AnalysisParameters.getAvailableParamTypes();

    public AnalysisParameters() {
    }

    public AnalysisParameters(Map<String, Class> requiredParameters) {
        this.requiredParameters.putAll(requiredParameters);
    }

    public AnalysisParameters(Map<String, Class> requiredParameters, Map<String, Object> parameters) {
        this.requiredParameters.putAll(requiredParameters);
        this.parameters.putAll(parameters);
    }

    public boolean passParameter(String name, Object value) {
        if (this.requiredParameters.containsKey(name)) {
            if (this.requiredParameters.get(name) == value.getClass()) {
                this.parameters.put(name, value);
                return true;
            }
            Log.logger.warning(this.requiredParameters.get(name) + "'s type is not " + value.getClass());
        } else {
            Log.logger.info(name + " is not necessary for the chosen modules.");
        }
        return false;
    }

    public void newRequiredParameter(String name, Class type) {
        this.requiredParameters.put(name, type);
    }

    public static HashMap<String, Object> getDefaultValues() {
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        defaultValues.put("pValue", new Float(0.01));
        defaultValues.put("fdr", new Float(0.01));
        defaultValues.put("foldChange", new Float(1.5));
        defaultValues.put("tops", new Integer(0));
        defaultValues.put("geneIdType", new GeneIdType("None"));
        defaultValues.put("referenceOrganism", new Organism("Human"));
        return defaultValues;
    }

    public static HashMap<String, Class> getAvailableParamTypes() {
        HashMap<String, Class> classes = new HashMap<String, Class>();
        classes.put(Integer.class.getSimpleName(), Integer.class);
        classes.put(Float.class.getSimpleName(), Float.class);
        classes.put(GeneIdType.class.getSimpleName(), GeneIdType.class);
        classes.put(Organism.class.getSimpleName(), Organism.class);
        return classes;
    }

    public String toString() {
        String string = "";
        for (Map.Entry<String, Object> pair : this.parameters.entrySet()) {
            string = string + pair.getKey() + ": ";
            string = string + pair.getValue() + ", ";
        }
        return string;
    }
}

