/*
 * Decompiled with CFR 0.152.
 */
package peridot.Archiver;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import peridot.Archiver.Persistence;
import peridot.Archiver.Places;
import peridot.script.r.Interpreter;
import peridot.script.r.VersionNumber;

public class PeridotConfig
implements Serializable {
    public String defaultInterpreter = null;
    public Set<String> availableInterpreters;
    public String packagesRepository = this.rPeridotWebSite + "R/drat/";
    public String rPeridotWebSite = "http://www.bioinformatics-brazil.org/r-peridot/";
    public static VersionNumber preferredRVersion = new VersionNumber("3.4");
    public static VersionNumber minimalRVersion = new VersionNumber("3.4");
    private static PeridotConfig _instance = PeridotConfig.getConfigs();

    public PeridotConfig() {
        this.availableInterpreters = Places.getDefaultRexecs();
    }

    public void updateValues() {
        this.defaultInterpreter = Interpreter.isDefaultInterpreterDefined() ? Interpreter.defaultInterpreter.exe : null;
        List<Interpreter> inters = Interpreter.interpreters;
        if (inters != null) {
            this.availableInterpreters = new HashSet<String>();
            for (Interpreter i : inters) {
                this.availableInterpreters.add(i.exe);
            }
        }
    }

    private static PeridotConfig getConfigs() {
        PeridotConfig loadedConfig = null;
        if (Places.peridotConfigFile.exists()) {
            loadedConfig = (PeridotConfig)Persistence.loadObjectFromBin(Places.peridotConfigFile.getAbsolutePath());
        }
        if (loadedConfig == null) {
            return new PeridotConfig();
        }
        if (loadedConfig.defaultInterpreter == null) {
            // empty if block
        }
        return loadedConfig;
    }

    public static PeridotConfig get() {
        return _instance;
    }

    public static void save() throws IOException {
        _instance.updateValues();
        Persistence.saveObjectAsBin(Places.peridotConfigFile, _instance);
    }
}

