/*
 * Decompiled with CFR 0.152.
 */
package peridot.Archiver;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import peridot.Log;

public final class Places {
    public static File peridotDir = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files");
    public static File peridotConfigFile = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "peridot.config");
    public static File finalResultsDir = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "results");
    public static File modulesDir = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "scripts");
    public static File readPackagesScript = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "scripts" + File.separator + "installedPackages.R");
    public static File installPackageScript = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "scripts" + File.separator + "installPackage.R");
    public static String countReadsInputFileName = "rna-seq-input.tsv";
    public static File countReadsInputFile = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "results" + File.separator + countReadsInputFileName);
    public static String conditionInputFileName = "condition-input.tsv";
    public static File conditionInputFile = new File(Places.getUserHomePath() + File.separator + ".r-peridot-files" + File.separator + "results" + File.separator + conditionInputFileName);
    public static File jarFolder = Places.getJarFolder();
    public static File defaultModulesDir = Places.getDefaultModulesDir();

    private Places() {
        throw new AssertionError();
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static void createPeridotDir() {
        if (!peridotDir.exists()) {
            Log.logger.info("~/r-peridot-files not found, creating it.");
            peridotDir.mkdirs();
            peridotDir.mkdir();
            if (!peridotDir.exists()) {
                Log.logger.severe("Error: Could not create " + peridotDir.getAbsolutePath());
            }
        }
        if (!finalResultsDir.exists()) {
            Log.logger.info("Results directory not found, creating it.");
            finalResultsDir.mkdirs();
            finalResultsDir.mkdir();
            if (!finalResultsDir.exists()) {
                Log.logger.severe("Error: Could not create directory for final results it");
            }
        }
    }

    public static File getDefaultModulesDir() {
        File file = new File(jarFolder.getAbsolutePath() + File.separator + "r-peridot-scripts");
        if (file.exists()) {
            return file;
        }
        Log.logger.warning("Warning: No DefaultModulesDir found, without it you can't reload the modules.");
        return null;
    }

    public static void updateModulesDir(boolean overwrite) {
        try {
            if (!modulesDir.exists()) {
                modulesDir.mkdir();
                overwrite = true;
            }
            Places.updateModulesFolder(overwrite);
        }
        catch (Exception ex) {
            Log.logger.severe("Error: could not update modules folder.");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private static void updateModulesFolder(boolean overwrite) throws Exception {
        File[] subs = defaultModulesDir.listFiles();
        for (int i = 0; i < subs.length; ++i) {
            if (!subs[i].getParentFile().getAbsolutePath().equals(defaultModulesDir.getAbsolutePath()) || subs[i].getName().contains(".git")) continue;
            if (subs[i].isDirectory()) {
                File targetDir = new File(modulesDir.getAbsolutePath() + File.separator + subs[i].getName());
                if (targetDir.exists()) {
                    if (!overwrite) continue;
                    FileUtils.deleteDirectory(targetDir);
                    FileUtils.copyDirectory(subs[i], targetDir);
                    Log.logger.info("Updated " + subs[i].getName() + ".");
                    continue;
                }
                FileUtils.copyDirectory(subs[i], targetDir);
                Log.logger.fine("Updated " + subs[i].getName() + ".");
                continue;
            }
            if (!subs[i].getName().contains(".R")) continue;
            File destFile = new File(modulesDir.getAbsolutePath() + File.separator + subs[i].getName());
            if (destFile.exists()) {
                if (!overwrite) continue;
                FileUtils.forceDelete(destFile);
                FileUtils.copyFile(subs[i], destFile, true);
                continue;
            }
            FileUtils.copyFile(subs[i], destFile, true);
        }
        File gitDir = new File(modulesDir.getAbsolutePath() + File.separator + ".git");
        if (gitDir.exists()) {
            FileUtils.deleteDirectory(gitDir);
        }
    }

    public static String[] getWin64And32ExecsFrom(String rWindowsDir) {
        String[] exes = new String[2];
        String binDir = rWindowsDir + File.separator + "bin";
        exes[0] = binDir + File.separator + "x64" + File.separator + "R.exe";
        exes[1] = binDir + File.separator + "i386" + File.separator + "R.exe";
        return exes;
    }

    public static String[] defaultRportableDirs() {
        File userRPortable = new File(Places.getUserHomePath() + File.separator + "r-portable");
        File jarFolder = Places.getJarFolder();
        File localRPortable = new File(jarFolder.getAbsolutePath() + File.separator + "r-portable");
        String[] dirs = new String[]{userRPortable.getAbsolutePath(), localRPortable.getAbsolutePath()};
        return dirs;
    }

    public static Set<String> windowsRexes() {
        TreeSet<String> exes = new TreeSet<String>();
        String[] defaultRportableDir = Places.defaultRportableDirs();
        for (int i = 0; i < defaultRportableDir.length; ++i) {
            if (defaultRportableDir[i] == null) continue;
            String[] win64and32execs = Places.getWin64And32ExecsFrom(defaultRportableDir[i]);
            for (int j = 0; j < win64and32execs.length; ++j) {
                if (win64and32execs[j] == null) continue;
                exes.add(win64and32execs[j]);
            }
        }
        File programFilesRDir = new File("C:" + File.separator + "Program Files" + File.separator + "R");
        if (programFilesRDir.exists()) {
            File[] subs = programFilesRDir.listFiles();
            for (int i = 0; i < subs.length; ++i) {
                if (!subs[i].isDirectory() || !subs[i].getParentFile().getAbsolutePath().equals(programFilesRDir.getAbsolutePath()) || !subs[i].getName().contains("R-3")) continue;
                String[] win64and32execs = Places.getWin64And32ExecsFrom(subs[i].getAbsolutePath());
                for (int j = 0; j < win64and32execs.length; ++j) {
                    if (win64and32execs[i] == null) continue;
                    exes.add(win64and32execs[j]);
                }
            }
        }
        return exes;
    }

    public static Set<String> linuxRexes() {
        TreeSet<String> exes = new TreeSet<String>();
        String[] defaultRportableDir = Places.defaultRportableDirs();
        for (int i = 0; i < defaultRportableDir.length; ++i) {
            if (defaultRportableDir[i] == null) continue;
            exes.add(defaultRportableDir[i] + File.separator + "bin" + File.separator + "R");
        }
        return exes;
    }

    public static Set<String> getDefaultRexecs() {
        HashSet<String> exes = new HashSet<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            exes.addAll(Places.windowsRexes());
        } else if (SystemUtils.IS_OS_LINUX) {
            exes.addAll(Places.linuxRexes());
        }
        exes.add("R");
        return exes;
    }

    public static File getJarFolder() {
        File jarFolder = null;
        ProtectionDomain pDomain = Places.class.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL url = cSource.getLocation();
        URI uri = null;
        try {
            uri = url.toURI();
            jarFolder = new File(uri.getPath());
            if (jarFolder.isFile()) {
                File parent;
                jarFolder = parent = jarFolder.getParentFile();
            }
            return jarFolder;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.logger.severe("Error: Could not load jar location");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }
}

