/*
 * Decompiled with CFR 0.152.
 */
package peridot.CLI;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import peridot.AnalysisData;
import peridot.AnalysisParameters;
import peridot.Archiver.Manager;
import peridot.Archiver.Spreadsheet;
import peridot.CLI.AnalysisFile;
import peridot.GeneIdType;
import peridot.Global;
import peridot.Log;
import peridot.Organism;
import peridot.script.AnalysisModule;
import peridot.script.RModule;

public class AnalysisFileParser {
    AnalysisFile analysisFile = null;
    boolean valid = true;
    boolean allInfo = false;
    boolean hasData = false;
    boolean hasConditions = false;
    boolean hasModules = false;
    boolean hasParams = false;
    int threshold;
    String roundingMode;
    File countReadsFile = null;
    File conditionsFile = null;
    File saveFolder;
    Spreadsheet.Info info = new Spreadsheet.Info();
    Set<String> modules = new TreeSet<String>();
    Map<String, Class> paramTypes;
    Map<String, String> params = new HashMap<String, String>();
    Map<String, Map<String, String>> specificParams = new HashMap<String, Map<String, String>>();
    String separatorChar;
    public static final String dataStr = "[data]";
    public static final String conditionsStr = "[conditions]";
    public static final String modulesStartStr = "[modules]";
    public static final String paramsStartStr = "[parameters]";
    public static final String endStr = "[/end]";
    public static final String paramEqualStr = "=";
    public static final String paramModSeparator = "::";
    public static final String labelsOnFirstColStr = "[labels]";
    public static final String headerOnFirstLineStr = "[header]";
    public static final String saveAtStr = "[output]";
    public static final String thresholdStr = "[count-reads-threshold]";
    public static final String roundingModeStr = "[rounding-mode]";
    public static final String sepStr = "[separator]";

    public AnalysisFileParser(File file) {
        this.paramTypes = new HashMap<String, Class>();
        this.parse(file);
    }

    public static AnalysisFile make(File file) {
        AnalysisFileParser parser = new AnalysisFileParser(file);
        return parser.analysisFile;
    }

    private void parse(File file) {
        this.analysisFile = new AnalysisFile();
        String word = null;
        String line = null;
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (line.length() <= 1 || line.substring(0, 1).equals("#")) continue;
                String[] words = Global.firstWordAndTheRest(line);
                word = words[0];
                if (words[1] == null) {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    while (!(line = scanner.nextLine()).contains(endStr)) {
                        if (line.length() < 1 || line.substring(0, 1).equals("#")) continue;
                        treeSet.add(line);
                    }
                    this.parseParamsAndModules(word, treeSet);
                    continue;
                }
                String string = words[1];
                this.parseSingleLineInfo(word, string);
            }
            scanner.close();
            this.setExpression();
            this.setModules();
            this.analysisFile.outputFolder = this.saveFolder;
            this.analysisFile.params = this.getAnalysisParamsFromMap(this.params, null);
            this.analysisFile.specificParams = this.getSpecificParams();
            for (Map.Entry entry : this.analysisFile.params.requiredParameters.entrySet()) {
                boolean found = false;
                for (Map.Entry<String, Object> pair2 : this.analysisFile.params.parameters.entrySet()) {
                    if (!((String)entry.getKey()).equals(pair2.getKey())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ParseException("Error: The parameter " + (String)entry.getKey() + " has not been specified.");
            }
            this.hasParams = true;
        }
        catch (ParseException ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.valid = false;
        }
        catch (IOException ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.valid = false;
        }
        this.analysisFile.allInfo = this.hasData && this.hasConditions && this.hasModules && this.hasParams;
        this.analysisFile.valid = this.valid;
    }

    public void setExpression() throws IOException {
        if (this.conditionsFile != null && this.countReadsFile != null && this.info.allInfoSet()) {
            this.info.setFirstCellPresent(!this.info.getHeaderOnFirstLine() || !this.info.getLabelsOnFirstCol());
            if (this.separatorChar != null) {
                this.info.separator = this.separatorChar;
            }
            this.analysisFile.expression = new AnalysisData(this.countReadsFile, this.conditionsFile, this.info, this.roundingMode, this.threshold);
            this.hasData = true;
            this.hasConditions = true;
        }
    }

    public void setModules() throws ParseException {
        boolean anyPackages = false;
        for (String module : this.modules) {
            if (RModule.availableModules.get(module) instanceof AnalysisModule) {
                anyPackages = true;
            }
            for (String dep : RModule.availableModules.get((Object)module).requiredScripts) {
                if (this.modules.contains(dep)) continue;
                throw new ParseException("Error: " + module + " depends on " + dep + ", but " + dep + " was not chosen to be executed.");
            }
        }
        if (!anyPackages) {
            throw new ParseException("Error: No AnalysisData module was chosen.");
        }
        this.analysisFile.scriptsToExec = this.modules;
        this.hasModules = true;
    }

    public Map<String, Class> getRequiredParamsFromModules() {
        HashMap<String, Class> req = new HashMap<String, Class>();
        for (String modName : this.analysisFile.scriptsToExec) {
            for (Map.Entry<String, Class> pair : RModule.availableModules.get((Object)modName).requiredParameters.entrySet()) {
                req.put(pair.getKey(), pair.getValue());
            }
        }
        return req;
    }

    public AnalysisParameters getAnalysisParamsFromMap(Map<String, String> params, Map<String, Class> requiredParams) {
        AnalysisParameters ap = new AnalysisParameters();
        if (requiredParams == null) {
            ap.requiredParameters = this.getRequiredParamsFromModules();
        }
        for (Map.Entry<String, String> pair : this.params.entrySet()) {
            Object value = null;
            if (this.paramTypes.get(pair.getKey()) == Float.class) {
                value = new Float(pair.getValue());
            } else if (this.paramTypes.get(pair.getKey()) == Integer.class) {
                value = new Integer(pair.getValue());
            } else if (this.paramTypes.get(pair.getKey()) == GeneIdType.class) {
                value = new GeneIdType(pair.getValue());
            } else if (this.paramTypes.get(pair.getKey()) == Organism.class) {
                value = new Organism(pair.getValue());
            }
            ap.passParameter(pair.getKey(), value);
        }
        return ap;
    }

    public Map<String, AnalysisParameters> getSpecificParams() {
        Map<String, Class> req = this.getRequiredParamsFromModules();
        HashMap<String, AnalysisParameters> sParams = new HashMap<String, AnalysisParameters>();
        for (Map.Entry<String, Map<String, String>> pair : this.specificParams.entrySet()) {
            sParams.put(pair.getKey(), this.getAnalysisParamsFromMap(pair.getValue(), req));
        }
        return sParams;
    }

    public void parseParamsAndModules(String type, Set<String> values) throws ParseException {
        if (type.equals(modulesStartStr)) {
            for (String word : values) {
                if (!RModule.availableModules.containsKey(word)) {
                    throw new ParseException("Error: " + word + " is not avalid module.");
                }
                this.modules.add(word);
            }
        } else if (type.equals(paramsStartStr)) {
            this.parseParams(values);
        } else {
            throw new ParseException("Error: Expected [modules] or [parameters]: " + type);
        }
    }

    public void parseParams(Set<String> values) throws ParseException {
        for (String param : values) {
            String[] typeAndParam = Global.spliceBySpacesAndTabs(param);
            if (typeAndParam.length != 2) {
                throw new ParseException("Error: No parameter type: " + param);
            }
            Class paramType = null;
            if (!AnalysisParameters.availableParamTypes.containsKey(typeAndParam[0])) {
                throw new ParseException("Error: The type " + typeAndParam[0] + " is not valid.");
            }
            paramType = AnalysisParameters.availableParamTypes.get(typeAndParam[0]);
            String[] attributeAndValue = typeAndParam[1].split(paramEqualStr);
            if (attributeAndValue.length != 2) {
                throw new ParseException("Error: Invalid parameter attribution: " + param);
            }
            String attr = attributeAndValue[0];
            String value = attributeAndValue[1];
            if (attr.contains(paramModSeparator)) {
                String[] modAndAttr = attr.split(paramModSeparator);
                if (!this.specificParams.containsKey(modAndAttr[0])) {
                    this.specificParams.put(modAndAttr[0], new HashMap());
                }
                this.specificParams.get(modAndAttr[0]).put(modAndAttr[1], value);
                this.paramTypes.put(modAndAttr[0], paramType);
                continue;
            }
            this.params.put(attr, value);
            this.paramTypes.put(attr, paramType);
        }
    }

    public void parseSingleLineInfo(String word, String second) throws ParseException {
        second = second.replace(" ", "");
        if (word.equals(dataStr)) {
            this.countReadsFile = new File(Manager.makeTildeIntoHomeDir(second));
            if (!this.countReadsFile.exists()) {
                System.out.println(second);
                throw new ParseException(second + " file does not exists.");
            }
        } else if (word.equals(conditionsStr)) {
            this.conditionsFile = new File(Manager.makeTildeIntoHomeDir(second));
            if (!this.conditionsFile.exists()) {
                throw new ParseException("[conditions] file does not exists.");
            }
        } else if (word.equals(saveAtStr)) {
            this.saveFolder = new File(Manager.makeTildeIntoHomeDir(second));
            if (this.saveFolder.isFile()) {
                throw new ParseException("The output directory '" + this.saveFolder.getAbsolutePath() + "' is a file, not a directory.");
            }
        } else if (word.equals(labelsOnFirstColStr)) {
            boolean value = Boolean.parseBoolean(second);
            this.info.setLabelsOnFirstCol(value);
        } else if (word.equals(headerOnFirstLineStr)) {
            boolean value = Boolean.parseBoolean(second);
            this.info.setHeaderOnFirstLine(value);
        } else if (word.equals(thresholdStr)) {
            int value;
            this.threshold = value = Integer.parseInt(second);
        } else if (word.equals(roundingModeStr)) {
            String value;
            this.roundingMode = value = second;
        } else if (word.equals(sepStr)) {
            this.separatorChar = second.equals("\"\"") || second.equals("\" \"") ? " " : (second.equals("\",\"") ? "," : (second.equals("\"\\t\"") ? "\t" : (second.equals("\";\"") ? ";" : null)));
        } else {
            Log.logger.warning("Unknown category: " + word + ". Ignoring.");
        }
    }

    public static class ParseException
    extends Exception {
        public ParseException(String message) {
            super(message);
        }
    }
}

