/*
 * Decompiled with CFR 0.152.
 */
package peridot.CLI.Commands;

import java.io.File;
import peridot.CLI.AnalysisFile;
import peridot.CLI.AnalysisFileParser;
import peridot.CLI.Command;
import peridot.Log;
import peridot.Operations;
import peridot.script.Task;

public class RUN
extends Command {
    public static String specification = AnalysisFile.getSpecification();
    public static final String createExampleOperation = "--create-example";
    public static final String specifyOperation = "--specification";

    public RUN(String[] args) {
        super(args);
    }

    @Override
    public void evaluateArgs() throws Command.CmdParseException {
        if (this.args.length != 1 && this.args.length != 2) {
            this.fail("Invalid arguments, 'r-peridot run [args]' takes one or two arguments, only.");
        } else if (this.args.length == 1) {
            File analysisFile;
            String arg0 = new String(this.args[0]);
            if (!(RUN.isHelpArg(this.args[0]) || arg0.equals(specifyOperation) || (analysisFile = new File(this.args[0])).exists())) {
                this.fail("The file '" + analysisFile.getAbsolutePath() + "' does not exists.");
            }
        } else if (this.args.length == 2) {
            if (!this.args[0].equals(createExampleOperation)) {
                this.fail("Invalid argument: '" + this.args[0] + "'. Did you try '--create-example'?");
            } else {
                File countReadsFile = new File(this.args[1]);
                if (!countReadsFile.exists()) {
                    this.fail("The file '" + countReadsFile.getAbsolutePath() + "' does not exists.");
                }
            }
        }
    }

    @Override
    public void run() {
        if (this.args.length == 1) {
            if (RUN.isHelpArg(this.args[0])) {
                this.printDetails();
            } else if (this.args[0].equals(specifyOperation)) {
                System.out.println(AnalysisFile.getSpecification());
            } else {
                File file = new File(this.args[0]);
                AnalysisFile analysisFile = AnalysisFileParser.make(file);
                if (!analysisFile.isValid()) {
                    Log.logger.severe("Fatal Error: Invalid info. on '" + file.getAbsolutePath() + "', cannot run analysis.");
                } else if (!analysisFile.hasAllInfo()) {
                    Log.logger.severe("Fatal Error: '" + file.getName() + "'does not have all the necessary information to run an analysis.");
                } else {
                    Task task = Operations.start(analysisFile);
                    this.waitForEnd(task, analysisFile);
                }
            }
        } else if (this.args.length == 2) {
            File countReadsFile = new File(this.args[1]);
            AnalysisFile.createExampleFileFor(countReadsFile);
        }
    }

    public void waitForEnd(Task task, AnalysisFile analysisFile) {
        while (task.isProcessing()) {
        }
        System.out.println("\nFinished processing task.");
        System.out.println("Failed: ");
        if (task.failedScripts.size() == 0) {
            System.out.println("\tNone");
        } else {
            for (String s : task.failedScripts) {
                System.out.println("\t" + s);
            }
        }
        System.out.println("Success: ");
        if (task.successfulScripts.size() == 0) {
            System.out.println("\tNone");
        } else {
            for (String s : task.successfulScripts) {
                System.out.println("\t" + s);
            }
            if (task.noDiffExpFound.size() > 0) {
                System.out.println("The following modules did not found differential expression:");
                for (String modName : task.noDiffExpFound) {
                    System.out.println("\t" + modName);
                }
            }
        }
        boolean success = Operations.saveResultsAt(analysisFile.outputFolder);
    }

    @Override
    public void defineCmdNameAndDetails() {
        this.commandStr = "run";
        this.detail = "R-Peridot's Command: run\nOptions:\n\trun path/to/analysis/file.af\n\t\tMake an analysis based on a file (.af) with\n\t\tall the necessary information.\n\trun --create-example path/to/count/reads/file\n\t\tCreates a '.af', named path/to/count/reads/file.af,\n\t\tfile with most of the information ready.\n\t\tThe user only has to modify the conditions of\n\t\teach sample, choose between the modules listed\n\t\tand modify the parameter's default values.\n\t\tThe conditions file is created at\n.\t\tpath/to/count/reads/file.conditions.\n\t\tAll samples are set to not be used, you have to\n\t\tedit this file to set the conditions.\n\n\trun --specification\n\t\tPrints the specification of the analysis file (.af).\n\n\trun --help\n\t\tDisplays this message\n\n";
    }
}

