/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JLabel;
import peridot.GUI.component.Label;
import peridot.Log;

public class GUIUtils {
    private GUIUtils() {
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static Dimension getCenterLocation(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        return new Dimension(x, y);
    }

    public static boolean showImageDialog(File file) {
        JLabel logoLabel = Label.getImageLabel(file);
        if (logoLabel != null) {
            JDialog frame = new JDialog();
            frame.getContentPane().add(logoLabel);
            frame.setDefaultCloseOperation(2);
            frame.setSize(600, 615);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setModal(false);
            frame.setVisible(true);
            return true;
        }
        Log.logger.info("Could not load image " + file.getAbsolutePath());
        return false;
    }
}

