/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import peridot.Archiver.Spreadsheet;
import peridot.GUI.component.Table;

public class JTableUtils {
    public static JTable getJTable(Spreadsheet spreadsheet) {
        Table table = null;
        List<String[]> allRows = spreadsheet.getRows();
        if (allRows.size() > 0) {
            Object[][] data = new Object[allRows.size() - 1][];
            Object[] headers = new Object[allRows.get(allRows.size() - 1).length];
            String[] firstRow = allRows.get(0);
            boolean lessItensOnFirstRow = !spreadsheet.getInfo().getFirstCellPresent();
            boolean firstRowIsHeader = spreadsheet.getInfo().getHeaderOnFirstLine();
            if (lessItensOnFirstRow || firstRowIsHeader) {
                int i;
                if (allRows.size() == 1) {
                    return null;
                }
                if (lessItensOnFirstRow && firstRowIsHeader) {
                    headers[0] = "ID";
                    for (i = 1; i < headers.length; ++i) {
                        headers[i] = firstRow[i - 1];
                    }
                } else {
                    headers = firstRow;
                }
                for (i = 0; i < data.length; ++i) {
                    data[i] = allRows.get(i + 1);
                }
            } else {
                data = new Object[allRows.size()][];
                data = (Object[][])allRows.toArray((T[])data);
                headers = Spreadsheet.getDefaultHeader(data[0].length);
            }
            table = new Table(data, headers);
            return table;
        }
        return null;
    }

    private static String[] subStrArray(String[] array, int maxElements) {
        boolean equal = maxElements == array.length;
        String[] newArray = Arrays.copyOfRange(array, 0, maxElements);
        if (!equal) {
            newArray[newArray.length - 1] = "...";
        }
        return newArray;
    }

    private static List<String[]> cutTableMatrixCols(List<String[]> allRows, int maxCols) {
        for (int i = 0; i < allRows.size(); ++i) {
            if (allRows.get(i).length <= maxCols) continue;
            allRows.set(i, JTableUtils.subStrArray(allRows.get(i), maxCols));
        }
        return allRows;
    }

    private static List<String[]> cutTableMatrixRows(List<String[]> allRows, int maxRows) {
        if (allRows.size() > maxRows) {
            while (allRows.size() > maxRows) {
                allRows.remove(allRows.size() - 1);
            }
            allRows.remove(allRows.size() - 1);
            String[] lastRow = new String[allRows.get(0).length];
            for (int i = 0; i < allRows.get(0).length; ++i) {
                lastRow[i] = "...";
            }
            allRows.add(lastRow);
        }
        return allRows;
    }

    public static boolean tableOverColumnLimit(File tableFile, String sep) {
        String[] firstRow = Spreadsheet.getFirstRowFromFile(tableFile, sep);
        if ("simple".equals("simple")) {
            return firstRow.length > 100;
        }
        return firstRow.length > 10000;
    }

    public static Table getTableWithoutHeader(List<String[]> allRows, boolean defaultHeader, int maxCols, int maxLines) {
        Table table = null;
        if (allRows != null && allRows.size() > 0 && allRows.get(0).length > 0) {
            if (maxCols > 0) {
                allRows = JTableUtils.cutTableMatrixCols(allRows, maxCols);
            }
            if (maxLines > 0) {
                allRows = JTableUtils.cutTableMatrixRows(allRows, maxLines);
            }
        }
        Object[][] data = new Object[allRows.size()][];
        data = (Object[][])allRows.toArray((T[])data);
        Object[] headers = Spreadsheet.getDefaultHeader(data[0].length);
        table = new Table(data, headers);
        if (!defaultHeader) {
            table.setTableHeader(null);
        }
        return table;
    }

    public static FileFilter getGeneFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.exists() && f.canRead();
            }

            @Override
            public String getDescription() {
                return "Plain text spreadsheet file";
            }
        };
    }
}

