/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI;

import java.io.IOException;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.GraphiteSkin;
import peridot.Archiver.PeridotConfig;
import peridot.GUI.Aesthetics;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.component.Label;
import peridot.GUI.javaFXPanels.InterpreterManagerSwingDialog;
import peridot.Log;
import peridot.Operations;
import peridot.script.RModule;

public class Main {
    public static final String deployType = "simple";
    public static final int maxColsSimple = 100;
    public static final int maxColsPlus = 10000;
    public static JDialog logoLoadingFrame;

    public static void main(String[] args) {
        Main.showLogoLoadingScreen();
        SubstanceLookAndFeel.setSkin(new GraphiteSkin());
        SwingUtilities.invokeLater(() -> {
            Aesthetics.loadFonts();
            Operations.createNecessaryDirs();
            BooleanSupplier func = () -> false;
            if (Operations.loadModules()) {
                logoLoadingFrame.setVisible(false);
                if (Operations.loadInterpreters(func)) {
                    MainGUI gui = new MainGUI();
                    gui.setVisible(true);
                } else {
                    InterpreterManagerSwingDialog.openInterpreterManager(() -> {
                        MainGUI gui = new MainGUI();
                        gui.setVisible(true);
                    });
                }
            } else {
                Main.endMain();
            }
        });
    }

    public static void clean() {
        for (Map.Entry<String, RModule> pair : RModule.availableModules.entrySet()) {
            pair.getValue().cleanTempFiles();
        }
    }

    public static void showLogoLoadingScreen() {
        logoLoadingFrame = new JDialog();
        ImageIcon logoImage = Resources.getImageIcon(logoLoadingFrame.getClass(), "logo.png");
        Label logoLabel = new Label();
        logoLabel.setIcon(logoImage);
        logoLoadingFrame.getContentPane().add(logoLabel);
        logoLoadingFrame.setUndecorated(true);
        logoLoadingFrame.setDefaultCloseOperation(2);
        logoLoadingFrame.setSize(logoImage.getIconWidth(), logoImage.getIconHeight());
        logoLoadingFrame.pack();
        logoLoadingFrame.setLocationRelativeTo(null);
        logoLoadingFrame.setAlwaysOnTop(true);
        logoLoadingFrame.setModal(false);
        logoLoadingFrame.setVisible(true);
    }

    public static void endMain() {
        Log.logger.info("Cleaning temporary files.");
        Main.clean();
        try {
            Log.logger.info("Saving configurations.");
            PeridotConfig.save();
        }
        catch (IOException ex) {
            Log.logger.severe("Error while saving the current configurations.");
            ex.printStackTrace();
        }
        Log.logger.info("Finishing R-Peridot-GUI.");
        System.exit(0);
    }
}

