/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.pushingpixels.substance.internal.ui.SubstanceTabbedPaneUI;
import peridot.Archiver.PeridotConfig;
import peridot.Archiver.Places;
import peridot.GUI.Main;
import peridot.GUI.Resources;
import peridot.GUI.component.Panel;
import peridot.GUI.component.TabbedPane;
import peridot.GUI.dialog.modulesManager.ModulesManager;
import peridot.GUI.javaFXPanels.InterpreterManagerSwingDialog;
import peridot.GUI.panel.NewAnalysisPanel;
import peridot.GUI.panel.ProcessingPanel;
import peridot.GUI.panel.ResultsPanel;
import peridot.Global;
import peridot.Log;
import peridot.script.RModule;

public class MainGUI
extends JFrame {
    public static final Dimension defaultSize = new Dimension(546, 600);
    public static final String appName = "R-Peridot";
    protected NewAnalysisPanel analysisPanel;
    public ProcessingPanel processingPanel;
    protected ResultsPanel resultsPanel;
    public static MainGUI _instance;
    private boolean modManagerOpened = false;
    private JTabbedPane tabbedPanel;

    public MainGUI() {
        Log.logger.info("Start MainGUI");
        if (RModule.getAvailableModules().size() == 0) {
            JOptionPane.showMessageDialog(null, "Scripts could not be loaded. We recommend using Menu > Tools > Reset User Scripts.");
        }
        this.setTitle(appName);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Main.endMain();
            }
        });
        this.setResizable(false);
        this.makeMenuBar();
        Panel contentPane = new Panel();
        contentPane.setLayout(new BorderLayout());
        this.tabbedPanel = new TabbedPane();
        this.tabbedPanel.setUI(new SubstanceTabbedPaneUI(){

            @Override
            protected int calculateTabWidth(int i, int i1, FontMetrics fm) {
                return 184;
            }
        });
        this.makeTabs();
        contentPane.add((Component)this.tabbedPanel, "Center");
        this.add(contentPane);
        this.pack();
        _instance = this;
        Main.logoLoadingFrame.setVisible(false);
        this.setLocationRelativeTo(null);
        this.setIconImage(MainGUI.getDefaultIcon(this));
    }

    public static MainGUI getInstance() {
        return _instance;
    }

    public static Image getDefaultIcon(Object receiver) {
        BufferedImage frameIcon = null;
        try {
            frameIcon = Resources.getImage(receiver.getClass(), "logo64.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.logger.info("Default ImageIcon not loaded");
        }
        return frameIcon;
    }

    public void makeTabs() {
        RModule.updateUserScripts();
        this.tabbedPanel.removeAll();
        this.tabbedPanel.setFocusable(false);
        this.tabbedPanel.setTabLayoutPolicy(1);
        this.analysisPanel = new NewAnalysisPanel(this);
        this.analysisPanel.setFocusable(false);
        this.processingPanel = new ProcessingPanel(this);
        this.processingPanel.setFocusable(false);
        this.resultsPanel = new ResultsPanel(this);
        this.resultsPanel.setFocusable(false);
        this.tabbedPanel.addTab("New Analysis", this.analysisPanel);
        this.tabbedPanel.addTab("Processing", this.processingPanel);
        this.tabbedPanel.addTab("Results", this.resultsPanel);
    }

    public void makeMenuBar() {
        JMenuBar bar = new JMenuBar();
        bar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        JMenuItem modules = new JMenuItem("Modules");
        modules.addActionListener(evt1 -> {
            if (!ProcessingPanel.isProcessing()) {
                if (!this.modManagerOpened) {
                    this.modManagerOpened = true;
                    new ModulesManager(this, true).setVisible(true);
                    this.modManagerOpened = false;
                }
            } else {
                MainGUI.showCannotDoThisWhileProcessing();
            }
        });
        JMenuItem interpreters = new JMenuItem("R Environments");
        interpreters.addActionListener(evt1 -> {
            if (!ProcessingPanel.isProcessing()) {
                this.analysisPanel.createButton.setEnabled(false);
                InterpreterManagerSwingDialog.openInterpreterManager(() -> {
                    Log.logger.info("Restarting AnalysisPanel");
                    this.analysisPanel.createInterface();
                    this.analysisPanel.createButton.setEnabled(true);
                    this.analysisPanel.updateUnabledScripts();
                });
            } else {
                MainGUI.showCannotDoThisWhileProcessing();
            }
        });
        JMenuItem resetScripts = new JMenuItem("Reset User Scripts");
        resetScripts.addActionListener(evt1 -> {
            if (!ProcessingPanel.isProcessing()) {
                int reply = JOptionPane.showConfirmDialog(null, "This will erase user created scripts, erase not saved results and close R-Peridot.", "Reset User Scripts", 0);
                if (reply == 0) {
                    MainGUI.close();
                }
            } else {
                MainGUI.showCannotDoThisWhileProcessing();
            }
        });
        JMenuItem refreshResults = new JMenuItem("Refresh Results");
        refreshResults.addActionListener(evt -> {
            if (!ProcessingPanel.isProcessing()) {
                MainGUI.updateResultsPanel();
            } else {
                MainGUI.showCannotDoThisWhileProcessing();
            }
        });
        toolsMenu.add(modules);
        toolsMenu.add(interpreters);
        toolsMenu.add(resetScripts);
        toolsMenu.add(refreshResults);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        JMenuItem about = new JMenuItem("About R-Peridot");
        about.setEnabled(Desktop.isDesktopSupported());
        about.addActionListener(evt -> {
            try {
                Desktop.getDesktop().browse(new URI(PeridotConfig.get().rPeridotWebSite + "about.html"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        JMenuItem developerManual = new JMenuItem("Guide for Advanced Usage");
        developerManual.setEnabled(true);
        developerManual.addActionListener(evt -> {
            File devManualFile = new File(Places.jarFolder + File.separator + "advanced_guide.pdf");
            Global.openFileWithSysApp(devManualFile);
            Log.logger.info("Opening " + devManualFile.getAbsolutePath());
        });
        JMenuItem userManual = new JMenuItem("User Guide");
        userManual.setEnabled(true);
        userManual.addActionListener(evt -> {
            File manualFile = new File(Places.jarFolder + File.separator + "user_guide.pdf");
            Global.openFileWithSysApp(manualFile);
            Log.logger.info("Opening " + manualFile.getAbsolutePath());
        });
        helpMenu.add(userManual);
        helpMenu.add(developerManual);
        helpMenu.add(about);
        bar.add(helpMenu);
        bar.add(toolsMenu);
        this.setJMenuBar(bar);
    }

    public static void showCannotDoThisWhileProcessing() {
        JOptionPane.showMessageDialog(_instance, "Cannot do this while processing the results", "Operation not permitted", 0);
    }

    public static void showRestartPeridotDialog() {
        JOptionPane.showMessageDialog(_instance, "Restart R-Peridot for changes to take effect", "Restart R-Peridot", 0);
    }

    public static boolean showYesNoDialog(String msg) {
        int reply = JOptionPane.showConfirmDialog(_instance, msg, "Yes or No?", 0);
        return reply == 0;
    }

    public static void goToAnalysisPanel() {
        MainGUI._instance.tabbedPanel.setSelectedComponent(MainGUI._instance.analysisPanel);
    }

    public static void goToProcessingPanel() {
        MainGUI._instance.tabbedPanel.setSelectedComponent(MainGUI._instance.processingPanel);
    }

    public static void goToResultsPanel() {
        MainGUI._instance.tabbedPanel.setSelectedComponent(MainGUI._instance.resultsPanel);
    }

    public static void updateModulesEnabled() {
        if (_instance != null && MainGUI._instance.analysisPanel != null) {
            MainGUI._instance.analysisPanel.updateUnabledScripts();
        }
    }

    public static void updateResultsPanel() {
        MainGUI._instance.resultsPanel.updateData();
    }

    public static void close() {
        _instance.dispatchEvent(new WindowEvent(_instance, 201));
    }

    public static void setComponentsEnabled(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enable);
        }
        container.setEnabled(enable);
    }
}

