/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.component;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import peridot.GUI.Aesthetics;
import peridot.Log;

public class Label
extends JLabel {
    public Label() {
        this.doStuff();
    }

    public Label(String string) {
        super(string);
        this.doStuff();
    }

    private void doStuff() {
        this.setFont(Aesthetics.defaultFont);
        this.setForeground(Color.white);
    }

    public static JLabel getImageLabel(File file) {
        ImageIcon imageIcon;
        try {
            imageIcon = new ImageIcon(ImageIO.read(file));
        }
        catch (IOException ex) {
            imageIcon = new ImageIcon(file.getAbsolutePath());
        }
        Image image = imageIcon.getImage();
        if (image.getWidth(null) >= 800) {
            Log.logger.info("Scaling down image with width of " + image.getWidth(null));
            int heightScale = 800 / image.getWidth(null);
            int newHeight = image.getHeight(null) * heightScale;
            if (newHeight <= 0) {
                newHeight = 800;
            }
            Image smallImg = image.getScaledInstance(800, newHeight, 4);
            imageIcon = new ImageIcon(smallImg);
        }
        JLabel img = new JLabel();
        img.setIcon(imageIcon);
        imageIcon.getImage().flush();
        return img;
    }
}

