/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.component;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import peridot.GUI.GUIUtils;
import peridot.GUI.MainGUI;
import peridot.GUI.NoHighlightCellRenderer;
import peridot.GUI.dialog.ScriptResultsDialog;

public class Table
extends JTable {
    public Table(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setDefaultRenderer(Object.class, new NoHighlightCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean success = false;
                if (e.getClickCount() >= 2) {
                    int row = Table.this.getSelectedRow();
                    String str = Table.this.getValueAt(row, 0).toString();
                    if (str != null) {
                        while (str.charAt(0) == ' ') {
                            str = str.substring(1, str.length());
                        }
                        while (str.charAt(str.length() - 1) == ' ') {
                            str = str.substring(0, str.length() - 1);
                        }
                        File file = ScriptResultsDialog.getCountPlotFile(str);
                        if (file != null) {
                            success = GUIUtils.showImageDialog(file);
                        }
                    }
                    if (!success) {
                        JOptionPane.showMessageDialog(MainGUI._instance, "This entry is not in the differential expression consensus.", "Counts plot not found!", 0);
                    }
                }
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

