/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.SystemUtils;
import peridot.AnalysisData;
import peridot.Archiver.Manager;
import peridot.Archiver.Places;
import peridot.Archiver.Spreadsheet;
import peridot.GUI.JTableUtils;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.WrapLayout;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BiggerLabel;
import peridot.GUI.component.Button;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.InputConditionNameDialog;
import peridot.GUI.dialog.MaxColumnsDialog;
import peridot.GUI.dialog.SpreadsheetInfoDialog;
import peridot.GUI.panel.ConditionPanel;
import peridot.Global;
import peridot.IndexedString;
import peridot.Log;
import peridot.script.r.Interpreter;
import peridot.script.r.Script;

public class NewExpressionDialog
extends Dialog {
    public boolean success;
    public AnalysisData expression;
    int thresholdMin = 1;
    int thresholdMax = 10;
    int threshold = 1;
    String roundingMode = "HALF_UP";
    String[] roundingModes = new String[]{"HALF_UP", "HALF_DOWN", "UP", "DOWN"};
    private File expressionFile;
    private File conditionsFile;
    private SortedMap<IndexedString, String> conditions;
    public boolean changedConditions = false;
    private HashMap<String, ConditionPanel> conditionPanels;
    private JButton addNewConditionButton;
    Frame parent;
    private static NewExpressionDialog _instance = null;
    private static File rawCountReadsFile = new File(Places.peridotDir.getAbsolutePath() + File.separator + "rawCountReads.tsv");
    private static File rawConditionsFile = new File(Places.peridotDir.getAbsolutePath() + File.separator + "rawConditions.tsv");
    private static File boxPlotFile = new File(Places.peridotDir.getAbsolutePath() + File.separator + "rawCountsBoxPlot.png");
    private static File boxPlotScript = new File(Places.modulesDir.getAbsolutePath() + File.separator + "boxPlot.R");
    boolean loadedFromPrevious = false;
    Spreadsheet.Info info;
    private static Dimension dialogSize = new Dimension(MainGUI.defaultSize.width + 100, 690);
    private static Dimension jSeparatorSize = new Dimension(NewExpressionDialog.dialogSize.width - 60, 3);
    private static Dimension adjustPanelSize = new Dimension(NewExpressionDialog.dialogSize.width - 20, NewExpressionDialog.dialogSize.height - 300);
    private static Dimension scrollPaneSize = new Dimension(NewExpressionDialog.adjustPanelSize.width - 10, NewExpressionDialog.adjustPanelSize.height - 30);
    public static Dimension conditionsPaneSize = new Dimension(NewExpressionDialog.scrollPaneSize.width - 50, NewExpressionDialog.scrollPaneSize.height + 10);
    private JPanel adjustPanel;
    private JPanel bottomButtonsPanel;
    private JButton cancelButton;
    private JPanel conditionsPane;
    private JScrollPane conditionsScrollPane;
    private JButton createButton;
    private JTextField expressionPathField;
    private JLabel geneExpressionLabel;
    private JTextField idAndConditionsField;
    private JLabel idAndConditionsLabel;
    private JLabel jLabel1;
    private JPanel labelsPanel;
    private JPanel pathsPanel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton selectConditionsFileButton;
    private JButton selectExpressionFileButton;
    private JPanel setFilesPanel;
    private JPanel roundingPanel;
    private JLabel roundingModesLabel;
    private JComboBox<String> roundingModesComboBox;
    private JPanel thresholdPanel;
    private JLabel thresholdLabel;
    private JSlider thresholdSlider;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private BiggerLabel boxPlotTitle;
    private Label boxPlotSubtitle;
    private JLabel boxPlot;

    public NewExpressionDialog(Frame parent, boolean modal, AnalysisData givenExpression) {
        super(parent, modal);
        this.parent = parent;
        this.initComponents();
        this.setFocusable(false);
        this.setTitle("Define Expression Data");
        this.setLocationRelativeTo(null);
        this.expressionPathField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewExpressionDialog.this.expressionFieldValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewExpressionDialog.this.expressionFieldValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewExpressionDialog.this.expressionFieldValueChanged();
            }
        });
        this.idAndConditionsField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewExpressionDialog.this.idAndConditionsFieldValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewExpressionDialog.this.idAndConditionsFieldValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewExpressionDialog.this.idAndConditionsFieldValueChanged();
            }
        });
        this.conditionPanels = new HashMap();
        this.addNewConditionButton = new Button();
        this.addNewConditionButton.setIcon(Resources.getImageIcon(this.getClass(), "Add-Green-Button-icon-32.png"));
        this.addNewConditionButton.setText("Add New Condition");
        this.addNewConditionButton.setPreferredSize(new Dimension(NewExpressionDialog.conditionsPaneSize.width - 50, 50));
        this.addNewConditionButton.setFocusable(false);
        this.addNewConditionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExpressionDialog.this.addNewConditionButtonActionPerformed(evt);
            }
        });
        this.expression = givenExpression;
        if (this.expression != null) {
            this.loadedFromPrevious = true;
            this.info = this.expression.info;
            if (this.expression.conditions != null) {
                this.conditions = this.expression.conditions;
            }
            this.expressionPathField.setText(this.expression.expressionFile.getAbsolutePath());
            this.expressionFile = this.expression.expressionFile;
            if (this.expression.conditionsFile != null) {
                this.idAndConditionsField.setText(this.expression.conditionsFile.getAbsolutePath());
                this.conditionsFile = this.expression.conditionsFile;
            }
            this.updateSetList();
        }
        _instance = this;
        this.success = false;
    }

    public static void setChangedConditions(boolean x) {
        NewExpressionDialog._instance.changedConditions = x;
    }

    public static void updateConditionName(String name, String newName) {
        NewExpressionDialog._instance.conditions = _instance.getConditionsFromUI();
        ConditionPanel conditionPanel = NewExpressionDialog._instance.conditionPanels.get(name);
        conditionPanel.setFocusable(false);
        NewExpressionDialog._instance.conditionPanels.remove(name);
        NewExpressionDialog._instance.conditionPanels.put(newName, conditionPanel);
        TreeSet<IndexedString> samplesToMove = new TreeSet<IndexedString>();
        for (Map.Entry<IndexedString, String> pair : NewExpressionDialog._instance.conditions.entrySet()) {
            if (!pair.getValue().equals(name)) continue;
            samplesToMove.add(pair.getKey());
        }
        for (IndexedString sample : samplesToMove) {
            NewExpressionDialog._instance.conditions.remove(sample);
        }
        for (IndexedString sample : samplesToMove) {
            NewExpressionDialog._instance.conditions.put(sample, newName);
        }
        NewExpressionDialog._instance.changedConditions = true;
        _instance.updateSetList();
    }

    private void updateSetList() {
        HashMap namesByCondition = new HashMap();
        this.conditionPanels.clear();
        this.conditionsPane.removeAll();
        for (Map.Entry<IndexedString, String> entry : this.conditions.entrySet()) {
            if (namesByCondition.containsKey(entry.getValue())) {
                ((LinkedList)namesByCondition.get(entry.getValue())).add(entry.getKey());
                continue;
            }
            namesByCondition.put(entry.getValue(), new LinkedList());
            ((LinkedList)namesByCondition.get(entry.getValue())).add(entry.getKey());
        }
        for (Map.Entry<IndexedString, String> entry : namesByCondition.entrySet()) {
            Object[] objArray = ((LinkedList)((Object)entry.getValue())).toArray();
            IndexedString[] arrayFinal = new IndexedString[objArray.length];
            for (int i = 0; i < objArray.length; ++i) {
                arrayFinal[i] = objArray[i] instanceof IndexedString ? (IndexedString)objArray[i] : new IndexedString(-1, "conversion-error-in:" + objArray[i].toString());
            }
            ConditionPanel conditionPanel = new ConditionPanel(arrayFinal, (String)((Object)entry.getKey()), true);
            conditionPanel.setFocusable(false);
            this.conditionPanels.put((String)((Object)entry.getKey()), conditionPanel);
            this.conditionsPane.add(conditionPanel);
        }
        if (!this.conditionPanels.containsKey("not-use")) {
            ConditionPanel conditionPanel = new ConditionPanel(new IndexedString[0], "not-use", false);
            conditionPanel.setFocusable(false);
            this.conditionPanels.put("not-use", conditionPanel);
            this.conditionsPane.add(conditionPanel);
        }
        this.conditionsPane.add(this.addNewConditionButton);
        this.conditionsPane.revalidate();
        this.conditionsPane.repaint();
    }

    private SortedMap<IndexedString, String> getConditionsFromUI() {
        TreeMap<IndexedString, String> newConditions = new TreeMap<IndexedString, String>();
        for (Map.Entry<String, ConditionPanel> pane : this.conditionPanels.entrySet()) {
            ListModel model = pane.getValue().contents.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Object value = model.getElementAt(i);
                if (!(value instanceof IndexedString)) continue;
                newConditions.put((IndexedString)value, pane.getKey());
            }
        }
        return newConditions;
    }

    private void loadBoxPlot(SortedMap<IndexedString, String> conditions) {
        try {
            AnalysisData expr = new AnalysisData(this.expressionFile, conditions, this.info, "DOWN", 1);
            expr.setCountReadsFile(rawCountReadsFile);
            expr.setConditionsFile(rawConditionsFile);
            expr.writeExpression();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        String[] args = new String[]{rawCountReadsFile.getAbsolutePath(), rawConditionsFile.getAbsolutePath(), boxPlotFile.getAbsolutePath()};
        Script boxPlotScript = new Script(NewExpressionDialog.boxPlotScript, args, false);
        try {
            boxPlotScript.run(Interpreter.defaultInterpreter, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.logger.info(boxPlotScript.getOutputString());
            return;
        }
        if (boxPlotFile.exists()) {
            Log.logger.info("Loading boxplot image into GUI");
            this.reloadRightPanel();
            this.rightPanel.repaint();
        } else {
            Log.logger.info("Boxplot file was not created.");
        }
    }

    private boolean selectExpressionByFile(String filePath) {
        File file = new File(filePath);
        if (file.canRead()) {
            if (Global.fileIsPlainText(file)) {
                File conditionsFile;
                if (this.info == null) {
                    try {
                        this.info = new Spreadsheet.Info(file);
                    }
                    catch (IOException ex) {
                        this.info = new Spreadsheet.Info(true, true, false, ",");
                    }
                }
                if ((conditionsFile = new File(file.getAbsolutePath() + ".conditions")).exists()) {
                    Log.logger.info("Loading conditions from saved .conditions file.");
                    this.conditions = AnalysisData.loadConditionsFromFile(conditionsFile);
                } else {
                    this.conditions = AnalysisData.getConditionsFromExpressionFile(file, this.info);
                }
                this.expressionFile = file;
                try {
                    this.loadBoxPlot(this.conditions);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Could not create box plot for this input data.");
                    ex.printStackTrace();
                    Log.logger.severe(ex.getMessage());
                }
                this.updateSetList();
                NewExpressionDialog.setChangedConditions(false);
                return true;
            }
            JOptionPane.showMessageDialog(null, "Please select a plain text spreadsheet file.");
        } else {
            JOptionPane.showMessageDialog(null, "The file can't be read.");
        }
        return false;
    }

    private boolean selectConditionsByFile(String filePath) {
        File file = new File(filePath);
        if (file.canRead()) {
            SortedMap<IndexedString, String> newConditions = AnalysisData.loadConditionsFromFile(file);
            for (Map.Entry<IndexedString, String> entry : newConditions.entrySet()) {
                this.conditions.put(entry.getKey(), entry.getValue());
            }
            this.conditionsFile = file;
            this.updateSetList();
            NewExpressionDialog.setChangedConditions(false);
            return true;
        }
        JOptionPane.showMessageDialog(null, "The file cant be read.");
        return false;
    }

    public void expressionFieldValueChanged() {
        if (this.loadedFromPrevious) {
            this.loadedFromPrevious = false;
            this.updateSetList();
            NewExpressionDialog.setChangedConditions(false);
        } else if (Manager.fileExists(this.expressionPathField.getText())) {
            this.selectExpressionByFile(this.expressionPathField.getText());
        }
    }

    public void idAndConditionsFieldValueChanged() {
        if (Manager.fileExists(this.idAndConditionsField.getText())) {
            this.selectConditionsByFile(this.idAndConditionsField.getText());
        }
    }

    private void initComponents() {
        this.setResizable(false);
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.adjustPanel = new Panel();
        this.jLabel1 = new Label();
        this.conditionsScrollPane = new JScrollPane();
        this.conditionsPane = new Panel();
        this.bottomButtonsPanel = new Panel();
        this.createButton = new BigButton();
        this.cancelButton = new BigButton();
        this.leftPanel = new Panel();
        this.rightPanel = new Panel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                NewExpressionDialog.this.success = false;
            }
        });
        this.setPreferredSize(new Dimension(NewExpressionDialog.dialogSize.width + 620, NewExpressionDialog.dialogSize.height));
        this.getContentPane().setLayout(new WrapLayout(0, 0, 0));
        this.leftPanel.setPreferredSize(new Dimension(NewExpressionDialog.dialogSize.width, NewExpressionDialog.dialogSize.height - 10));
        this.leftPanel.setLayout(new WrapLayout(1, 0, 5));
        this.rightPanel.setPreferredSize(new Dimension(610, 640));
        this.rightPanel.setLayout(new WrapLayout(1, 400, 5));
        this.makeSetFilesPanel();
        this.jSeparator1.setPreferredSize(jSeparatorSize);
        this.leftPanel.add(this.jSeparator1);
        this.adjustPanel.setPreferredSize(adjustPanelSize);
        this.jLabel1.setText("Adjust conditions of each sample (drag and drop):");
        this.adjustPanel.add(this.jLabel1);
        this.conditionsScrollPane.setFocusCycleRoot(false);
        this.conditionsScrollPane.setFocusTraversalPolicyProvider(true);
        this.conditionsScrollPane.setFocusable(false);
        this.conditionsScrollPane.setPreferredSize(scrollPaneSize);
        this.conditionsPane.setFocusable(false);
        this.conditionsPane.setMinimumSize(conditionsPaneSize);
        this.conditionsPane.setMaximumSize(new Dimension(NewExpressionDialog.conditionsPaneSize.width, 1930));
        this.conditionsPane.setLayout(new WrapLayout(1, 0, 3));
        this.conditionsScrollPane.setViewportView(this.conditionsPane);
        this.adjustPanel.add(this.conditionsScrollPane);
        this.leftPanel.add(this.adjustPanel);
        this.jSeparator2.setPreferredSize(jSeparatorSize);
        this.leftPanel.add(this.jSeparator2);
        this.roundingPanel = new Panel();
        this.roundingPanel.setPreferredSize(new Dimension(NewExpressionDialog.dialogSize.width, 30));
        this.roundingModesLabel = new Label("Integer rounding: ");
        this.roundingModesComboBox = new JComboBox();
        for (String s : this.roundingModes) {
            this.roundingModesComboBox.addItem(s);
        }
        this.roundingPanel.add(this.roundingModesLabel);
        this.roundingPanel.add(this.roundingModesComboBox);
        this.leftPanel.add(this.roundingPanel);
        this.thresholdPanel = new Panel();
        this.thresholdPanel.setPreferredSize(new Dimension(NewExpressionDialog.dialogSize.width, 80));
        this.thresholdLabel = new Label("Count reads threshold: ");
        this.thresholdSlider = new JSlider(0, this.thresholdMin, this.thresholdMax, this.threshold);
        this.thresholdSlider.setMajorTickSpacing(1);
        this.thresholdSlider.setMinorTickSpacing(1);
        this.thresholdSlider.setPaintTicks(true);
        this.thresholdSlider.setPaintLabels(true);
        this.thresholdPanel.add(this.thresholdLabel);
        this.thresholdPanel.add(this.thresholdSlider);
        this.leftPanel.add(this.thresholdPanel);
        this.jSeparator3.setPreferredSize(jSeparatorSize);
        this.leftPanel.add(this.jSeparator3);
        int usableHeight = 65;
        if (SystemUtils.IS_OS_WINDOWS) {
            usableHeight -= 20;
        }
        this.bottomButtonsPanel.setPreferredSize(new Dimension(NewExpressionDialog.dialogSize.width, usableHeight));
        this.bottomButtonsPanel.setLayout(new FlowLayout(2, 10, 0));
        this.createButton.setText("Create");
        this.createButton.setPreferredSize(new Dimension(100, this.bottomButtonsPanel.getPreferredSize().height - 10));
        this.createButton.addActionListener(evt -> this.createButtonActionPerformed(evt));
        this.bottomButtonsPanel.add(this.createButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(100, this.bottomButtonsPanel.getPreferredSize().height - 10));
        this.cancelButton.addActionListener(evt -> this.cancelButtonActionPerformed(evt));
        this.bottomButtonsPanel.add(this.cancelButton);
        this.leftPanel.add(this.bottomButtonsPanel);
        this.getContentPane().add(this.leftPanel);
        this.getContentPane().add(this.rightPanel);
        this.pack();
    }

    private void reloadRightPanel() {
        this.rightPanel.removeAll();
        this.boxPlotTitle = new BiggerLabel("Box Plot:");
        this.boxPlotSubtitle = new Label("         Distribution of counts in different samples.");
        this.boxPlot = Label.getImageLabel(boxPlotFile);
        this.rightPanel.add(this.boxPlotTitle);
        this.rightPanel.add(this.boxPlotSubtitle);
        this.rightPanel.add(this.boxPlot);
        this.rightPanel.repaint();
        this.rightPanel.revalidate();
        this.repaint();
        this.revalidate();
    }

    private void makeSetFilesPanel() {
        this.setFilesPanel = new Panel();
        Dimension size = new Dimension(NewExpressionDialog.dialogSize.width - 20, 60);
        this.setFilesPanel.setPreferredSize(size);
        FlowLayout flowLayout1 = new FlowLayout(0, 0, 0);
        flowLayout1.setAlignOnBaseline(true);
        this.setFilesPanel.setLayout(flowLayout1);
        Dimension labelsSize = new Dimension(160, 70);
        this.labelsPanel = new Panel();
        this.labelsPanel.setMinimumSize(new Dimension(labelsSize.width - 40, labelsSize.height - 10));
        this.labelsPanel.setPreferredSize(labelsSize);
        this.labelsPanel.setLayout(new FlowLayout(0, 0, 6));
        this.geneExpressionLabel = new Label();
        this.geneExpressionLabel.setText("Count reads:");
        this.idAndConditionsLabel = new Label();
        this.idAndConditionsLabel.setText("Conditions (optional):");
        this.labelsPanel.add(this.geneExpressionLabel);
        this.labelsPanel.add(this.idAndConditionsLabel);
        Dimension pathsSize = new Dimension(size.width - labelsSize.width - 10, labelsSize.height);
        this.pathsPanel = new Panel();
        this.pathsPanel.setPreferredSize(pathsSize);
        this.pathsPanel.setRequestFocusEnabled(false);
        this.pathsPanel.setLayout(new FlowLayout(2, 0, 0));
        this.expressionPathField = new JTextField();
        this.expressionPathField.setPreferredSize(new Dimension(pathsSize.width - 50, 25));
        this.expressionPathField.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                NewExpressionDialog.this.expressionPathFieldInputMethodTextChanged(evt);
            }

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }
        });
        this.expressionPathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExpressionDialog.this.expressionPathFieldActionPerformed(evt);
            }
        });
        this.expressionPathField.setEditable(false);
        this.selectExpressionFileButton = new Button();
        this.selectExpressionFileButton.setText("");
        this.selectExpressionFileButton.setPreferredSize(new Dimension(40, 25));
        this.selectExpressionFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExpressionDialog.this.selectExpressionFileButtonActionPerformed(evt);
            }
        });
        this.selectExpressionFileButton.setIcon(Resources.getImageIcon(this.getClass(), "open-icon-24.png"));
        this.idAndConditionsField = new JTextField();
        this.idAndConditionsField.setPreferredSize(new Dimension(pathsSize.width - 50, 25));
        this.idAndConditionsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExpressionDialog.this.idAndConditionsFieldActionPerformed(evt);
            }
        });
        this.idAndConditionsField.setEditable(false);
        this.idAndConditionsField.setEnabled(false);
        this.selectConditionsFileButton = new Button();
        this.selectConditionsFileButton.setText("");
        this.selectConditionsFileButton.setPreferredSize(new Dimension(40, 25));
        this.selectConditionsFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExpressionDialog.this.selectConditionsFileButtonActionPerformed(evt);
            }
        });
        this.selectConditionsFileButton.setEnabled(false);
        this.selectConditionsFileButton.setIcon(Resources.getImageIcon(this.getClass(), "open-icon-24.png"));
        this.pathsPanel.add(this.expressionPathField);
        this.pathsPanel.add(this.selectExpressionFileButton);
        this.pathsPanel.add(this.idAndConditionsField);
        this.pathsPanel.add(this.selectConditionsFileButton);
        this.setFilesPanel.add(this.labelsPanel);
        this.setFilesPanel.add(this.pathsPanel);
        this.leftPanel.add(this.setFilesPanel);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.success = false;
        this.setVisible(false);
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        this.conditions = this.getConditionsFromUI();
        if (this.expressionFile != null) {
            this.setVisible(false);
            this.success = true;
        } else {
            JOptionPane.showMessageDialog(null, "Firstly, you must select a genetic expression file.");
        }
    }

    public AnalysisData getResults() {
        if (this.expressionFile == null) {
            return null;
        }
        try {
            AnalysisData expr = new AnalysisData(this.expressionFile, this.getConditionsFromUI(), this.info, this.roundingModesComboBox.getItemAt(this.roundingModesComboBox.getSelectedIndex()), this.thresholdSlider.getValue());
            return expr;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Errors while reading count reads table.");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void selectConditionsFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.isFile()) {
                    return;
                }
                super.approveSelection();
            }
        };
        if (fileChooser.showDialog(null, "Open File") == 0) {
            String filePath = fileChooser.getSelectedFile().getAbsolutePath();
            this.idAndConditionsField.setText(filePath);
        }
    }

    private void selectExpressionFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.isFile() || !f.exists()) {
                    return;
                }
                super.approveSelection();
            }
        };
        if (fileChooser.showDialog(null, "Open File") == 0) {
            String filePath;
            block5: {
                filePath = fileChooser.getSelectedFile().getAbsolutePath();
                try {
                    SpreadsheetInfoDialog dialog = new SpreadsheetInfoDialog((Frame)MainGUI._instance, fileChooser.getSelectedFile());
                    dialog.setVisible(true);
                    if (dialog.cancel) {
                        return;
                    }
                    Spreadsheet.Info info = dialog.table.getInfo();
                    if (JTableUtils.tableOverColumnLimit(new File(filePath), info.separator)) {
                        MaxColumnsDialog dialogMax = new MaxColumnsDialog(this.parent);
                        dialogMax.setVisible(true);
                    }
                    this.info = info;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (this.info == null) break block5;
                    Log.logger.severe("Error while getting user info for count reads file!");
                }
            }
            this.expressionPathField.setText(filePath);
            this.idAndConditionsField.setText(filePath + ".conditions");
            this.idAndConditionsField.setEnabled(true);
            this.selectConditionsFileButton.setEnabled(true);
        }
    }

    private void expressionPathFieldInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void expressionPathFieldActionPerformed(ActionEvent evt) {
        this.expressionFieldValueChanged();
    }

    private void idAndConditionsFieldActionPerformed(ActionEvent evt) {
        this.idAndConditionsFieldValueChanged();
    }

    private void addNewConditionButtonActionPerformed(ActionEvent evt) {
        this.conditionsPane.remove(this.addNewConditionButton);
        int newIndex = 1;
        while (this.conditionPanels.containsKey("condition" + Integer.toString(newIndex))) {
            ++newIndex;
        }
        ConditionPanel conditionPanel = new ConditionPanel(new IndexedString[0], "condition" + Integer.toString(newIndex), true);
        conditionPanel.setFocusable(false);
        this.conditionPanels.put("condition" + Integer.toString(newIndex), conditionPanel);
        this.conditionsPane.add(conditionPanel);
        this.conditionsPane.add(this.addNewConditionButton);
        this.conditionsPane.revalidate();
        this.conditionsPane.repaint();
    }

    public static String inputConditionName(String oldName) {
        InputConditionNameDialog dialog = new InputConditionNameDialog(NewExpressionDialog._instance.parent, oldName);
        dialog.setVisible(true);
        return dialog.getInput();
    }
}

