/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import peridot.GUI.component.Dialog;
import peridot.Output;

public class ScriptOutputDialog
extends Dialog {
    JScrollPane scrollPanel;
    JPanel textPanel;
    JTextArea textArea;
    Output buffer;
    Thread updater;
    public AtomicBoolean stopFlag;
    public AtomicBoolean newTextFlag;

    public ScriptOutputDialog(Frame parent, boolean modal, String scriptName, Output buffer) {
        super(parent, modal);
        this.setTitle(scriptName);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(550, 550));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.buffer = buffer;
        this.buffer.setText("");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Ubuntu Mono", 0, 12));
        this.textArea.setLineWrap(true);
        this.scrollPanel = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)this.scrollPanel, "Center");
        this.pack();
        this.stopFlag = new AtomicBoolean(false);
        this.newTextFlag = new AtomicBoolean(false);
        this.updater = new Thread(() -> {
            int oldLength = buffer.getText().length();
            while (!this.stopFlag.get()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                if (oldLength < buffer.getText().length()) {
                    this.updateText();
                }
                oldLength = buffer.getText().length();
            }
        });
        this.updater.start();
    }

    public void stop() {
        this.stopFlag.set(true);
    }

    public void updateText() {
        SwingUtilities.invokeLater(() -> this.textArea.setText(this.buffer.getText()));
    }

    public void appendLine(String text) {
        this.buffer.appendLine(text);
        this.updateText();
    }

    public void appendChar(char text) {
        this.buffer.appendChar(text);
        SwingUtilities.invokeLater(() -> this.textArea.append("" + text));
    }

    public void setText(String text) {
        this.buffer.setText(text);
        this.updateText();
    }

    public String getText() {
        return this.buffer.getText();
    }
}

