/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog;

import java.awt.CardLayout;
import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import peridot.GUI.component.Dialog;
import peridot.GUI.panel.ViewResultsPanel;
import peridot.Log;
import peridot.script.RModule;

public class ScriptResultsDialog
extends Dialog {
    private static HashMap<String, File> countPlots = null;
    ViewResultsPanel results;

    public static void cleanCountPlots() {
        if (countPlots != null) {
            countPlots.clear();
        }
    }

    public static void fillCountPlots(File vennDiagramDir) {
        countPlots = new HashMap();
        File countPlotsDir = new File(vennDiagramDir.getAbsolutePath() + File.separator + "countPlots");
        File[] files = countPlotsDir.listFiles();
        if (files != null && files.length >= 1) {
            for (File file : files) {
                if (!file.isFile()) continue;
                String fileName = file.getName();
                fileName = fileName.substring(0, fileName.length() - 4);
                countPlots.put(fileName, file);
            }
        }
    }

    public static File getCountPlotFile(String key) {
        if (countPlots != null) {
            if (countPlots.containsKey(key)) {
                return countPlots.get(key);
            }
            Log.logger.info("Could not find " + key);
            return null;
        }
        Log.logger.info("Count plots not listed yet.");
        return null;
    }

    public ScriptResultsDialog(Frame parent, boolean modal, String scriptName, File resultsDir) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(scriptName + " results");
        this.results = new ViewResultsPanel(scriptName, resultsDir, RModule.getAvailableAnalysisModules().contains(scriptName));
        this.getContentPane().add(this.results);
        this.pack();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new CardLayout());
        this.pack();
    }
}

