/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import peridot.Archiver.Spreadsheet;
import peridot.GUI.JTableUtils;
import peridot.GUI.WrapLayout;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BiggerLabel;
import peridot.GUI.component.CheckBox;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.component.RadioButton;
import peridot.GUI.component.Table;
import peridot.Log;

public class SpreadsheetInfoDialog
extends JDialog {
    public Spreadsheet table;
    public File file;
    public String separator;
    public boolean cancel = false;
    private boolean loadingInfo = true;
    private CheckBox headerOnFirstLine;
    private CheckBox labelsOnFirstColumn;
    private RadioButton tab;
    private RadioButton space;
    private RadioButton comma;
    private RadioButton semicolon;
    private RadioButton custom;
    private JTextField customSep;
    private ButtonGroup sepOptions;
    private Table dataTable;
    private JScrollPane scroller;
    private BiggerLabel titleLabel;
    private BigButton okButton;
    private Panel upperPanel;
    private Panel middlePanel;
    private Panel checkBoxesPanel;
    private Panel sepOptionsPanel;
    private Panel bottomPanel;

    public SpreadsheetInfoDialog(Frame parent, File file) {
        super(parent, true);
        Log.logger.info("Starting Spreadsheet Info Dialog");
        try {
            this.table = new Spreadsheet(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.file = file;
        this.initComponents();
        this.loadingInfo = false;
    }

    public void initComponents() {
        this.initBasicComponents();
        this.initUpperPanel();
        this.initMiddlePanel();
        this.initBottomPanel();
        this.add((Component)this.middlePanel, "Center");
        this.add((Component)this.bottomPanel, "Last");
        this.revalidate();
        this.repaint();
    }

    public void initBasicComponents() {
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(650, 400));
        this.setMinimumSize(this.getPreferredSize());
        this.getContentPane().setLayout(new BorderLayout(30, 5));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        String question = "Give us some info on this data: ";
        this.setTitle(question);
        this.titleLabel = new BiggerLabel(question);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SpreadsheetInfoDialog.this.cancel = true;
                SpreadsheetInfoDialog.this.setVisible(false);
            }
        });
    }

    public void loadTableInScroller() {
        List<String[]> rows = this.table.getRows(100);
        this.dataTable = JTableUtils.getTableWithoutHeader(rows, false, 9, 100);
        this.scroller = new JScrollPane(this.dataTable);
        this.scroller.getViewport().setBackground(Color.white);
        this.scroller.setPreferredSize(new Dimension(this.getPreferredSize().width - 50, 200));
    }

    public void initOkButton() {
        this.okButton = new BigButton();
        this.okButton.setText("OK");
        this.okButton.addActionListener(evt -> {
            this.table.getInfo().setHeaderOnFirstLine(this.headerOnFirstLine.isSelected());
            this.table.getInfo().setLabelsOnFirstCol(this.labelsOnFirstColumn.isSelected());
            this.table.setSeparator(this.separator);
            this.setVisible(false);
        });
    }

    public void initCheckBoxes() {
        this.checkBoxesPanel = new Panel();
        this.checkBoxesPanel.setLayout(new FlowLayout(1, 5, 0));
        this.headerOnFirstLine = new CheckBox("Header on the first row");
        this.headerOnFirstLine.setSelected(false);
        if (this.table.getInfo().getHeaderOnFirstLine()) {
            this.headerOnFirstLine.doClick();
        }
        this.labelsOnFirstColumn = new CheckBox("Labels on first column");
        if (this.table.getInfo().getLabelsOnFirstCol()) {
            this.labelsOnFirstColumn.doClick();
        }
        this.checkBoxesPanel.add(this.headerOnFirstLine);
        this.checkBoxesPanel.add(this.labelsOnFirstColumn);
        this.checkBoxesPanel.setPreferredSize(new Dimension(550, 30));
    }

    private void sepOptionAction() {
        if (!this.loadingInfo) {
            this.getSeparatorFromGUI();
            this.initUpperPanel();
        }
    }

    public void initSepOptions() {
        String sepFromInfo;
        this.separator = sepFromInfo = this.table.getSeparator();
        this.comma = new RadioButton("Comma ','");
        this.semicolon = new RadioButton("Semicolon ';'");
        this.space = new RadioButton("Space '   '");
        this.tab = new RadioButton("Tab '\\t'");
        this.custom = new RadioButton("Other: ");
        this.comma.addActionListener(evt -> this.sepOptionAction());
        this.semicolon.addActionListener(evt -> this.sepOptionAction());
        this.space.addActionListener(evt -> this.sepOptionAction());
        this.tab.addActionListener(evt -> this.sepOptionAction());
        this.custom.addActionListener(evt -> this.sepOptionAction());
        this.sepOptions = new ButtonGroup();
        this.sepOptions.add(this.comma);
        this.sepOptions.add(this.semicolon);
        this.sepOptions.add(this.space);
        this.sepOptions.add(this.tab);
        this.sepOptions.add(this.custom);
        this.customSep = new JTextField(4);
        this.sepOptionsPanel = new Panel();
        this.sepOptionsPanel.setLayout(new FlowLayout(1, 4, 2));
        this.sepOptionsPanel.add(this.tab);
        this.sepOptionsPanel.add(this.space);
        this.sepOptionsPanel.add(this.comma);
        this.sepOptionsPanel.add(this.semicolon);
        this.sepOptionsPanel.add(this.custom);
        this.sepOptionsPanel.add(this.customSep);
        this.sepOptionsPanel.setPreferredSize(new Dimension(550, 30));
        if (sepFromInfo.equals("\t")) {
            this.tab.doClick();
        } else if (sepFromInfo.equals(" ")) {
            this.space.doClick();
        } else if (sepFromInfo.equals(",")) {
            this.comma.doClick();
        } else if (sepFromInfo.equals(";")) {
            this.semicolon.doClick();
        } else {
            this.custom.doClick();
            this.customSep.setText(sepFromInfo);
        }
    }

    private void initUpperPanel() {
        if (this.upperPanel != null) {
            this.remove(this.upperPanel);
        }
        this.upperPanel = new Panel();
        this.upperPanel.setLayout(new WrapLayout(1, 0, 4));
        this.loadTableInScroller();
        this.upperPanel.add(this.titleLabel);
        this.upperPanel.add(this.scroller);
        this.add((Component)this.upperPanel, "First");
        this.revalidate();
        this.repaint();
    }

    private void initMiddlePanel() {
        this.middlePanel = new Panel();
        this.middlePanel.setLayout(new WrapLayout(1, 0, 5));
        this.initCheckBoxes();
        this.initSepOptions();
        this.middlePanel.add(this.checkBoxesPanel);
        this.middlePanel.add(new Label("Column Separator: "));
        this.middlePanel.add(this.sepOptionsPanel);
    }

    private void initBottomPanel() {
        this.bottomPanel = new Panel();
        this.bottomPanel.setLayout(new WrapLayout());
        this.initOkButton();
        this.bottomPanel.add((Component)this.okButton, "Last");
    }

    private void getSeparatorFromGUI() {
        String sep = this.comma.isSelected() ? "," : (this.tab.isSelected() ? "\t" : (this.semicolon.isSelected() ? ";" : (this.space.isSelected() ? " " : this.customSep.getText())));
        this.separator = sep;
        this.table.setSeparator(this.separator);
        Log.logger.info("Separator is '" + sep + "'");
    }
}

