/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import peridot.Archiver.Places;
import peridot.GUI.GUIUtils;
import peridot.GUI.component.Dialog;
import peridot.script.RModule;

public class GetFileFromTreeDialog
extends Dialog {
    public TreeNode[] selected = null;

    public GetFileFromTreeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Select a file:");
        Dimension dialogSize = new Dimension(250, 500);
        Dimension scrollerSize = new Dimension(230, 480);
        this.setMinimumSize(dialogSize);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new FlowLayout(1, 0, 0));
        JTree tree = this.getTreeOfFiles();
        JScrollPane treeView = new JScrollPane(tree);
        treeView.setPreferredSize(scrollerSize);
        this.add(treeView);
        Dimension loc = GUIUtils.getCenterLocation(dialogSize.width, dialogSize.height);
        this.setLocation(loc.width, loc.height);
    }

    public static String getAResult(Frame parent, boolean modal) {
        GetFileFromTreeDialog dialog = new GetFileFromTreeDialog(parent, modal);
        dialog.setVisible(true);
        TreeNode[] nodes = dialog.selected;
        if (nodes == null) {
            return null;
        }
        if (nodes.length == 2) {
            return nodes[1].toString();
        }
        if (nodes.length >= 3) {
            String result = nodes[1].toString() + ": ";
            for (int i = 2; i < nodes.length; ++i) {
                if (i > 2) {
                    result = result + "/";
                }
                result = result + nodes[i].toString();
            }
            return result;
        }
        return null;
    }

    private JTree getTreeOfFiles() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("results/");
        top.add(new DefaultMutableTreeNode(Places.countReadsInputFile.getName()));
        top.add(new DefaultMutableTreeNode(Places.conditionInputFile.getName()));
        for (String modName : RModule.getAvailableAnalysisModules()) {
            top.add(this.moduleToTreeNode(modName));
        }
        for (String modName : RModule.getAvailablePostAnalysisModules()) {
            top.add(this.moduleToTreeNode(modName));
        }
        JTree tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node;
            if (tree.getSelectionCount() > 0 && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()).isLeaf()) {
                this.selected = node.getPath();
                this.setVisible(false);
            }
        });
        return tree;
    }

    private DefaultMutableTreeNode moduleToTreeNode(String module) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(module);
        RModule script = RModule.availableModules.get(module);
        DefaultMutableTreeNode child = null;
        for (String result : script.results) {
            child = new DefaultMutableTreeNode(result);
            top.add(child);
        }
        return top;
    }
}

