/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import peridot.GUI.GUIUtils;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.CheckBox;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Label;
import peridot.Log;

public class GetNewResultDialog
extends Dialog {
    public String name;
    public boolean mandatory;
    private String defaultToolTip = "[result file name here]";
    private String invalidNameToolTip = "[invalid file name!]";
    private JLabel descriptionLabel;
    private JTextField nameField;
    private JCheckBox mandatoryCheckBox;
    private JButton addButton;

    public GetNewResultDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mandatory = false;
        this.name = null;
        this.build();
    }

    public GetNewResultDialog(Frame parent, boolean modal, String name, boolean mandatory) {
        super(parent, modal);
        this.mandatory = mandatory;
        this.name = name;
        this.build();
    }

    private void build() {
        Dimension dialogSize = new Dimension(250, 140);
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new FlowLayout(1, 0, 0));
        this.setMinimumSize(dialogSize);
        this.setResizable(false);
        this.setTitle("New Result Dialog");
        this.descriptionLabel = new Label("Insert the name of a script result file: ");
        this.nameField = new JTextField();
        if (this.name != null) {
            this.nameField.setText(this.name);
        } else {
            this.nameField.setText(this.defaultToolTip);
        }
        this.nameField.setPreferredSize(new Dimension(230, 25));
        this.nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GetNewResultDialog.this.nameField.getText().equals(GetNewResultDialog.this.defaultToolTip) || GetNewResultDialog.this.nameField.getText().equals(GetNewResultDialog.this.invalidNameToolTip)) {
                    GetNewResultDialog.this.nameField.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.mandatoryCheckBox = new CheckBox();
        this.mandatoryCheckBox.setText("Mandatory result");
        if (this.mandatory) {
            this.mandatoryCheckBox.doClick();
        }
        this.addButton = new BigButton();
        this.addButton.setText("Add to results");
        this.addButton.addActionListener(evt -> {
            this.mandatory = this.mandatoryCheckBox.isSelected();
            this.name = this.nameField.getText();
            try {
                if (this.name == null) {
                    throw new InvalidPathException("", "");
                }
                if (this.name.length() <= 1 || this.name.equals(this.invalidNameToolTip) || this.name.equals(this.defaultToolTip)) {
                    throw new InvalidPathException(this.name, this.name);
                }
                Path path = Paths.get(this.name, new String[0]);
                this.setVisible(false);
            }
            catch (Exception ex) {
                this.name = null;
                Log.logger.warning("Not a valid file name. Try a different name for your result.");
                this.nameField.setText(this.invalidNameToolTip);
            }
        });
        this.addButton.setPreferredSize(new Dimension(120, 35));
        this.mandatoryCheckBox.requestFocus();
        this.add(this.descriptionLabel);
        this.add(this.nameField);
        this.add(this.mandatoryCheckBox);
        this.add(this.addButton);
        Dimension loc = GUIUtils.getCenterLocation(dialogSize.width, dialogSize.height);
        this.setLocation(loc.width, loc.height);
    }

    public boolean validInfo() {
        return this.name != null;
    }
}

