/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import peridot.GUI.GUIUtils;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.Button;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.Global;
import peridot.script.RModule;
import peridot.script.r.Package;

public class ModuleDetailsDialog
extends Dialog {
    RModule script;
    String info;
    Panel generalInfoPanel;
    Label scriptNameLabel;
    Label fileNameLabel;
    Button openFileButton;
    Label max2CondLabel;
    Label needsReplicatesLabel;
    Panel resultsPanel;
    Label resultsLabel;
    JScrollPane resultsScroller;
    JList resultsList;
    Panel inputPanel;
    Label inputLabel;
    JScrollPane inputScroller;
    JList inputList;
    Panel paramsPanel;
    Label paramsLabel;
    JScrollPane paramsScroller;
    JList paramsList;
    Panel packagesPanel;
    Label packagesLabel;
    JScrollPane packagesScroller;
    JList packagesList;
    JTextArea infoArea;
    JScrollPane infoScroller;
    Dimension dialogSize;
    Dimension availableSize;
    Dimension defaultPanelSize;
    Dimension scrollerSize;
    int componentPanelHeight;
    int componentPanelWidth;

    public ModuleDetailsDialog(String scriptName, Frame parent, boolean modal) {
        super(parent, modal);
        this.script = RModule.availableModules.get(scriptName);
        this.info = this.script.info;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(this.script.name + " Details");
        this.dialogSize = new Dimension(560, 685);
        int wGap = 5;
        int hGap = 5;
        this.availableSize = new Dimension(this.dialogSize.width - 20, this.dialogSize.height - 20);
        this.componentPanelHeight = (this.availableSize.height - hGap * 2 - 20) / 3;
        this.componentPanelWidth = (this.availableSize.width - wGap) / 2;
        this.scrollerSize = new Dimension(this.componentPanelWidth, this.componentPanelHeight - 35);
        this.defaultPanelSize = new Dimension(this.componentPanelWidth, this.componentPanelHeight);
        this.setMinimumSize(this.dialogSize);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new FlowLayout(1, wGap, hGap));
        this.setResizable(false);
        this.initGeneralInfo();
        this.initResults();
        this.initInputs();
        this.initParams();
        this.initPackages();
        this.initInfoArea();
        this.add(this.generalInfoPanel);
        this.add(this.resultsPanel);
        this.add(this.inputPanel);
        this.add(this.paramsPanel);
        this.add(this.packagesPanel);
        this.add(this.infoScroller);
        Dimension loc = GUIUtils.getCenterLocation(this.dialogSize.width, this.dialogSize.height);
        this.setLocation(loc.width, loc.height);
    }

    private void initGeneralInfo() {
        this.generalInfoPanel = new Panel();
        this.generalInfoPanel.setLayout(new BoxLayout(this.generalInfoPanel, 3));
        this.generalInfoPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.generalInfoPanel.setAlignmentX(0.5f);
        this.scriptNameLabel = new Label("Name: " + this.script.name);
        this.scriptNameLabel.setAlignmentX(0.5f);
        this.fileNameLabel = new Label("Filename: " + this.script.getScriptFile().getName());
        this.fileNameLabel.setAlignmentX(0.5f);
        this.openFileButton = new Button();
        this.openFileButton.addActionListener(evt -> Global.openFileWithSysApp(this.script.getScriptFile()));
        this.openFileButton.setAlignmentX(0.5f);
        this.openFileButton.setText("  Open " + this.script.getScriptFile().getName() + "  ");
        this.openFileButton.setMinimumSize(new Dimension(150, 45));
        this.openFileButton.setFocusable(false);
        this.max2CondLabel = new Label("Maximum of 2 conditions: " + this.script.max2Conditions);
        this.max2CondLabel.setAlignmentX(0.5f);
        this.needsReplicatesLabel = new Label("Needs replicates: " + this.script.needsReplicates);
        this.needsReplicatesLabel.setAlignmentX(0.5f);
        this.generalInfoPanel.add(Box.createVerticalGlue());
        this.generalInfoPanel.add(this.scriptNameLabel);
        this.generalInfoPanel.add(this.fileNameLabel);
        this.generalInfoPanel.add(this.openFileButton);
        this.generalInfoPanel.add(this.max2CondLabel);
        this.generalInfoPanel.add(this.needsReplicatesLabel);
        this.generalInfoPanel.add(Box.createVerticalGlue());
    }

    private String[] getResultsArray() {
        String[] array = new String[this.script.results.size()];
        int counter = 0;
        for (String s : this.script.results) {
            array[counter] = this.script.mandatoryResults.contains(s) ? s + " (mandatory)" : s;
            ++counter;
        }
        return array;
    }

    private void initResults() {
        this.resultsList = new JList<String>(this.getResultsArray());
        this.resultsList.setSelectionMode(0);
        this.resultsList.setLayoutOrientation(0);
        this.resultsList.setVisibleRowCount(-1);
        this.resultsLabel = new BigLabel("Results: ");
        this.resultsPanel = new Panel();
        this.resultsPanel.setLayout(new FlowLayout(1, 1, 5));
        this.resultsPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.resultsScroller = new JScrollPane(this.resultsList);
        this.resultsScroller.setPreferredSize(new Dimension(this.scrollerSize.width, this.scrollerSize.height));
        this.resultsPanel.add(this.resultsLabel);
        this.resultsPanel.add(this.resultsScroller);
    }

    private void initInputs() {
        this.inputList = new JList<Object>(this.script.getInputFiles());
        this.inputList.setSelectionMode(0);
        this.inputList.setLayoutOrientation(0);
        this.inputList.setVisibleRowCount(-1);
        this.inputLabel = new BigLabel("Input Files: ");
        this.inputPanel = new Panel();
        this.inputPanel.setLayout(new FlowLayout(1, 1, 5));
        this.inputPanel.setPreferredSize(this.defaultPanelSize);
        this.inputScroller = new JScrollPane(this.inputList);
        this.inputScroller.setPreferredSize(this.scrollerSize);
        this.inputPanel.add(this.inputLabel);
        this.inputPanel.add(this.inputScroller);
    }

    private void initPackages() {
        String[] packStrs = new String[this.script.requiredPackages.size()];
        int i = 0;
        for (Package pack : this.script.requiredPackages) {
            packStrs[i] = pack.name + " " + pack.version.toString();
            ++i;
        }
        this.packagesList = new JList<String>(packStrs);
        this.packagesList.setSelectionMode(0);
        this.packagesList.setLayoutOrientation(0);
        this.packagesList.setVisibleRowCount(-1);
        this.packagesLabel = new BigLabel("Required Packages:");
        this.packagesPanel = new Panel();
        this.packagesPanel.setLayout(new FlowLayout(1, 1, 5));
        this.packagesPanel.setPreferredSize(this.defaultPanelSize);
        this.packagesScroller = new JScrollPane(this.packagesList);
        this.packagesScroller.setPreferredSize(this.scrollerSize);
        this.packagesPanel.add(this.packagesLabel);
        this.packagesPanel.add(this.packagesScroller);
    }

    private void initParams() {
        this.paramsList = new JList<String>(this.script.getParamsDescription());
        this.paramsList.setSelectionMode(0);
        this.paramsList.setLayoutOrientation(0);
        this.paramsList.setVisibleRowCount(-1);
        this.paramsLabel = new BigLabel("Parameters: ");
        this.paramsPanel = new Panel();
        this.paramsPanel.setLayout(new FlowLayout(1, 1, 5));
        this.paramsPanel.setPreferredSize(this.defaultPanelSize);
        this.paramsScroller = new JScrollPane(this.paramsList);
        this.paramsScroller.setPreferredSize(this.scrollerSize);
        this.paramsPanel.add(this.paramsLabel);
        this.paramsPanel.add(this.paramsScroller);
    }

    private void initInfoArea() {
        this.infoArea = new JTextArea();
        this.infoArea.setText(this.info);
        this.infoArea.setEditable(false);
        this.infoArea.setFont(new Font("Ubuntu", 0, 14));
        this.infoArea.setLineWrap(true);
        this.infoArea.setWrapStyleWord(true);
        this.infoScroller = new JScrollPane(this.infoArea);
        this.infoScroller.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight - 10));
    }
}

