/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import peridot.Archiver.Persistence;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.modulesManager.AskModuleType;
import peridot.GUI.dialog.modulesManager.ModuleDetailsDialog;
import peridot.GUI.dialog.modulesManager.NewModuleDialog;
import peridot.Log;
import peridot.Operations;
import peridot.script.AnalysisModule;
import peridot.script.PostAnalysisModule;
import peridot.script.RModule;

public class ModulesManager
extends Dialog {
    public String selectedScript = "";
    Dimension dialogSize;
    Dimension containerSize;
    Dimension scrollerSize;
    Dimension buttonSize;
    Dimension buttonContainerSize;
    int wGap;
    int hGap;
    private Panel modulesContainer;
    private Panel buttonsContainer;
    private Panel analysisModListContainer;
    private Panel postAnalysisModListContainer;
    private BigLabel analysisModLabel;
    private BigLabel postAnalysisModLabel;
    private BigButton addButton;
    private BigButton editButton;
    private BigButton detailsButton;
    private BigButton deleteButton;
    private BigButton importButton;
    private BigButton exportButton;
    public static final String mandatoryString = " (mandatory)";

    public ModulesManager(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.init();
    }

    private void init() {
        this.wGap = 3;
        this.hGap = 3;
        this.containerSize = new Dimension(210, 200);
        this.scrollerSize = new Dimension(this.containerSize.width - 10, this.containerSize.height - 30);
        this.buttonContainerSize = new Dimension(this.containerSize.width - 30, this.containerSize.height);
        this.buttonSize = new Dimension(this.buttonContainerSize.width - 5, (this.containerSize.height - this.hGap * 5) / 6 - 2);
        this.dialogSize = new Dimension(this.containerSize.width * 2 + this.buttonContainerSize.width + this.wGap * 2 + 110, this.containerSize.height + 37);
        this.setTitle("Modules Manager");
        this.setIconImage(this.getDefaultIcon());
        this.setMinimumSize(this.dialogSize);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new FlowLayout(1, this.wGap, 1));
        this.setResizable(false);
        MainGUI.getInstance();
        this.setIconImage(MainGUI.getDefaultIcon(this));
        this.makeModulesContainer();
        this.makeButtonsContainer();
        this.add(this.modulesContainer);
        this.add(this.buttonsContainer);
        this.setLocationRelativeTo(null);
    }

    public Image getDefaultIcon() {
        BufferedImage frameIcon = null;
        try {
            frameIcon = Resources.getImage(this.getClass(), "logo64.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.logger.info("Default ImageIcon not loaded");
        }
        return frameIcon;
    }

    private void makeModulesContainer() {
        this.modulesContainer = new Panel();
        this.modulesContainer.setLayout(new FlowLayout(1, 5, 1));
        JList<String> list = new JList<String>(RModule.getAvailableAnalysisModules());
        JList<String> list2 = new JList<String>(RModule.getAvailablePostAnalysisModules());
        this.analysisModListContainer = new Panel();
        this.analysisModListContainer.setLayout(new FlowLayout(1, 1, 5));
        this.analysisModListContainer.setPreferredSize(this.containerSize);
        this.analysisModLabel = new BigLabel("Analysis");
        list.setSelectionMode(1);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        list.addListSelectionListener(e -> {
            String selected = (String)list.getSelectedValue();
            if (selected == null) {
                this.selectedScript = "";
            } else {
                if (list2.getSelectedValue() != null) {
                    list2.clearSelection();
                }
                this.selectedScript = selected;
            }
            this.updateButtons();
        });
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(this.scrollerSize);
        this.analysisModListContainer.add(this.analysisModLabel);
        this.analysisModListContainer.add(listScroller);
        this.postAnalysisModListContainer = new Panel();
        this.postAnalysisModListContainer.setLayout(new FlowLayout(1, 1, 5));
        this.postAnalysisModListContainer.setPreferredSize(this.containerSize);
        this.postAnalysisModLabel = new BigLabel("Post Analysis");
        list2.setSelectionMode(1);
        list2.setLayoutOrientation(0);
        list2.setVisibleRowCount(-1);
        list2.addListSelectionListener(e -> {
            String selected = (String)list2.getSelectedValue();
            if (selected == null) {
                this.selectedScript = "";
            } else {
                if (list.getSelectedValue() != null) {
                    list.clearSelection();
                }
                this.selectedScript = selected;
            }
            this.updateButtons();
        });
        JScrollPane listScroller2 = new JScrollPane(list2);
        listScroller2.setPreferredSize(this.scrollerSize);
        this.postAnalysisModListContainer.add(this.postAnalysisModLabel);
        this.postAnalysisModListContainer.add(listScroller2);
        this.modulesContainer.add(this.analysisModListContainer);
        this.modulesContainer.add(this.postAnalysisModListContainer);
    }

    private void makeButtonsContainer() {
        this.buttonsContainer = new Panel();
        this.buttonsContainer.setLayout(new FlowLayout(2, 0, this.hGap));
        this.buttonsContainer.setPreferredSize(this.containerSize);
        this.addButton = this.getButton("Create Module", this.buttonSize, true, Resources.getImageIcon(this.getClass(), "add-green-button-icon-24.png"));
        this.addButton.addActionListener(evt -> this.addScript());
        this.importButton = this.getButton("Import", this.buttonSize, true, Resources.getImageIcon(this.getClass(), "import-icon-24.png"));
        this.importButton.addActionListener(evt -> {
            boolean success = this.importScript();
            if (success) {
                MainGUI.showRestartPeridotDialog();
                this.closeThisAndMainGUI();
            }
        });
        this.exportButton = this.getButton("Export", this.buttonSize, false, Resources.getImageIcon(this.getClass(), "export-icon-24.png"));
        this.exportButton.addActionListener(evt -> this.exportScript(this.selectedScript));
        this.editButton = this.getButton("Edit", this.buttonSize, false, Resources.getImageIcon(this.getClass(), "write-icon-24.png"));
        this.editButton.addActionListener(evt -> this.editScript(this.selectedScript));
        this.detailsButton = this.getButton("Details", this.buttonSize, false, Resources.getImageIcon(this.getClass(), "Document-icon-24.png"));
        this.detailsButton.addActionListener(evt -> this.scriptDetails(this.selectedScript));
        this.deleteButton = this.getButton("Delete", this.buttonSize, false, Resources.getImageIcon(this.getClass(), "Delete-icon-24.png"));
        this.deleteButton.addActionListener(evt -> this.deleteScript(this.selectedScript));
        this.buttonsContainer.add(this.addButton);
        this.buttonsContainer.add(this.importButton);
        this.buttonsContainer.add(this.exportButton);
        this.buttonsContainer.add(this.editButton);
        this.buttonsContainer.add(this.detailsButton);
        this.buttonsContainer.add(this.deleteButton);
    }

    private BigButton getButton(String text, Dimension size, boolean enabled, ImageIcon icon) {
        BigButton button = new BigButton();
        button.setText(text);
        button.setIcon(icon);
        button.setSize(size);
        button.setMinimumSize(size);
        button.setPreferredSize(size);
        button.setEnabled(enabled);
        button.setHorizontalTextPosition(2);
        button.setHorizontalAlignment(4);
        return button;
    }

    private void updateButtons() {
        if (RModule.availableModules.keySet().contains(this.selectedScript)) {
            this.deleteButton.setEnabled(true);
            this.detailsButton.setEnabled(true);
            this.exportButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            Log.logger.info(this.selectedScript + " not available");
            this.deleteButton.setEnabled(false);
            this.detailsButton.setEnabled(false);
            this.exportButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    private void exportScript(String scriptName) {
        File folder;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(this.publicParent);
        if (result == 0 && (folder = fileChooser.getSelectedFile()).exists()) {
            Operations.exportModule(scriptName, folder.getAbsolutePath());
        }
    }

    private boolean importScript() {
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.isFile() || !f.getName().contains(".PeridotModule")) {
                    return;
                }
                super.approveSelection();
            }
        };
        if (fileChooser.showDialog(null, "Select a .PeridotModule file:") == 0) {
            File binFile = fileChooser.getSelectedFile();
            Object bin = Persistence.loadObjectFromBin(binFile.getAbsolutePath());
            if (bin == null) {
                Log.logger.log(Level.SEVERE, "Could not load RModule binary.");
                JOptionPane.showMessageDialog(this.publicParent, "Error loading module. Maybe you don't have permission to read this file.", "Cannot import " + binFile.getName(), 0);
                return false;
            }
            if (bin instanceof AnalysisModule || bin instanceof PostAnalysisModule) {
                RModule script = null;
                Object type = null;
                script = bin instanceof AnalysisModule ? (AnalysisModule)bin : (PostAnalysisModule)bin;
                script.createEnvironment(null);
                RModule.availableModules.put(script.name, script);
                return true;
            }
            Log.logger.log(Level.SEVERE, "Could not load RModule binary. Unknown class.");
            JOptionPane.showMessageDialog(this.publicParent, "Error loading moduleThe file is in an unknown format.", "Cannot import " + binFile.getName(), 0);
        }
        return false;
    }

    private void editScript(String scriptName) {
        RModule script = RModule.availableModules.get(scriptName);
        NewModuleDialog dialog = new NewModuleDialog(this.publicParent, true, script.getClass(), script);
        dialog.setVisible(true);
        if (dialog.script != null && dialog.editedScript) {
            MainGUI.showRestartPeridotDialog();
            this.closeThisAndMainGUI();
        }
    }

    private void addScript() {
        Class scriptType = this.askUserForType();
        if (scriptType == null) {
            return;
        }
        NewModuleDialog dialog = new NewModuleDialog(this.publicParent, true, scriptType, null);
        dialog.setVisible(true);
        if (dialog.script != null) {
            MainGUI.showRestartPeridotDialog();
            this.closeThisAndMainGUI();
        }
    }

    private Class askUserForType() {
        AskModuleType dialog = new AskModuleType(this.publicParent);
        dialog.setVisible(true);
        return dialog.type;
    }

    private void scriptDetails(String script) {
        new ModuleDetailsDialog(script, this.publicParent, true).setVisible(true);
    }

    private void deleteScript(String script) {
        boolean deleted = RModule.deleteScript(script);
        if (deleted) {
            MainGUI.showRestartPeridotDialog();
            this.closeThisAndMainGUI();
        } else {
            this.showCannotCompleteOperationError("delete(" + script + ")");
        }
    }

    private void showCannotCompleteOperationError(String operation) {
        JOptionPane.showConfirmDialog(this.publicParent, "Cannot complete operation " + operation, "Error: " + operation, 0);
    }

    private void closeThisAndMainGUI() {
        SwingUtilities.invokeLater(() -> {
            this.setVisible(false);
            MainGUI.close();
        });
    }
}

