/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.io.FileUtils;
import peridot.GUI.GUIUtils;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.Button;
import peridot.GUI.component.CheckBox;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.modulesManager.GetFileFromTreeDialog;
import peridot.GUI.dialog.modulesManager.GetNewResultDialog;
import peridot.GUI.dialog.modulesManager.NewPackageDialog;
import peridot.GUI.dialog.modulesManager.NewParamDialog;
import peridot.Global;
import peridot.Log;
import peridot.script.AnalysisModule;
import peridot.script.DiffExpressionModule;
import peridot.script.PostAnalysisModule;
import peridot.script.RModule;
import peridot.script.r.Package;

public class NewModuleDialog
extends Dialog {
    RModule script = null;
    String info;
    File scriptFile;
    File scriptInTemp;
    String name;
    boolean max2Conditions;
    boolean needsReplicates;
    Map<String, Class> requiredParameters;
    Set<String> requiredExternalFiles;
    Set<Package> requiredPackages;
    Set<String> results;
    Set<String> mandatory;
    Set<String> requiredScripts;
    boolean canHandleFloatValues;
    Class scriptType;
    String originalScript;
    boolean editing;
    boolean changedScript;
    boolean editedScript;
    Panel scriptNamePanel;
    Panel fileNamePanel;
    Panel generalInfoPanel;
    Panel resultsPanel;
    Panel inputsPanel;
    Panel buttonsPanel;
    Panel paramsPanel;
    JScrollPane resultsScroller;
    JScrollPane infoScroller;
    JScrollPane inputsScroller;
    JScrollPane paramsScroller;
    Label scriptNameLabel;
    Label fileNameLabel;
    Label resultsLabel;
    Label paramsLabel;
    Label inputsLabel;
    JTextField scriptNameField;
    JTextField fileNameField;
    JTextField newResultField;
    JTextArea infoArea;
    CheckBox max2CondOption;
    CheckBox needsReplicatesOption;
    DefaultListModel<String> resultsListModel;
    DefaultListModel<String> inputsListModel;
    DefaultListModel<String> paramsListModel;
    JList resultsList;
    JList inputsList;
    JList paramsList;
    JButton selectScriptFileButton;
    JButton addNewResultButton;
    JButton eraseResultButton;
    JButton eraseInputButton;
    JButton addNewInputButton;
    JButton eraseParamButton;
    JButton addNewParamButton;
    JButton createButton;
    JButton cancelButton;
    Dimension dialogSize;
    Dimension availableSize;
    Dimension componentPanelSize;
    Dimension scrollerSize;
    int componentPanelHeight;
    int componentPanelWidth;
    int buttonPanelHeight;
    Panel packagesPanel;
    Label packagesLabel;
    JScrollPane packagesScroller;
    JList packagesList;
    DefaultListModel<String> packagesListModel;
    JButton addPackageButton;
    JButton rmPackageButton;

    public NewModuleDialog(Frame parent, boolean modal, Class type, RModule baseScript) {
        super(parent, modal);
        assert (type != null) : "No Script Type specified for the creation";
        this.scriptType = type;
        this.script = baseScript;
        boolean bl = this.editing = baseScript != null;
        if (this.editing) {
            Log.logger.info("Editing " + baseScript.name);
        } else {
            Log.logger.info("Creating " + type.getSimpleName());
        }
        this.initComponents();
        if (baseScript != null) {
            File temp = new File(System.getProperty("java.io.tmpdir"));
            File scriptInTemp = new File(temp.getAbsolutePath() + "/" + this.script.getScriptFile().getName());
            this.originalScript = this.script.getScriptFile().getAbsolutePath();
            if (scriptInTemp.exists()) {
                scriptInTemp.delete();
            }
            try {
                FileUtils.copyFile(this.script.getScriptFile(), scriptInTemp);
                this.scriptInTemp = scriptInTemp;
            }
            catch (IOException ex) {
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            this.originalScript = "";
        }
        this.changedScript = false;
        this.editedScript = false;
    }

    private void listModelFromResults(Set<String> res, Set<String> mandatory) {
        Iterator<String> iterator = res.iterator();
        while (iterator.hasNext()) {
            String s;
            String text = s = iterator.next();
            if (mandatory.contains(s)) {
                text = text + " (mandatory)";
            }
            this.resultsListModel.addElement(text);
        }
    }

    private void resultsFromListModel() {
        this.results = new HashSet<String>();
        this.mandatory = new HashSet<String>();
        for (int i = 0; i < this.resultsListModel.size(); ++i) {
            String text = this.resultsListModel.get(i);
            if (text.contains(" (mandatory)")) {
                text = text.replace(" (mandatory)", "");
                this.mandatory.add(text);
            }
            this.results.add(text);
        }
    }

    private void inputsListModelFromInputList(Set<String> inputs) {
        for (String file : inputs) {
            String toAdd = null;
            String analysisClassName = "." + AnalysisModule.class.getSimpleName();
            String postAnalysisClassName = "." + PostAnalysisModule.class.getSimpleName();
            if (file.contains(analysisClassName) || file.contains(postAnalysisClassName)) {
                String[] splitted = null;
                if (file.contains(File.separator)) {
                    splitted = file.split(Pattern.quote(File.separator));
                } else if (file.contains("/")) {
                    splitted = file.split("/");
                }
                String scriptFolder = splitted[0];
                String scriptName = "";
                scriptName = file.contains(analysisClassName) ? scriptFolder.replace(analysisClassName, "") : scriptFolder.replace(postAnalysisClassName, "");
                String finalInput = scriptName + ": " + splitted[1];
                for (int i = 2; i < splitted.length; ++i) {
                    finalInput = finalInput + File.separator + splitted[i];
                }
                toAdd = finalInput;
            } else {
                toAdd = file;
            }
            this.inputsListModel.addElement(toAdd);
        }
    }

    private void requiredFilesAndScriptsFromListModel() {
        this.requiredExternalFiles = new HashSet<String>();
        this.requiredScripts = new HashSet<String>();
        for (int i = 0; i < this.inputsListModel.size(); ++i) {
            String inputRaw = this.inputsListModel.get(i);
            if (inputRaw.contains(": ")) {
                String[] splited = inputRaw.split(": ");
                String first = splited[0];
                RModule scr = RModule.availableModules.get(first);
                String x = scr.name + ".";
                if (scr instanceof AnalysisModule) {
                    x = x + AnalysisModule.class.getSimpleName();
                } else if (scr instanceof PostAnalysisModule) {
                    x = x + PostAnalysisModule.class.getSimpleName();
                }
                x = x + File.separator;
                x = x + splited[1];
                this.requiredScripts.add(scr.name);
                this.requiredExternalFiles.add(x);
                continue;
            }
            this.requiredExternalFiles.add(inputRaw);
        }
    }

    private void listModelFromRequiredParameters(Map<String, Class> params) {
        for (String key : params.keySet()) {
            String className = params.get(key).getSimpleName();
            this.paramsListModel.addElement(className + "::" + key);
        }
    }

    private void requiredParametersFromListModel() {
        this.requiredParameters = new HashMap<String, Class>();
        for (int i = 0; i < this.paramsListModel.size(); ++i) {
            String rawParam = this.paramsListModel.get(i);
            String[] typeAndName = rawParam.split("::");
            if (typeAndName.length != 2) continue;
            String param = typeAndName[1];
            Class type = RModule.availableParamTypes.get(typeAndName[0]);
            this.requiredParameters.put(param, type);
        }
    }

    private void listModelFromRequiredPackages(Set<Package> packages) {
        this.packagesListModel.removeAllElements();
        for (Package pack : this.script.requiredPackages) {
            this.packagesListModel.addElement(pack.name + " " + pack.version.toString());
        }
    }

    private void requiredPackagesFromListModel() {
        HashSet<Package> packages = new HashSet<Package>();
        for (int i = 0; i < this.packagesListModel.size(); ++i) {
            String rawPack = this.packagesListModel.get(i);
            String[] nameAndVersion = rawPack.split(" ");
            if (nameAndVersion.length != 2) continue;
            Package pack = new Package(nameAndVersion[0], nameAndVersion[1]);
            packages.add(pack);
        }
        this.requiredPackages = packages;
    }

    private void basicInfoFromUI() {
        this.name = this.scriptNameField.getText();
        this.max2Conditions = this.max2CondOption.isSelected();
        this.needsReplicates = this.needsReplicatesOption.isSelected();
    }

    private void scriptToBasicInfo() {
        this.scriptNameField.setText(this.script.name);
        if (this.script.max2Conditions) {
            this.max2CondOption.doClick();
        }
        if (this.script.needsReplicates) {
            this.needsReplicatesOption.doClick();
        }
        this.scriptFile = this.script.getScriptFile();
        this.fileNameLabel.setText("Script file: " + this.scriptFile.getName());
    }

    private void infoAreaFromString(String s) {
        this.infoArea.setText(s);
    }

    private void infoFromTextArea() {
        String multiLineInfo;
        String lineBreaker = null;
        if (this.infoArea.getText().contains("\r\n")) {
            lineBreaker = "\r\n";
        } else if (this.infoArea.getText().contains("\n")) {
            lineBreaker = "\n";
        }
        if (this.infoArea.getText().contains("\r")) {
            lineBreaker = "\r";
        }
        this.info = lineBreaker == null ? this.infoArea.getText() : (multiLineInfo = this.infoArea.getText());
    }

    private void gatherInfoFromUI() {
        this.basicInfoFromUI();
        this.resultsFromListModel();
        this.requiredFilesAndScriptsFromListModel();
        this.requiredParametersFromListModel();
        this.requiredPackagesFromListModel();
        this.infoFromTextArea();
    }

    private boolean validateFields() {
        if (this.scriptNameField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.rootPane, "Please, write a name for the script", "INPUT ERROR", 0);
            return false;
        }
        if (!Global.stringIsLettersAndDigits(this.scriptNameField.getText())) {
            JOptionPane.showMessageDialog(this.rootPane, "Use only letters and digits on the script name", "INPUT ERROR", 0);
            return false;
        }
        if (this.scriptFile == null) {
            JOptionPane.showMessageDialog(this.rootPane, "You must choose a script file", "INPUT ERROR", 0);
            return false;
        }
        if (!this.scriptFile.exists()) {
            JOptionPane.showMessageDialog(this.rootPane, "The script file does not exist", "INPUT ERROR", 0);
            return false;
        }
        if (this.resultsListModel.size() == 0) {
            JOptionPane.showMessageDialog(this.rootPane, "The new script must have at least one result", "INPUT ERROR", 0);
            return false;
        }
        return true;
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void create() {
        if (this.validateFields()) {
            this.gatherInfoFromUI();
            this.script = this.scriptType == AnalysisModule.class ? new AnalysisModule(this.name, this.scriptFile.getName(), this.requiredParameters, this.requiredExternalFiles, this.results) : new PostAnalysisModule(this.name, this.scriptFile.getName(), this.requiredParameters, this.requiredExternalFiles, this.results, this.requiredScripts);
            this.script.requiredPackages = this.requiredPackages;
            this.script.max2Conditions = this.max2Conditions;
            this.script.needsReplicates = this.needsReplicates;
            this.script.info = this.info;
            for (String res : this.results) {
                if (!this.mandatory.contains(res)) continue;
                this.script.setResultAsMandatory(res);
            }
            if (this.script.workingDirectory.exists()) {
                boolean answer = MainGUI.showYesNoDialog("Do you wish to overwrite the " + this.script.name + " module?");
                if (answer) {
                    RModule.deleteScript(this.script.name);
                } else {
                    this.script = null;
                    return;
                }
            }
            if (this.editing && !this.changedScript && this.scriptInTemp != null) {
                this.script.createEnvironment(this.scriptInTemp.getAbsolutePath());
            } else {
                this.script.createEnvironment(this.scriptFile.getAbsolutePath());
            }
            this.editedScript = true;
            this.setVisible(false);
        }
    }

    private void populateFieldsWithValuesFromScript() {
        assert (this.script != null);
        this.scriptToBasicInfo();
        this.listModelFromResults(this.script.results, this.script.mandatoryResults);
        this.inputsListModelFromInputList(this.script.requiredExternalFiles);
        this.listModelFromRequiredParameters(this.script.requiredParameters);
        this.listModelFromRequiredPackages(this.script.requiredPackages);
        this.infoAreaFromString(this.script.info);
    }

    private void populateFieldWithAnalysisModuleDefaults() {
        this.listModelFromRequiredParameters(DiffExpressionModule.getDefaultParameters());
        this.inputsListModelFromInputList(DiffExpressionModule.getDefaultRequiredFiles());
        this.listModelFromResults(DiffExpressionModule.getDefaultResults(), DiffExpressionModule.getMandatoryResults());
    }

    private void initComponents() {
        this.setTitle("New " + this.scriptType.getSimpleName() + " Module");
        this.dialogSize = new Dimension(560, 685);
        int wGap = 5;
        int hGap = 5;
        int rows = 3;
        int cols = 2;
        this.buttonPanelHeight = 32;
        this.availableSize = new Dimension(this.dialogSize.width - 20, this.dialogSize.height - 40);
        this.componentPanelHeight = (this.availableSize.height - hGap * rows - this.buttonPanelHeight) / rows;
        this.componentPanelWidth = (this.availableSize.width - wGap * (cols - 1)) / cols;
        this.componentPanelSize = new Dimension(this.componentPanelWidth, this.componentPanelHeight);
        this.scrollerSize = new Dimension(this.componentPanelWidth, this.componentPanelHeight - 70);
        this.setMinimumSize(this.dialogSize);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new FlowLayout(1, wGap, hGap));
        this.setResizable(false);
        this.initGeneralInfo();
        this.initResults();
        this.initInputs();
        this.initInfoArea();
        this.initParams();
        this.initPackages();
        this.initButtons();
        this.add(this.generalInfoPanel);
        this.add(this.resultsPanel);
        this.add(this.inputsPanel);
        this.add(this.paramsPanel);
        this.add(this.packagesPanel);
        this.add(this.infoScroller);
        this.add(this.buttonsPanel);
        if (this.script != null) {
            this.populateFieldsWithValuesFromScript();
        } else if (this.scriptType == AnalysisModule.class) {
            this.populateFieldWithAnalysisModuleDefaults();
        }
        Dimension loc = GUIUtils.getCenterLocation(this.dialogSize.width, this.dialogSize.height);
        this.setLocation(loc.width, loc.height);
    }

    private void initGeneralInfo() {
        this.generalInfoPanel = new Panel();
        this.generalInfoPanel.setLayout(new BoxLayout(this.generalInfoPanel, 3));
        this.generalInfoPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.generalInfoPanel.setAlignmentX(0.5f);
        this.scriptNamePanel = new Panel();
        this.scriptNamePanel.setLayout(new FlowLayout(1, 3, 6));
        this.scriptNameLabel = new Label("Name: ");
        this.scriptNameField = new JTextField();
        this.scriptNameField.setPreferredSize(new Dimension(120, 25));
        this.scriptNamePanel.add(this.scriptNameLabel);
        this.scriptNamePanel.add(this.scriptNameField);
        this.scriptNamePanel.setAlignmentX(0.5f);
        this.fileNamePanel = new Panel();
        this.fileNamePanel.setLayout(new FlowLayout(1, 3, 6));
        this.fileNameLabel = this.script == null ? new Label("Script file:     [No Script]    ") : new Label("Filename: " + this.script.getScriptFile().getName());
        this.selectScriptFileButton = new Button();
        this.selectScriptFileButton.addActionListener(evt -> this.selectScriptFile());
        this.selectScriptFileButton.setIcon(Resources.getImageIcon(this.getClass(), "open-icon-24.png"));
        this.fileNamePanel.add(this.fileNameLabel);
        this.fileNamePanel.add(this.selectScriptFileButton);
        this.fileNamePanel.setAlignmentX(0.5f);
        this.max2CondOption = new CheckBox();
        this.max2CondOption.setText("Maximum of 2 conditions");
        this.max2CondOption.setAlignmentX(0.5f);
        this.needsReplicatesOption = new CheckBox();
        this.needsReplicatesOption.setText("Needs replicates in samples");
        this.needsReplicatesOption.setAlignmentX(0.5f);
        this.generalInfoPanel.add(Box.createVerticalGlue());
        this.generalInfoPanel.add(this.scriptNamePanel);
        this.generalInfoPanel.add(this.fileNamePanel);
        this.generalInfoPanel.add(this.max2CondOption);
        this.generalInfoPanel.add(this.needsReplicatesOption);
        this.generalInfoPanel.add(Box.createVerticalGlue());
    }

    private void initResults() {
        this.resultsPanel = new Panel();
        this.resultsPanel.setLayout(new FlowLayout(1, 1, 5));
        this.resultsPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.resultsLabel = new BigLabel("Results: ");
        this.resultsListModel = new DefaultListModel();
        this.resultsList = new JList<String>(this.resultsListModel);
        this.resultsList.setSelectionMode(0);
        this.resultsList.setLayoutOrientation(0);
        this.resultsList.setVisibleRowCount(-1);
        this.resultsList.addListSelectionListener(e -> {
            String selected = (String)this.resultsList.getSelectedValue();
            if (selected == null) {
                this.eraseResultButton.setEnabled(false);
            } else {
                this.eraseResultButton.setEnabled(true);
            }
        });
        this.resultsScroller = new JScrollPane(this.resultsList);
        this.resultsScroller.setPreferredSize(new Dimension(this.scrollerSize.width, this.scrollerSize.height));
        this.addNewResultButton = new Button();
        this.addNewResultButton.setIcon(Resources.getImageIcon(this.getClass(), "add-icon-24.png"));
        this.addNewResultButton.addActionListener(evt -> this.addNewResult());
        this.eraseResultButton = new Button();
        this.eraseResultButton.setIcon(Resources.getImageIcon(this.getClass(), "Delete-icon-24.png"));
        this.eraseResultButton.setEnabled(false);
        this.eraseResultButton.addActionListener(evt -> this.eraseResult());
        this.resultsPanel.add(this.resultsLabel);
        this.resultsPanel.add(this.resultsScroller);
        this.resultsPanel.add(this.addNewResultButton);
        this.resultsPanel.add(this.eraseResultButton);
    }

    private void initInputs() {
        this.inputsPanel = new Panel();
        this.inputsPanel.setLayout(new FlowLayout(1, 1, 5));
        this.inputsPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.inputsLabel = new BigLabel("Input Files: ");
        this.inputsListModel = new DefaultListModel();
        this.inputsList = new JList<String>(this.inputsListModel);
        this.inputsList.setSelectionMode(0);
        this.inputsList.setLayoutOrientation(0);
        this.inputsList.setVisibleRowCount(-1);
        this.inputsList.addListSelectionListener(e -> {
            String selected = (String)this.inputsList.getSelectedValue();
            if (selected == null) {
                this.eraseInputButton.setEnabled(false);
            } else {
                this.eraseInputButton.setEnabled(true);
            }
        });
        this.inputsScroller = new JScrollPane(this.inputsList);
        this.inputsScroller.setPreferredSize(new Dimension(this.scrollerSize.width, this.scrollerSize.height));
        this.addNewInputButton = new Button();
        this.addNewInputButton.setIcon(Resources.getImageIcon(this.getClass(), "add-icon-24.png"));
        this.addNewInputButton.addActionListener(evt -> this.addNewInput());
        this.addNewInputButton.setEnabled(this.scriptType != AnalysisModule.class);
        this.eraseInputButton = new Button();
        this.eraseInputButton.setIcon(Resources.getImageIcon(this.getClass(), "Delete-icon-24.png"));
        this.eraseInputButton.setEnabled(false);
        this.eraseInputButton.addActionListener(evt -> this.eraseInput());
        this.inputsPanel.add(this.inputsLabel);
        this.inputsPanel.add(this.inputsScroller);
        this.inputsPanel.add(this.addNewInputButton);
        this.inputsPanel.add(this.eraseInputButton);
    }

    private void initParams() {
        this.paramsPanel = new Panel();
        this.paramsPanel.setLayout(new FlowLayout(1, 1, 5));
        this.paramsPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.paramsLabel = new BigLabel("Input Parameters: ");
        this.paramsListModel = new DefaultListModel();
        this.paramsList = new JList<String>(this.paramsListModel);
        this.paramsList.setSelectionMode(0);
        this.paramsList.setLayoutOrientation(0);
        this.paramsList.setVisibleRowCount(-1);
        this.paramsList.addListSelectionListener(e -> {
            String selected = (String)this.paramsList.getSelectedValue();
            if (selected == null) {
                this.eraseParamButton.setEnabled(false);
            } else {
                this.eraseParamButton.setEnabled(true);
            }
        });
        this.paramsScroller = new JScrollPane(this.paramsList);
        this.paramsScroller.setPreferredSize(new Dimension(this.scrollerSize.width, this.scrollerSize.height));
        this.addNewParamButton = new Button();
        this.addNewParamButton.setIcon(Resources.getImageIcon(this.getClass(), "add-icon-24.png"));
        this.addNewParamButton.addActionListener(evt -> this.addNewParam());
        this.eraseParamButton = new Button();
        this.eraseParamButton.setIcon(Resources.getImageIcon(this.getClass(), "Delete-icon-24.png"));
        this.eraseParamButton.setEnabled(false);
        this.eraseParamButton.addActionListener(evt -> this.eraseParam());
        this.paramsPanel.add(this.paramsLabel);
        this.paramsPanel.add(this.paramsScroller);
        this.paramsPanel.add(this.addNewParamButton);
        this.paramsPanel.add(this.eraseParamButton);
    }

    private void initPackages() {
        this.packagesPanel = new Panel();
        this.packagesPanel.setLayout(new FlowLayout(1, 1, 5));
        this.packagesPanel.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight));
        this.packagesLabel = new BigLabel("Required Packages: ");
        this.packagesListModel = new DefaultListModel();
        this.packagesList = new JList<String>(this.packagesListModel);
        this.packagesList.setSelectionMode(0);
        this.packagesList.setLayoutOrientation(0);
        this.packagesList.setVisibleRowCount(-1);
        this.packagesList.addListSelectionListener(e -> {
            String selected = (String)this.packagesList.getSelectedValue();
            if (selected == null) {
                this.rmPackageButton.setEnabled(false);
            } else {
                this.rmPackageButton.setEnabled(true);
            }
        });
        this.packagesScroller = new JScrollPane(this.packagesList);
        this.packagesScroller.setPreferredSize(new Dimension(this.scrollerSize.width, this.scrollerSize.height));
        this.addPackageButton = new Button();
        this.addPackageButton.setIcon(Resources.getImageIcon(this.getClass(), "add-icon-24.png"));
        this.addPackageButton.addActionListener(evt -> this.addNewPackage());
        this.rmPackageButton = new Button();
        this.rmPackageButton.setIcon(Resources.getImageIcon(this.getClass(), "Delete-icon-24.png"));
        this.rmPackageButton.setEnabled(false);
        this.rmPackageButton.addActionListener(evt -> this.rmPackage());
        this.packagesPanel.add(this.packagesLabel);
        this.packagesPanel.add(this.packagesScroller);
        this.packagesPanel.add(this.addPackageButton);
        this.packagesPanel.add(this.rmPackageButton);
    }

    private void addNewPackage() {
        NewPackageDialog dialog = new NewPackageDialog(this.publicParent);
        dialog.setVisible(true);
        if (dialog.isSuccessful()) {
            this.packagesListModel.addElement(dialog.name + " " + dialog.version);
        }
    }

    private void rmPackage() {
        int index = this.packagesList.getSelectedIndex();
        try {
            this.packagesListModel.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Log.logger.severe("Cannot remove package " + index + " because it is out of bounds (max " + (this.packagesListModel.getSize() - 1) + ").");
        }
    }

    private void initInfoArea() {
        this.infoArea = new JTextArea();
        this.infoArea.setText(this.info);
        this.infoArea.setEditable(true);
        this.infoArea.setFont(new Font("Ubuntu", 0, 14));
        this.infoArea.setLineWrap(true);
        this.infoArea.setWrapStyleWord(true);
        this.infoScroller = new JScrollPane(this.infoArea);
        this.infoScroller.setPreferredSize(new Dimension(this.componentPanelWidth, this.componentPanelHeight - 10));
        this.infoArea.setText("[describe the module here]");
    }

    private void initButtons() {
        this.buttonsPanel = new Panel();
        this.buttonsPanel.setPreferredSize(new Dimension(this.availableSize.width, this.buttonPanelHeight));
        this.buttonsPanel.setLayout(new FlowLayout(1, 10, 0));
        Dimension buttonSize = new Dimension((this.availableSize.width - 20) / 2, this.buttonPanelHeight);
        this.createButton = new BigButton();
        if (this.editing) {
            this.createButton.setText("Save");
        } else {
            this.createButton.setText("Create");
        }
        this.createButton.setIcon(Resources.getImageIcon(this.getClass(), "check-icon-32.png"));
        this.createButton.setPreferredSize(buttonSize);
        this.createButton.addActionListener(evt -> this.create());
        this.cancelButton = new BigButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setIcon(Resources.getImageIcon(this.getClass(), "cancel-icon-32.png"));
        this.cancelButton.setPreferredSize(buttonSize);
        this.cancelButton.addActionListener(evt -> this.cancel());
        this.buttonsPanel.add(this.createButton);
        this.buttonsPanel.add(this.cancelButton);
    }

    private void selectScriptFile() {
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.isFile() || !f.getName().contains(".R")) {
                    return;
                }
                super.approveSelection();
            }
        };
        if (fileChooser.showDialog(null, "Select Script File") == 0) {
            this.scriptFile = fileChooser.getSelectedFile();
            this.fileNameLabel.setText("Script file: " + this.scriptFile.getName());
            this.changedScript = !this.scriptFile.getAbsolutePath().equals(this.originalScript);
        }
    }

    private void eraseResult() {
        int index = this.resultsList.getSelectedIndex();
        if (index >= 0 && index < this.resultsListModel.getSize()) {
            this.resultsListModel.remove(index);
        }
    }

    private void eraseInput() {
        int index = this.inputsList.getSelectedIndex();
        if (index >= 0 && index < this.inputsListModel.getSize()) {
            this.inputsListModel.remove(index);
        }
    }

    private void eraseParam() {
        int index = this.paramsList.getSelectedIndex();
        if (index >= 0 && index < this.paramsListModel.getSize()) {
            this.paramsListModel.remove(index);
        }
    }

    private void addNewResult() {
        GetNewResultDialog dialog = new GetNewResultDialog(this.publicParent, true);
        dialog.setVisible(true);
        if (dialog.validInfo()) {
            String toAdd = dialog.name;
            if (dialog.mandatory) {
                toAdd = toAdd + " (mandatory)";
            }
            this.resultsListModel.addElement(toAdd);
        }
    }

    private void addNewInput() {
        if (this.scriptType == AnalysisModule.class) {
            return;
        }
        String result = GetFileFromTreeDialog.getAResult(this.publicParent, true);
        if (result != null) {
            this.inputsListModel.addElement(result);
        }
    }

    private void addNewParam() {
        NewParamDialog dialog = new NewParamDialog(this.publicParent);
        dialog.setVisible(true);
        if (dialog.isSuccessful()) {
            String newParam = dialog.getParamType() + "::" + dialog.getParamName();
            this.paramsListModel.addElement(newParam);
        }
    }
}

