/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import peridot.GUI.GUIUtils;
import peridot.GUI.WrapLayout;
import peridot.GUI.component.Button;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.script.r.Package;

public class NewPackageDialog
extends Dialog {
    public String name = null;
    public String version = null;
    private boolean successful;
    private Package newPackage;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel instructionsLabel;
    private JLabel versionInstructionsLabel;
    private JTextField nameTextField;
    private JTextField versionTextField;

    public NewPackageDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.successful = false;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getPackName() {
        return this.name;
    }

    public String getPackVersion() {
        return this.version;
    }

    private boolean nameIsValid() {
        boolean validName = this.name.length() >= 2;
        char lastChar = this.name.charAt(this.name.length() - 1);
        validName = validName && lastChar != '.';
        for (int i = 0; i < this.name.length(); ++i) {
            if (Character.isLetterOrDigit(this.name.charAt(i)) || this.name.charAt(i) == '.') continue;
            validName = false;
            break;
        }
        return validName;
    }

    private boolean versionIsValid() {
        for (int i = 0; i < this.version.length(); ++i) {
            if (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.') continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("New Required Package");
        this.getContentPane().setLayout(new WrapLayout(1, 5, 8));
        Dimension dialogSize = new Dimension(380, 145);
        this.setPreferredSize(dialogSize);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        Panel namePanel = new Panel();
        this.nameTextField = new JTextField();
        this.nameTextField.setText("name");
        this.nameTextField.setMinimumSize(new Dimension(100, 10));
        this.nameTextField.setName("");
        this.nameTextField.setPreferredSize(new Dimension(100, 25));
        this.instructionsLabel = new Label();
        this.instructionsLabel.setHorizontalAlignment(0);
        this.instructionsLabel.setText("Name: letters, numbers and dot.");
        this.instructionsLabel.setPreferredSize(new Dimension(210, 15));
        namePanel.add(this.instructionsLabel);
        namePanel.add(this.nameTextField);
        this.getContentPane().add(namePanel);
        Panel versionPanel = new Panel();
        this.versionTextField = new JTextField();
        this.versionTextField.setText("1.0.0");
        this.versionTextField.setMinimumSize(new Dimension(100, 10));
        this.versionTextField.setName("");
        this.versionTextField.setPreferredSize(new Dimension(100, 25));
        this.versionInstructionsLabel = new Label();
        this.versionInstructionsLabel.setHorizontalAlignment(0);
        this.versionInstructionsLabel.setText("Version: numbers and dot.");
        this.versionInstructionsLabel.setPreferredSize(new Dimension(180, 15));
        versionPanel.add(this.versionInstructionsLabel);
        versionPanel.add(this.versionTextField);
        this.getContentPane().add(versionPanel);
        this.okButton = new Button();
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(70, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewPackageDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton = new Button();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(70, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewPackageDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        Panel buttonsPanel = new Panel();
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getContentPane().add(buttonsPanel);
        Dimension loc = GUIUtils.getCenterLocation(dialogSize.width, dialogSize.height);
        this.setLocation(loc.width, loc.height);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.name = this.nameTextField.getText();
        this.version = this.versionTextField.getText();
        if (!this.nameIsValid()) {
            JOptionPane.showMessageDialog(this.rootPane, "Only letters, numbers and dot are allowed!", "Invalid name!", 0);
            return;
        }
        if (!this.versionIsValid()) {
            JOptionPane.showMessageDialog(this.rootPane, "Only numbers and dot are allowed!", "Invalid version!", 0);
            return;
        }
        this.successful = true;
        this.newPackage = new Package(this.name, this.version);
        this.setVisible(false);
    }
}

