/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dialog.modulesManager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import peridot.GUI.component.Button;
import peridot.GUI.component.Dialog;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.component.RadioButton;
import peridot.Global;
import peridot.script.RModule;

public class NewParamDialog
extends Dialog {
    private String name = null;
    private String type = null;
    private boolean successful;
    private RadioButton[] paramOptions;
    private ButtonGroup optionsGroup;
    private Panel optionsPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel instructionsLabel;
    private JTextField nameTextField;

    public NewParamDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.nameTextField.setText("[Parameter Name]");
        this.successful = false;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getParamName() {
        return this.name;
    }

    public String getParamType() {
        return this.type;
    }

    private boolean textIsValid() {
        return Global.stringIsLettersAndDigits(this.nameTextField.getText());
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("New Parametter");
        this.getContentPane().setLayout(new FlowLayout());
        this.setPreferredSize(new Dimension(400, 155));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        Panel namePanel = new Panel();
        this.nameTextField = new JTextField();
        this.nameTextField.setText("[Parameter Name]");
        this.nameTextField.setMinimumSize(new Dimension(100, 10));
        this.nameTextField.setName("");
        this.nameTextField.setPreferredSize(new Dimension(200, 25));
        namePanel.add(this.nameTextField);
        this.instructionsLabel = new Label();
        this.instructionsLabel.setHorizontalAlignment(0);
        this.instructionsLabel.setText("Use only: a-z, A-Z and 1-9");
        this.instructionsLabel.setPreferredSize(new Dimension(180, 15));
        namePanel.add(this.instructionsLabel);
        this.getContentPane().add(namePanel);
        this.optionsPanel = new Panel();
        this.optionsGroup = new ButtonGroup();
        this.paramOptions = new RadioButton[RModule.availableParamTypes.keySet().size()];
        int i = 0;
        for (String name : RModule.availableParamTypes.keySet()) {
            this.paramOptions[i] = new RadioButton();
            this.paramOptions[i].setText(name);
            this.optionsGroup.add(this.paramOptions[i]);
            this.optionsPanel.add(this.paramOptions[i]);
            ++i;
        }
        this.getContentPane().add(this.optionsPanel);
        this.okButton = new Button();
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(70, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewParamDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton = new Button();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(70, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewParamDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        Panel buttonsPanel = new Panel();
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getContentPane().add(buttonsPanel);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.textIsValid()) {
            JOptionPane.showMessageDialog(this.rootPane, "Not a valid name!", "INPUT ERROR", 0);
            return;
        }
        int selected = -1;
        for (int i = 0; i < this.paramOptions.length; ++i) {
            if (!this.paramOptions[i].isSelected()) continue;
            selected = i;
            break;
        }
        if (selected == -1) {
            JOptionPane.showMessageDialog(this.rootPane, "No Parametter Type selected", "INPUT ERROR", 0);
            return;
        }
        this.name = this.nameTextField.getText();
        this.type = this.paramOptions[selected].getText();
        this.successful = true;
        this.setVisible(false);
    }
}

