/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.dragAndDrop;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import peridot.GUI.dialog.NewExpressionDialog;
import peridot.GUI.dragAndDrop.IndexedStringListTransferable;
import peridot.GUI.panel.ConditionPanel;
import peridot.IndexedString;
import peridot.Log;

public class ListTransferHandler
extends TransferHandler {
    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return (support.getComponent() instanceof JList || support.getComponent() instanceof ConditionPanel) && support.isDataFlavorSupported(IndexedStringListTransferable.LIST_ITEMS_DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean accept;
        block8: {
            accept = false;
            if (this.canImport(support)) {
                System.out.println("...can import the transfer");
                try {
                    Transferable t = support.getTransferable();
                    Object value = t.getTransferData(IndexedStringListTransferable.LIST_ITEMS_DATA_FLAVOR);
                    if (!(value instanceof List)) break block8;
                    System.out.println("It is a ListItem...");
                    Component component = support.getComponent();
                    if (component instanceof ConditionPanel) {
                        DefaultListModel model = (DefaultListModel)((ConditionPanel)component).contents.getModel();
                        List list = (List)value;
                        for (IndexedString string : list) {
                            model.addElement(string);
                        }
                        ((ConditionPanel)component).contents.setModel(model);
                        accept = true;
                        break block8;
                    }
                    if (component instanceof JList) {
                        System.out.println("It is a JList");
                        DefaultListModel model = (DefaultListModel)((JList)component).getModel();
                        List list = (List)value;
                        for (IndexedString string : list) {
                            model.addElement(string);
                        }
                        ((JList)component).setModel(model);
                        accept = true;
                        break block8;
                    }
                    System.out.println("It is something not defined.");
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            } else {
                System.out.println("...can not import the transfer");
            }
        }
        return accept;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        IndexedStringListTransferable t = null;
        if (c instanceof JList) {
            JList list = (JList)c;
            List<IndexedString> value = list.getSelectedValuesList();
            if (value instanceof List) {
                List<IndexedString> li = value;
                t = new IndexedStringListTransferable(li);
            } else {
                Log.logger.severe("What you are trying to export is no List");
            }
        }
        return t;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        block6: {
            Object text = null;
            if (action == 0) {
                return;
            }
            try {
                Object value = data.getTransferData(IndexedStringListTransferable.LIST_ITEMS_DATA_FLAVOR);
                if (value instanceof List) {
                    List list = (List)value;
                    if (source instanceof JList) {
                        DefaultListModel model = (DefaultListModel)((JList)source).getModel();
                        for (IndexedString element : list) {
                            model.removeElement(element);
                        }
                        NewExpressionDialog.setChangedConditions(true);
                    }
                    break block6;
                }
                throw new Exception("value is not a ListItem");
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }
}

