/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.javaFXPanels;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import peridot.GUI.dialog.ScriptOutputDialog;
import peridot.GUI.javaFXPanels.InterpreterManagerJX;
import peridot.Log;
import peridot.Output;
import peridot.script.r.InstallationBatch;
import peridot.script.r.Interpreter;
import peridot.script.r.PackageInstaller;

public class InstallationBatchJX
implements Initializable {
    public List<PackageInstaller> installers = null;
    protected Map<PackageInstaller, Label> statusIndicators = null;
    protected Map<PackageInstaller, Button> outputButtons = null;
    protected Map<PackageInstaller, ScriptOutputDialog> outputDialogs = null;
    public Interpreter interpreter = null;
    public InstallationBatch batch = null;
    private AtomicBoolean stopFlag = new AtomicBoolean(false);
    private Timeline timeLine;
    @FXML
    private CheckBox autoCloseCheckBox;
    @FXML
    private FlowPane flowPane;

    public void initialize(URL url, ResourceBundle resourceBundle) {
        Log.logger.info("Initializing InstallationBatch GUI");
    }

    public void installPackagesIn(Interpreter interpreter) {
        this.interpreter = interpreter;
        this.batch = new InstallationBatch(interpreter.getPackagesToInstall(), interpreter);
        this.installers = new LinkedList<PackageInstaller>();
        this.installers.addAll(this.batch.installationQueue);
        this.statusIndicators = new HashMap<PackageInstaller, Label>();
        this.outputButtons = new HashMap<PackageInstaller, Button>();
        this.outputDialogs = new HashMap<PackageInstaller, ScriptOutputDialog>();
        this.createWatchRows();
        this.startInstallations();
    }

    private void createWatchRows() {
        for (PackageInstaller installer : this.installers) {
            this.createWatchRow(installer);
        }
    }

    private void createWatchRow(final PackageInstaller installer) {
        HBox box = new HBox();
        box.setPrefWidth(this.flowPane.getPrefWidth() - 5.0);
        box.setAlignment(Pos.CENTER);
        box.setSpacing(22.0);
        Label nameLabel = new Label(installer.getPackageName());
        nameLabel.setFont(this.autoCloseCheckBox.getFont());
        Label statusLabel = new Label(installer.status.name().replace('_', ' '));
        statusLabel.setFont(this.autoCloseCheckBox.getFont());
        this.statusIndicators.put(installer, statusLabel);
        Button outputButton = new Button();
        Image img = new Image(this.getClass().getResourceAsStream("/icons/Terminal-icon-32.png"));
        outputButton.setGraphic((Node)new ImageView(img));
        outputButton.setPrefSize(30.0, 25.0);
        outputButton.setDisable(true);
        outputButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                ScriptOutputDialog dialog = InstallationBatchJX.this.outputDialogs.get(installer);
                if (dialog != null) {
                    SwingUtilities.invokeLater(() -> dialog.setVisible(true));
                } else {
                    Output output = installer.script.output;
                    if (output != null) {
                        SwingUtilities.invokeLater(() -> {
                            ScriptOutputDialog newDialog = new ScriptOutputDialog(null, false, installer.getPackageName() + " Installation", output);
                            InstallationBatchJX.this.outputDialogs.put(installer, newDialog);
                            newDialog.setVisible(true);
                        });
                    }
                }
            }
        });
        this.outputButtons.put(installer, outputButton);
        box.getChildren().add((Object)nameLabel);
        box.getChildren().add((Object)statusLabel);
        box.getChildren().add((Object)outputButton);
        this.flowPane.getChildren().add((Object)box);
    }

    private void startInstallations() {
        this.batch.startInstallations();
        KeyFrame kf = new KeyFrame(Duration.millis((double)500.0), actionEvent -> {
            for (PackageInstaller installer : this.installers) {
                this.statusIndicators.get(installer).setText(installer.status.name().replace('_', ' '));
                if (!this.outputButtons.get(installer).isDisable() || installer.status == PackageInstaller.Status.NOT_STARTED) continue;
                this.outputButtons.get(installer).setDisable(false);
            }
            if (!this.batch.isRunning()) {
                this.askToStopNow();
            }
        }, new KeyValue[0]);
        this.timeLine = new Timeline(new KeyFrame[]{kf});
        this.timeLine.setCycleCount(-1);
        this.timeLine.play();
    }

    public void askToStopNow() {
        if (this.batch.isRunning()) {
            this.batch.stop();
        }
        this.timeLine.stop();
        if (this.autoCloseCheckBox.isSelected()) {
            Stage stage = (Stage)this.autoCloseCheckBox.getScene().getWindow();
            stage.close();
        }
        InterpreterManagerJX.askToUpdateListOfInterpreters();
    }
}

