/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.javaFXPanels;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import peridot.GUI.GUIUtils;
import peridot.GUI.MainGUI;
import peridot.GUI.javaFXPanels.InstallationBatchJX;
import peridot.GUI.javaFXPanels.InterpreterManagerSwingDialog;
import peridot.Log;
import peridot.script.r.Interpreter;

public class InterpreterManagerJX
implements Initializable {
    private static InterpreterManagerJX _instance = null;
    HashMap<TitledPane, Integer> interpreterOfPane;
    TitledPane selectedPane = null;
    @FXML
    Accordion accordion;
    @FXML
    Label recommendation;
    @FXML
    Button rmEnvButton;
    @FXML
    Button installButton;
    @FXML
    Button addEnvButton;
    @FXML
    Button okButton;
    @FXML
    AnchorPane anchorPane;

    @FXML
    public void installPackages(ActionEvent event) {
        if (this.selectedPane == null) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/InstallationBatchJX.fxml"));
            loader.load();
            Parent root = (Parent)loader.getRoot();
            final InstallationBatchJX control = (InstallationBatchJX)loader.getController();
            Stage stage = new Stage();
            Scene scene = new Scene(root, 396.0, 400.0);
            stage.initStyle(StageStyle.DECORATED);
            stage.setTitle("Installation Queue");
            stage.setScene(scene);
            stage.initModality(Modality.APPLICATION_MODAL);
            Image awtIcon = MainGUI.getDefaultIcon(this);
            BufferedImage buffImage = GUIUtils.toBufferedImage(awtIcon);
            WritableImage fxIcon = SwingFXUtils.toFXImage((BufferedImage)buffImage, null);
            stage.getIcons().add((Object)fxIcon);
            control.installPackagesIn(Interpreter.interpreters.get(this.interpreterOfPane.get(this.selectedPane)));
            stage.setResizable(false);
            stage.show();
            stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    control.askToStopNow();
                    InterpreterManagerJX.this.startAccordion();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void chooseInterpreter(TitledPane expanded) {
        this.selectedPane = expanded;
        int i = this.interpreterOfPane.get(expanded);
        if (Interpreter.setDefault(i)) {
            if (Interpreter.defaultInterpreter.getPackagesToInstall().size() > 0) {
                this.recommendation.setVisible(true);
            } else {
                this.recommendation.setVisible(false);
            }
            expanded.setFont(Font.font((String)expanded.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (double)expanded.getFont().getSize()));
            expanded.setText(Interpreter.interpreters.get(this.interpreterOfPane.get(expanded)).titleString());
        } else {
            Log.logger.warning("Invalid environment chosen, not using it.");
        }
    }

    @FXML
    public void okButton(ActionEvent event) {
        InterpreterManagerSwingDialog.closeWindow();
    }

    @FXML
    public void addInterpreter(ActionEvent event) {
        boolean valid;
        FileChooser fileChooser = new FileChooser();
        Node source = (Node)event.getSource();
        Window theStage = source.getScene().getWindow();
        File file = fileChooser.showOpenDialog(theStage);
        if (file != null && file.exists() && file.isFile() && (valid = Interpreter.addInterpreter(file.getAbsolutePath()))) {
            this.startAccordion();
            return;
        }
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid R Environment");
        alert.setHeaderText(null);
        alert.setContentText("Please choose a R executable next time.");
        alert.showAndWait();
    }

    @FXML
    public void removeInterpreter(ActionEvent event) {
        int activeInterpreter;
        boolean removed;
        if (this.selectedPane != null && (removed = Interpreter.removeInterpreter(activeInterpreter = this.interpreterOfPane.get(this.selectedPane).intValue()))) {
            this.startAccordion();
        }
    }

    public void updateInterpreterAccordion() {
        this.startAccordion();
    }

    public void startAccordion() {
        this.interpreterOfPane = new HashMap();
        this.accordion.getPanes().remove(0, this.accordion.getPanes().size());
        int i = 0;
        this.selectedPane = null;
        for (Interpreter interpreter : Interpreter.interpreters) {
            TitledPane pane = this.getTitledPaneFromEnvironment(interpreter);
            this.accordion.getPanes().add((Object)pane);
            this.interpreterOfPane.put(pane, i);
            ++i;
        }
    }

    public void updateButtonsEnabled() {
        this.rmEnvButton.setDisable(true);
        this.installButton.setDisable(true);
        if (this.selectedPane != null) {
            this.rmEnvButton.setDisable(false);
            try {
                if (Interpreter.interpreters.get(this.interpreterOfPane.get(this.selectedPane)).getPackagesToInstall().size() > 0) {
                    this.installButton.setDisable(false);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        _instance = this;
        Log.logger.info("Initializing R Environment Manager");
        this.startAccordion();
        this.okButton.setGraphic((Node)new ImageView(new javafx.scene.image.Image(this.getClass().getResourceAsStream("/icons/Clear-Green-Button-icon24.png"))));
        this.addEnvButton.setGraphic((Node)new ImageView(new javafx.scene.image.Image(this.getClass().getResourceAsStream("/icons/add-green-button-icon-24.png"))));
        this.rmEnvButton.setGraphic((Node)new ImageView(new javafx.scene.image.Image(this.getClass().getResourceAsStream("/icons/Delete-icon-24.png"))));
        this.installButton.setGraphic((Node)new ImageView(new javafx.scene.image.Image(this.getClass().getResourceAsStream("/icons/download-icon-24.png"))));
    }

    public TitledPane getTitledPaneFromEnvironment(final Interpreter interpreter) {
        AnchorPane newPanelContent = new AnchorPane();
        String toInstallString = interpreter.packagesToInstallString();
        if (toInstallString.length() <= 1) {
            toInstallString = "No packages to install.";
        }
        newPanelContent.getChildren().add((Object)new Label(toInstallString));
        final TitledPane pane = new TitledPane(interpreter.titleString(), (Node)newPanelContent);
        if (Interpreter.isDefaultInterpreterDefined() && Interpreter.defaultInterpreter.exe.equals(interpreter.exe)) {
            pane.setFont(Font.font((String)pane.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (double)pane.getFont().getSize()));
            pane.setText(interpreter.titleString());
            this.selectedPane = pane;
            pane.setExpanded(true);
        }
        pane.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue() && pane != InterpreterManagerJX.this.selectedPane) {
                    pane.setFont(Font.font((String)pane.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (double)pane.getFont().getSize()));
                    pane.setText(interpreter.titleString());
                    InterpreterManagerJX.this.chooseInterpreter(pane);
                    for (TitledPane p : InterpreterManagerJX.this.accordion.getPanes()) {
                        if (p == pane) continue;
                        p.setFont(Font.font((String)p.getFont().getFamily(), (FontWeight)FontWeight.NORMAL, (double)p.getFont().getSize()));
                        pane.setText(interpreter.titleString());
                    }
                }
                InterpreterManagerJX.this.updateButtonsEnabled();
            }
        });
        return pane;
    }

    public static void askToUpdateListOfInterpreters() {
        if (_instance != null) {
            Platform.runLater(() -> _instance.startAccordion());
        }
    }
}

