/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.javaFXPanels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import peridot.GUI.Main;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.javaFXPanels.InterpreterManagerJX;
import peridot.Log;
import peridot.script.RModule;
import peridot.script.r.Interpreter;

public class InterpreterManagerSwingDialog
extends JDialog {
    public static Dimension defaultSize = new Dimension(637, 400);
    private static int spacing = 0;
    public static InterpreterManagerSwingDialog _instance = null;
    public static final String titleString = "R Environment Manager";
    private final JFXPanel jfxPanel = new JFXPanel();
    private boolean onStart;
    private Runnable onEnd;

    public InterpreterManagerSwingDialog(Frame parent, Runnable onEnd) {
        super(parent, true);
        this.onEnd = onEnd;
        this.setModal(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((double)screenSize.width - defaultSize.getWidth()) / 2;
        int y = (int)((double)screenSize.height - defaultSize.getHeight()) / 2;
        this.setLocation(x, y);
        this.setTitle(titleString);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InterpreterManagerSwingDialog.this.closeEvent();
            }
        });
        this.setResizable(false);
        this.setIconImage(MainGUI.getDefaultIcon(this));
        this.setLayout(new FlowLayout(0, spacing, spacing));
        this.setMinimumSize(defaultSize);
        this.setPreferredSize(defaultSize);
        this.add((Component)this.jfxPanel);
        _instance = this;
        Platform.runLater(() -> {
            try {
                Log.logger.severe("Loading InterpreterManagerJX scene.");
                Parent root = Resources.getFXML(this.getClass(), "InterpreterManager.fxml");
                this.jfxPanel.setScene(new Scene(root, (double)(InterpreterManagerSwingDialog.defaultSize.width - 7), (double)(InterpreterManagerSwingDialog.defaultSize.height - 28)));
                Log.logger.severe("Loaded InterpreterManagerJX scene.");
            }
            catch (IOException ex) {
                Log.logger.severe("Could not load InterpreterManagerJX scene.");
                ex.printStackTrace();
            }
        });
        this.setVisible(true);
    }

    private void closeEvent() {
        int reply;
        boolean closeEverything = false;
        if (!Interpreter.isDefaultInterpreterDefined()) {
            closeEverything = true;
            int reply2 = JOptionPane.showConfirmDialog(_instance, "Since no R environment was chosen, R-Peridot will have to close.", "Exiting Environment Manager without choosing an environment!", 2);
            if (reply2 == 2) {
                return;
            }
        } else if (RModule.modulesWithUnmetDependencies().containsAll(RModule.getAvailableAnalysisModules()) && (reply = JOptionPane.showConfirmDialog(_instance, "The selected R environment does not have the dependencies to run any module, are you sure you want to use it?", "This environment cannot run any module!", 2)) == 2) {
            return;
        }
        this.setVisible(false);
        if (closeEverything) {
            Main.endMain();
        } else {
            this.onEnd.run();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.getParent().setVisible(visible);
        super.setVisible(visible);
        if (visible) {
            InterpreterManagerJX.askToUpdateListOfInterpreters();
        }
    }

    public static void closeWindow() {
        SwingUtilities.invokeLater(() -> _instance.closeEvent());
    }

    public static void openInterpreterManager(Runnable onEnd) {
        DummyFrame dummy = new DummyFrame(titleString);
        InterpreterManagerSwingDialog managerGUI = new InterpreterManagerSwingDialog((Frame)dummy, onEnd);
    }

    public static class DummyFrame
    extends JFrame {
        public DummyFrame(String title) {
            super(title);
            this.setUndecorated(true);
            this.setVisible(true);
            this.setLocationRelativeTo(null);
            this.setIconImage(MainGUI.getDefaultIcon(this));
        }
    }
}

