/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import peridot.GUI.Resources;
import peridot.GUI.component.Button;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.NewExpressionDialog;
import peridot.GUI.dragAndDrop.ListTransferHandler;
import peridot.IndexedString;

public class ConditionPanel
extends Panel {
    public JList contents;
    private JLabel conditionNameLabel;
    private JButton editNameButton;
    private Dimension defaultSize;
    Dimension contentsSize;
    Dimension contentsMinSize;
    Dimension internalPanelMax;
    Dimension internalPanelMin;

    public ConditionPanel(IndexedString[] indexedNames, String conditionName, boolean nameEditable) {
        this.defaultSize = new Dimension(NewExpressionDialog.conditionsPaneSize.width / 4 + 6, 300);
        this.contentsSize = new Dimension(this.defaultSize.width - 6, this.defaultSize.height - 30);
        this.contentsMinSize = new Dimension(this.contentsSize.width - 23 - 5, 30);
        this.internalPanelMax = new Dimension(this.contentsSize.width - 23, 2000);
        this.internalPanelMin = new Dimension(this.internalPanelMax.width, this.contentsSize.height - 15);
        this.conditionNameLabel = new Label();
        this.editNameButton = new Button();
        this.setMaximumSize(new Dimension(0, 0));
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(this.defaultSize);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.conditionNameLabel.setText("condition-XXX");
        this.add(this.conditionNameLabel);
        this.editNameButton.setIcon(Resources.getImageIcon(this.getClass(), "Write-Document-icon16.png"));
        this.editNameButton.setToolTipText("Edit name");
        this.editNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionPanel.this.editNameButtonActionPerformed(evt);
            }
        });
        this.add(this.editNameButton);
        this.conditionNameLabel.setText(conditionName);
        this.editNameButton.setEnabled(nameEditable);
        if (conditionName.equals("not-use")) {
            this.editNameButton.setEnabled(false);
        }
        this.contents = new JList();
        this.contents.setMinimumSize(this.contentsMinSize);
        this.contents.setDragEnabled(true);
        this.contents.setTransferHandler(new ListTransferHandler());
        this.setTransferHandler(new ListTransferHandler());
        DefaultListModel<IndexedString> model = new DefaultListModel<IndexedString>();
        for (int i = 0; i < indexedNames.length; ++i) {
            model.addElement(new IndexedString(indexedNames[i].getNumber(), indexedNames[i].getText()));
        }
        this.contents.setModel(model);
        this.contents.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setFocusCycleRoot(false);
        scrollPane.setFocusTraversalPolicyProvider(true);
        scrollPane.setFocusable(false);
        scrollPane.setPreferredSize(this.contentsSize);
        Panel internalPanel = new Panel();
        internalPanel.setFocusable(false);
        internalPanel.setMaximumSize(this.internalPanelMax);
        internalPanel.setMinimumSize(this.internalPanelMin);
        internalPanel.setLayout(new FlowLayout(0));
        internalPanel.add(this.contents);
        scrollPane.setViewportView(internalPanel);
        this.add(scrollPane);
    }

    public String getConditionName() {
        String text = this.conditionNameLabel.getText();
        return text;
    }

    private void editNameButtonActionPerformed(ActionEvent evt) {
        String oldName = this.getConditionName();
        String newName = NewExpressionDialog.inputConditionName(oldName);
        if (newName != null) {
            this.conditionNameLabel.setText(newName);
            NewExpressionDialog.updateConditionName(oldName, newName);
        }
    }
}

