/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import peridot.AnalysisData;
import peridot.AnalysisParameters;
import peridot.Archiver.Manager;
import peridot.Archiver.Places;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.BiggerLabel;
import peridot.GUI.component.Button;
import peridot.GUI.component.CheckBox;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.NewExpressionDialog;
import peridot.GUI.dialog.SpecificParametersDialog;
import peridot.GUI.dialog.modulesManager.ModuleDetailsDialog;
import peridot.GUI.panel.ParametersPanel;
import peridot.GUI.panel.ProcessingPanel;
import peridot.Global;
import peridot.Log;
import peridot.script.AnalysisModule;
import peridot.script.RModule;

public class NewAnalysisPanel
extends Panel {
    private AnalysisData expression;
    private Frame parentFrame;
    public TreeSet<String> selectedScripts;
    public TreeSet<String> availableScripts;
    public TreeSet<String> availablePackages;
    public TreeMap<String, AnalysisParameters> specificParameters;
    private Map<String, JCheckBox> scriptCheckboxes;
    private ParametersPanel parametersPanel;
    private NewExpressionDialog expressionGUI;
    public int sleepBetweenComponents = 120;
    public int sleepBetweenChecks = 100;
    public int nPostAnalysisModules = 0;
    public int nAnalysisModules = 0;
    public JButton createButton;
    private JPanel createContainer;
    private JButton defineButton;
    private JPanel defineExpressionContainer;
    private JLabel expressionDescriptionLabel;
    private JLabel multiConditionsLabel;
    private JLabel needsReplicatesLabel;
    private JLabel geneExprLabel1;
    private JButton defineGeneListButton;
    private JPanel defineGeneListContainer;
    private JLabel geneListDescriptionLabel;
    private JLabel geneListLabel;
    private boolean modulesAlwaysVisible;
    private JPanel leftSide;
    private JPanel modulesContainer;
    private JLabel modulesLabel;
    private JPanel modulesLeftSide;
    private JPanel modulesRightSide;
    private JSeparator modulesSeparator;
    private JLabel othersPackages;
    private JLabel packagesLabel1;
    private JPanel packagesPanel;
    private JPanel parametersContainer;
    private JLabel parametersLabel;
    private JPanel rightSide;
    private JPanel scriptsPanel;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator3;
    private TreeMap<String, JButton> editModuleParamsButtons;
    private TreeMap<String, JButton> moduleDetailButtons;

    public NewAnalysisPanel(Frame parentFrame) {
        this.createInterface();
    }

    public void createInterface() {
        this.removeAll();
        this.modulesAlwaysVisible = false;
        this.parentFrame = this.parentFrame;
        this.availableScripts = new TreeSet();
        this.availablePackages = new TreeSet();
        this.availableScripts.addAll(RModule.getAvailablePostAnalysisModules());
        this.availableScripts.addAll(RModule.getAvailableAnalysisModules());
        this.selectedScripts = new TreeSet();
        this.specificParameters = new TreeMap();
        for (String pack : this.availableScripts) {
            RModule aScript = RModule.availableModules.get(pack);
            if (!(aScript instanceof AnalysisModule)) continue;
            AnalysisParameters params = new AnalysisParameters(aScript.requiredParameters, aScript.parameters);
            this.specificParameters.put(pack, params);
            this.availablePackages.add(pack);
        }
        this.customInit();
    }

    public int getNPackagesSelected() {
        int n = 0;
        for (String scriptName : this.selectedScripts) {
            RModule script = RModule.availableModules.get(scriptName);
            if (!(script instanceof AnalysisModule)) continue;
            ++n;
        }
        return n;
    }

    private void updateRNASeqDescription() {
        String nLines;
        int nConditions = this.expression.getNumberOfConditions();
        try {
            nLines = Integer.toString(Manager.countLines(Places.countReadsInputFile.getAbsolutePath()) - 1);
        }
        catch (IOException ex) {
            nLines = "[could not read]";
        }
        this.expressionDescriptionLabel.setText(this.expression.getNumberOfSamples() + " samples, " + nConditions + " conditions and " + nLines + " lines.");
        if (this.expression.hasMoreThanTwoConditions()) {
            this.multiConditionsLabel.setText("More than 2 conditions, some modules may be disabled.");
        } else {
            this.multiConditionsLabel.setText("");
        }
        if (!this.expression.hasReplicatesInSamples()) {
            this.needsReplicatesLabel.setText("No replicates, some modules may be disabled.");
        } else {
            this.needsReplicatesLabel.setText("");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean moreThan2Conditions() {
        void var4_8;
        if (this.expression == null) {
            return false;
        }
        Vector<String> conditionsOriginal = new Vector<String>(this.expression.conditions.values());
        TreeSet<String> conditions = new TreeSet<String>();
        for (String string : conditionsOriginal) {
            boolean bl = false;
            for (String string2 : conditions) {
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            conditions.add(string);
        }
        boolean notUsePresent = false;
        for (String string : conditions) {
            if (!string.equals("not-use")) continue;
            notUsePresent = true;
            break;
        }
        int n = conditions.size();
        if (notUsePresent) {
            --var4_8;
        }
        return var4_8 > 2;
    }

    private void customInit() {
        this.setPreferredSize(MainGUI.defaultSize);
        this.setLayout(new FlowLayout(1, 5, 1));
        this.makeDefineExpressionContainer();
        this.separator1 = new JSeparator();
        this.separator1.setPreferredSize(new Dimension(490, 2));
        this.makeModulesContainer();
        this.separator2 = new JSeparator();
        this.separator2.setPreferredSize(new Dimension(490, 2));
        this.makeParametersContainer();
        this.separator3 = new JSeparator();
        this.separator3.setPreferredSize(new Dimension(490, 2));
        this.makeCreateContainer();
        this.add(this.defineExpressionContainer);
        this.add(this.separator1);
        this.separator1.setVisible(false);
        this.modulesContainer.setVisible(false);
        this.add(this.modulesContainer);
        this.separator2.setVisible(false);
        this.add(this.separator2);
        this.parametersContainer.setVisible(false);
        this.add(this.parametersContainer);
        this.separator3.setVisible(false);
        this.add(this.separator3);
        this.createContainer.setVisible(false);
        this.add(this.createContainer);
        this.tryToHideModules();
        this.tryToHideParamsAndCreate();
        JCheckBox box = this.scriptCheckboxes.get("VennDiagram");
        if (box != null) {
            box.doClick();
        }
    }

    private void makeCreateContainer() {
        this.createContainer = new Panel();
        this.createContainer.setPreferredSize(new Dimension(530, 75));
        this.createContainer.setLayout(new FlowLayout(2));
        this.createButton = new BigButton();
        this.createButton.setText("Start");
        this.createButton.setPreferredSize(new Dimension(112, 70));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewAnalysisPanel.this.createButtonActionPerformed(evt);
            }
        });
        this.createButton.setIcon(Resources.getImageIcon(this.getClass(), "play-icon-32.png"));
        this.createContainer.add(this.createButton);
    }

    private void makeParametersContainer() {
        this.parametersContainer = new Panel();
        this.parametersContainer.setPreferredSize(new Dimension(530, 138));
        this.parametersContainer.setLayout(new FlowLayout(0, 5, 0));
        this.parametersLabel = new BiggerLabel();
        this.parametersLabel.setText("Parameters");
        this.parametersContainer.add(this.parametersLabel);
        HashMap<String, Class> allParamsMap = new HashMap<String, Class>();
        for (String scriptName : this.availableScripts) {
            Map<String, Class> scriptParams = null;
            RModule script = RModule.availableModules.get(scriptName);
            if (script == null) continue;
            scriptParams = script.requiredParameters;
            allParamsMap.putAll(scriptParams);
        }
        AnalysisParameters allParams = new AnalysisParameters(allParamsMap);
        this.parametersPanel = new ParametersPanel(false);
        this.parametersPanel.setPreferredSize(new Dimension(this.parametersContainer.getPreferredSize().width - 20, 30));
        this.parametersPanel.setMaximumSize(new Dimension(this.parametersContainer.getPreferredSize().width - 20, 3000));
        this.parametersPanel.setLayout(new FlowLayout(0, 6, 0));
        JScrollPane scroller = new JScrollPane(this.parametersPanel);
        scroller.setPreferredSize(new Dimension(this.parametersContainer.getPreferredSize().width - 10, this.parametersContainer.getPreferredSize().height - 30));
        scroller.setBorder(BorderFactory.createEmptyBorder());
        this.parametersContainer.add(scroller);
        this.parametersPanel.setParams(allParams);
    }

    private void makeModulesContainer() {
        int sideH = 255;
        this.modulesContainer = new Panel();
        this.modulesContainer.setPreferredSize(new Dimension(545, sideH + 25));
        this.modulesContainer.setLayout(new FlowLayout(1, 10, 1));
        this.modulesLabel = new BiggerLabel();
        this.modulesLabel.setHorizontalAlignment(0);
        this.modulesLabel.setText("Modules");
        this.modulesLabel.setPreferredSize(new Dimension(480, 20));
        this.modulesLeftSide = new Panel();
        this.modulesLeftSide.setPreferredSize(new Dimension(245, sideH));
        this.modulesLeftSide.setRequestFocusEnabled(false);
        this.packagesLabel1 = new BigLabel();
        this.packagesLabel1.setText("Analysis:");
        this.packagesPanel = new Panel();
        this.packagesPanel.setMaximumSize(new Dimension(this.modulesLeftSide.getPreferredSize().width - 10, 3000));
        this.packagesPanel.setLayout(new BoxLayout(this.packagesPanel, 1));
        JScrollPane packagesScroller = new JScrollPane(this.packagesPanel);
        packagesScroller.setPreferredSize(new Dimension(this.modulesLeftSide.getPreferredSize().width, this.modulesLeftSide.getPreferredSize().height - 30));
        packagesScroller.setBorder(BorderFactory.createEmptyBorder());
        this.modulesLeftSide.add(this.packagesLabel1);
        this.modulesLeftSide.add(packagesScroller);
        this.modulesSeparator = new JSeparator();
        this.modulesSeparator.setOrientation(1);
        this.modulesSeparator.setPreferredSize(new Dimension(2, 120));
        this.modulesRightSide = new Panel();
        this.modulesRightSide.setPreferredSize(new Dimension(240, sideH));
        this.modulesRightSide.setRequestFocusEnabled(false);
        this.othersPackages = new BigLabel();
        this.othersPackages.setText("Post Analysis:");
        this.scriptsPanel = new Panel();
        this.scriptsPanel.setMaximumSize(new Dimension(this.modulesRightSide.getPreferredSize().width - 10, 3000));
        this.scriptsPanel.setLayout(new BoxLayout(this.scriptsPanel, 1));
        JScrollPane scriptsScroller = new JScrollPane(this.scriptsPanel);
        scriptsScroller.setPreferredSize(new Dimension(this.modulesRightSide.getPreferredSize().width, this.modulesRightSide.getPreferredSize().height - 30));
        scriptsScroller.setBorder(BorderFactory.createEmptyBorder());
        this.modulesRightSide.add(this.othersPackages);
        this.modulesRightSide.add(scriptsScroller);
        this.modulesContainer.add(this.modulesLabel);
        this.modulesContainer.add(this.modulesLeftSide);
        this.modulesContainer.add(this.modulesSeparator);
        this.modulesContainer.add(this.modulesRightSide);
        this.initScriptsCheckboxes();
    }

    private void makeDefineExpressionContainer() {
        this.defineExpressionContainer = new Panel();
        this.defineExpressionContainer.setPreferredSize(new Dimension(530, 90));
        this.leftSide = new Panel();
        this.leftSide.setPreferredSize(new Dimension(397, 90));
        this.leftSide.setLayout(new FlowLayout(0));
        this.geneExprLabel1 = new BiggerLabel();
        this.geneExprLabel1.setText("Expression Data (count reads):");
        this.expressionDescriptionLabel = new Label();
        this.multiConditionsLabel = new Label();
        this.needsReplicatesLabel = new Label();
        this.expressionDescriptionLabel.setText("...");
        this.multiConditionsLabel.setText("");
        this.needsReplicatesLabel.setText("");
        this.expressionDescriptionLabel.setPreferredSize(new Dimension(370, 15));
        this.multiConditionsLabel.setPreferredSize(new Dimension(370, 15));
        this.needsReplicatesLabel.setPreferredSize(new Dimension(370, 15));
        this.leftSide.add(this.geneExprLabel1);
        this.leftSide.add(this.expressionDescriptionLabel);
        this.leftSide.add(this.multiConditionsLabel);
        this.leftSide.add(this.needsReplicatesLabel);
        this.rightSide = new Panel();
        this.rightSide.setLayout(new FlowLayout(2));
        this.defineButton = new BigButton();
        this.defineButton.setText("Open File");
        this.defineButton.setPreferredSize(new Dimension(112, 70));
        this.defineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewAnalysisPanel.this.defineButtonActionPerformed(evt);
            }
        });
        this.defineButton.setIcon(Resources.getImageIcon(this.getClass(), "write-document-32.png"));
        this.rightSide.add(this.defineButton);
        this.defineExpressionContainer.add(this.leftSide);
        this.defineExpressionContainer.add(this.rightSide);
    }

    public void updateUnabledScripts() {
        for (String name : RModule.getAvailableAnalysisModules()) {
            this.updateAnalysisModuleUnabledNoRecursion(name);
        }
        for (String name : RModule.getAvailablePostAnalysisModules()) {
            this.updateModuleUnabled(name);
        }
    }

    private void updateAnalysisModuleUnabledNoRecursion(String module) {
        boolean unabled = true;
        RModule script = RModule.availableModules.get(module);
        JCheckBox checkbox = this.scriptCheckboxes.get(module);
        if (script instanceof AnalysisModule && this.expression != null && (script.max2Conditions && this.expression.hasMoreThanTwoConditions() || script.needsReplicates && !this.expression.hasReplicatesInSamples())) {
            unabled = false;
        }
        if (!script.requiredPackagesInstalled()) {
            unabled = false;
        }
        if (!unabled) {
            // empty if block
        }
        if (checkbox != null && unabled != checkbox.isEnabled()) {
            JButton paramsButton = this.editModuleParamsButtons.get(module);
            if (paramsButton != null) {
                // empty if block
            }
            if (unabled) {
                checkbox.setEnabled(true);
            } else {
                if (checkbox.isSelected()) {
                    checkbox.doClick();
                }
                checkbox.setEnabled(false);
            }
        }
    }

    private void updateModuleUnabled(String module) {
        JCheckBox checkbox;
        RModule script;
        boolean unabled;
        block11: {
            block10: {
                unabled = true;
                script = RModule.availableModules.get(module);
                checkbox = this.scriptCheckboxes.get(module);
                if (!(script instanceof AnalysisModule)) break block10;
                if (this.expression == null || (!script.max2Conditions || !this.expression.hasMoreThanTwoConditions()) && (!script.needsReplicates || this.expression.hasReplicatesInSamples())) break block11;
                unabled = false;
                break block11;
            }
            if (this.nAnalysisModules < 1) {
                unabled = false;
            }
            for (String name : RModule.availableModules.get((Object)module).requiredScripts) {
                if (this.selectedScripts.contains(name)) continue;
                unabled = false;
                break;
            }
        }
        if (!script.requiredPackagesInstalled()) {
            unabled = false;
        }
        if (checkbox != null) {
            if (unabled != checkbox.isEnabled()) {
                JButton paramsButton = this.editModuleParamsButtons.get(module);
                if (paramsButton != null) {
                    paramsButton.setEnabled(unabled);
                    this.updateUnabledScripts();
                }
                if (unabled) {
                    checkbox.setEnabled(true);
                } else {
                    if (checkbox.isSelected()) {
                        checkbox.doClick();
                    }
                    checkbox.setEnabled(false);
                }
                this.updateDependantModulesUnabled(module);
            }
        } else {
            unabled = false;
        }
    }

    private void updateDependantModulesUnabled(String module) {
        if (RModule.availableModules.get(module) instanceof AnalysisModule) {
            for (String script : RModule.getAvailablePostAnalysisModules()) {
                this.updateModuleUnabled(script);
            }
        } else {
            for (Map.Entry<String, RModule> pair : RModule.availableModules.entrySet()) {
                boolean depends = false;
                for (String required : pair.getValue().requiredScripts) {
                    if (!required.equals(module)) continue;
                    depends = true;
                    break;
                }
                if (!depends) continue;
                this.updateModuleUnabled(pair.getKey());
            }
        }
    }

    private void defineButtonActionPerformed(ActionEvent evt) {
        if (this.expressionGUI == null) {
            this.expressionGUI = new NewExpressionDialog(this.parentFrame, true, this.expression);
        }
        this.expressionGUI.setVisible(true);
        if (!this.expressionGUI.success) {
            return;
        }
        this.expression = this.expressionGUI.getResults();
        if (this.expression != null) {
            try {
                this.expression.writeExpression();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace();
                Log.logger.severe("Could not write count reads file for analysis!");
            }
            this.deleteTempFiles();
            this.updateUnabledScripts();
            RModule.removeScriptResults();
            MainGUI.updateResultsPanel();
            this.updateRNASeqDescription();
        }
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        AnalysisParameters parameters = this.parametersPanel.getParameters();
        if (this.selectedScripts.size() == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select at least 1 package from the list.");
            return;
        }
        for (String scriptName : this.selectedScripts) {
            RModule script = RModule.availableModules.get(scriptName);
            if (!script.requiredExternalFiles.contains(Places.countReadsInputFileName) || this.expression != null) continue;
            JOptionPane.showMessageDialog(this.parentFrame, "To use a RNASeq module you need to define a count reads file.");
            return;
        }
        try {
            ProcessingPanel.start(this.selectedScripts, parameters, this.specificParameters, this.expression);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteTempFiles() {
        for (Map.Entry<String, RModule> pair : RModule.availableModules.entrySet()) {
            pair.getValue().cleanTempFiles();
            pair.getValue().cleanLocalResults();
        }
    }

    private void initScriptsCheckboxes() {
        this.scriptCheckboxes = new TreeMap<String, JCheckBox>();
        this.editModuleParamsButtons = new TreeMap();
        this.moduleDetailButtons = new TreeMap();
        for (String pack : this.availableScripts.descendingSet()) {
            final boolean isAnalysisModule = RModule.availableModules.get(pack) instanceof AnalysisModule;
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0));
            final CheckBox checkBox = new CheckBox();
            checkBox.setText(pack);
            checkBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    NewAnalysisPanel.this.selectScript(checkBox.getText(), checkBox.isSelected(), isAnalysisModule);
                }
            });
            Button detailButton = new Button();
            detailButton.setIcon(Resources.getImageIcon(this.getClass(), "open-icon-16.png"));
            detailButton.setText("Detail");
            detailButton.setEnabled(true);
            detailButton.addActionListener(evt -> {
                ModuleDetailsDialog dialog = new ModuleDetailsDialog(pack, MainGUI.getInstance(), false);
                dialog.setVisible(true);
            });
            this.moduleDetailButtons.put(pack, detailButton);
            if (isAnalysisModule) {
                Button paramsButton = new Button();
                paramsButton.setIcon(Resources.getImageIcon(this.getClass(), "Write-Document-icon16.png"));
                paramsButton.setText("");
                paramsButton.setEnabled(false);
                paramsButton.addActionListener(evt -> {
                    SpecificParametersDialog dialog = new SpecificParametersDialog(this.parentFrame, true, this.specificParameters.get(pack), "Specific parameters for " + pack);
                    dialog.setVisible(true);
                    this.specificParameters.put(pack, dialog.parametersPanel.getParameters());
                });
                this.editModuleParamsButtons.put(pack, paramsButton);
                panel.add(checkBox);
                panel.add(paramsButton);
                panel.add(detailButton);
                this.packagesPanel.add((Component)panel, "West");
            } else {
                panel.add(checkBox);
                panel.add(detailButton);
                this.scriptsPanel.add((Component)panel, "West");
            }
            this.scriptCheckboxes.put(pack, checkBox);
            if (!isAnalysisModule) continue;
            this.updateModuleUnabled(pack);
        }
        this.updateUnabledScripts();
    }

    private Component leftJustify(JPanel panel) {
        Box b = Box.createHorizontalBox();
        b.add(panel);
        b.add(Box.createHorizontalGlue());
        return b;
    }

    public void selectScript(String name, boolean add, boolean analysisScript) {
        if (name.equals("VennDiagram")) {
            if (add) {
                if (!this.selectedScripts.contains("VennDiagram")) {
                    this.selectedScripts.add(name);
                    ++this.nPostAnalysisModules;
                    this.updateDependantModulesUnabled("VennDiagram");
                }
            } else {
                this.scriptCheckboxes.get("VennDiagram").doClick();
            }
            return;
        }
        if (this.selectedScripts.contains(name) != add) {
            if (add) {
                this.selectedScripts.add(name);
                if (analysisScript) {
                    ++this.nAnalysisModules;
                } else {
                    ++this.nPostAnalysisModules;
                }
            } else {
                this.selectedScripts.remove(name);
                if (analysisScript) {
                    --this.nAnalysisModules;
                } else {
                    --this.nPostAnalysisModules;
                }
            }
            if (analysisScript) {
                this.editModuleParamsButtons.get(name).setEnabled(add);
                Log.logger.info("nAnalysisModules: " + this.nAnalysisModules);
            }
            this.updateDependantModulesUnabled(name);
        }
    }

    public void tryToHideModules() {
        try {
            if (!this.modulesContainer.isVisible() && this.modulesAlwaysVisible || this.expression != null && !this.modulesContainer.isVisible()) {
                SwingUtilities.invokeLater(() -> this.separator1.setVisible(true));
                Thread.sleep(this.sleepBetweenComponents);
                SwingUtilities.invokeLater(() -> this.modulesContainer.setVisible(true));
            } else if (this.expression == null && this.modulesContainer.isVisible() && !this.modulesAlwaysVisible) {
                SwingUtilities.invokeLater(() -> this.separator1.setVisible(false));
                Thread.sleep(this.sleepBetweenComponents);
                SwingUtilities.invokeLater(() -> this.modulesContainer.setVisible(false));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Global.setTimeout(() -> this.tryToHideModules(), this.sleepBetweenChecks);
    }

    public void tryToHideParamsAndCreate() {
        try {
            if (this.nAnalysisModules >= 1) {
                if (!this.parametersContainer.isVisible()) {
                    SwingUtilities.invokeLater(() -> this.separator2.setVisible(true));
                    Thread.sleep(this.sleepBetweenComponents);
                    SwingUtilities.invokeLater(() -> this.parametersContainer.setVisible(true));
                }
                Thread.sleep(this.sleepBetweenComponents);
                if (!this.createContainer.isVisible()) {
                    SwingUtilities.invokeLater(() -> this.separator3.setVisible(true));
                    Thread.sleep(this.sleepBetweenComponents);
                    SwingUtilities.invokeLater(() -> this.createContainer.setVisible(true));
                }
            } else {
                if (this.parametersContainer.isVisible()) {
                    SwingUtilities.invokeLater(() -> this.separator2.setVisible(false));
                    Thread.sleep(this.sleepBetweenComponents);
                    SwingUtilities.invokeLater(() -> this.parametersContainer.setVisible(false));
                }
                Thread.sleep(this.sleepBetweenComponents);
                if (this.createContainer.isVisible()) {
                    SwingUtilities.invokeLater(() -> this.separator3.setVisible(false));
                    Thread.sleep(this.sleepBetweenComponents);
                    SwingUtilities.invokeLater(() -> this.createContainer.setVisible(false));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Global.setTimeout(() -> this.tryToHideParamsAndCreate(), this.sleepBetweenChecks);
    }
}

