/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import peridot.AnalysisParameters;
import peridot.GUI.component.CheckBox;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GeneIdType;
import peridot.Global;
import peridot.Log;
import peridot.Organism;

public class ParametersPanel
extends Panel {
    AnalysisParameters params;
    Map<String, JPanel> paramPanels;
    Map<String, JCheckBox> paramCheckboxes;
    Map<String, JLabel> paramLabels;
    Map<String, JComponent> paramFields;
    Map<String, Object> defaultValues = AnalysisParameters.getDefaultValues();
    private boolean defaultValueButtons;

    public ParametersPanel(boolean defaultValueButtons) {
        this.paramPanels = new HashMap<String, JPanel>();
        this.paramCheckboxes = new HashMap<String, JCheckBox>();
        this.paramLabels = new HashMap<String, JLabel>();
        this.paramFields = new HashMap<String, JComponent>();
        this.params = new AnalysisParameters();
        this.defaultValueButtons = defaultValueButtons;
    }

    public ParametersPanel(AnalysisParameters initialValues, boolean defaultValueButtons) {
        this.paramPanels = new HashMap<String, JPanel>();
        this.paramCheckboxes = new HashMap<String, JCheckBox>();
        this.paramLabels = new HashMap<String, JLabel>();
        this.paramFields = new HashMap<String, JComponent>();
        this.params = new AnalysisParameters();
        this.defaultValueButtons = defaultValueButtons;
        this.setParams(initialValues);
    }

    public void setParams(AnalysisParameters initialValues) {
        if (initialValues != null) {
            this.params = initialValues;
        }
        this.customInitComponents();
        for (Map.Entry<String, JCheckBox> pair : this.paramCheckboxes.entrySet()) {
            pair.getValue().doClick();
        }
        if (initialValues == null) {
            for (Map.Entry<String, JCheckBox> pair : this.paramCheckboxes.entrySet()) {
                pair.getValue().doClick();
            }
        } else {
            for (Map.Entry<String, JCheckBox> pair : this.paramCheckboxes.entrySet()) {
                if (!initialValues.parameters.containsKey(pair.getKey())) continue;
                pair.getValue().doClick();
            }
        }
        if (!this.defaultValueButtons) {
            this.removeCheckboxes();
        }
    }

    public boolean fieldIsDefault(String name) {
        return this.paramCheckboxes.containsKey(name) && this.paramCheckboxes.get(name).isSelected();
    }

    public AnalysisParameters getParameters() {
        AnalysisParameters values = new AnalysisParameters(this.params.requiredParameters);
        for (Map.Entry<String, Class> pair : this.params.requiredParameters.entrySet()) {
            Float floatValue;
            Object fieldValue;
            if (this.fieldIsDefault(pair.getKey())) continue;
            JComponent inputField = this.paramFields.get(pair.getKey());
            if (inputField instanceof JSpinner) {
                JSpinner spinner = (JSpinner)inputField;
                fieldValue = spinner.getModel().getValue();
                if (pair.getValue() == Float.class) {
                    if (fieldValue instanceof Float) {
                        values.passParameter(pair.getKey(), (Float)fieldValue);
                        continue;
                    }
                    if (!(fieldValue instanceof String)) continue;
                    floatValue = null;
                    try {
                        floatValue = Float.valueOf(Float.parseFloat((String)fieldValue));
                    }
                    catch (Exception ex) {
                        floatValue = new Float(0.0f);
                    }
                    values.passParameter(pair.getKey(), floatValue);
                    continue;
                }
                if (pair.getValue() != Integer.class) continue;
                if (fieldValue instanceof Integer) {
                    values.passParameter(pair.getKey(), (Integer)fieldValue);
                    continue;
                }
                if (!(fieldValue instanceof String)) continue;
                Integer intValue = null;
                try {
                    intValue = Integer.parseInt((String)fieldValue);
                }
                catch (Exception ex) {
                    intValue = new Integer(0);
                }
                values.passParameter(pair.getKey(), intValue);
                continue;
            }
            if (inputField instanceof JComboBox) {
                Object selectedValue;
                JComboBox comboBox = (JComboBox)inputField;
                if (pair.getValue() == GeneIdType.class) {
                    selectedValue = (GeneIdType)comboBox.getSelectedItem();
                    if (values.passParameter(pair.getKey(), selectedValue)) continue;
                    Log.logger.info("could not pass: " + pair.getKey() + " -> " + selectedValue);
                    continue;
                }
                if (pair.getValue() == Organism.class) {
                    selectedValue = (Organism)comboBox.getSelectedItem();
                    if (values.passParameter(pair.getKey(), selectedValue)) continue;
                    Log.logger.info("could not pass: " + pair.getKey() + " -> " + selectedValue);
                    continue;
                }
                if (pair.getValue() != Float.class) continue;
                fieldValue = comboBox.getSelectedItem();
                if (fieldValue instanceof Float) {
                    values.passParameter(pair.getKey(), (Float)fieldValue);
                    continue;
                }
                if (!(fieldValue instanceof String)) continue;
                floatValue = null;
                try {
                    floatValue = Float.valueOf(Float.parseFloat((String)fieldValue));
                }
                catch (Exception ex) {
                    floatValue = new Float(0.0f);
                }
                values.passParameter(pair.getKey(), floatValue);
                continue;
            }
            Log.logger.info("unidentified field");
        }
        return values;
    }

    public void removeCheckboxes() {
        LinkedList<String> toremove = new LinkedList<String>();
        for (Map.Entry<String, JCheckBox> pair : this.paramCheckboxes.entrySet()) {
            if (pair.getValue().isSelected()) {
                pair.getValue().doClick();
            }
            toremove.add(pair.getKey());
            this.paramPanels.get(pair.getKey()).remove(pair.getValue());
        }
        for (String name : toremove) {
            this.paramCheckboxes.remove(name);
        }
    }

    private SpinnerModel getModel(Class type, String name, Object value) {
        AbstractSpinnerModel model = null;
        if (type == Float.class) {
            Float defaultValue;
            model = value == null ? (this.defaultValues.containsKey(name) ? ((defaultValue = (Float)this.defaultValues.get(name)).equals(new Float(0.0f)) ? this.getSpinnerNotUseOrFloatModel() : new SpinnerNumberModel(Float.valueOf(defaultValue.floatValue()), Float.valueOf(0.0f), null, Float.valueOf(0.1f))) : new SpinnerNumberModel(Float.valueOf(0.01f), Float.valueOf(0.0f), null, Float.valueOf(0.1f))) : (value.equals(new Float(0.0f)) ? this.getSpinnerNotUseOrFloatModel() : new SpinnerNumberModel(Float.valueOf(((Float)value).floatValue()), Float.valueOf(0.0f), null, Float.valueOf(0.01f)));
        } else if (type == Integer.class) {
            Integer defaultValue;
            model = value == null ? (this.defaultValues.containsKey(name) ? ((defaultValue = (Integer)this.defaultValues.get(name)).equals(new Integer(0)) ? this.getSpinnerNotUseOrIntModel() : new SpinnerNumberModel(defaultValue, Integer.valueOf(0), null, (Number)1)) : this.getSpinnerNotUseOrIntModel()) : (value.equals(new Integer(0)) ? this.getSpinnerNotUseOrIntModel() : new SpinnerNumberModel((Integer)value, Integer.valueOf(0), null, (Number)1));
        }
        return model;
    }

    private void customInitComponents() {
        for (Map.Entry<String, Class> pair : this.params.requiredParameters.entrySet()) {
            JComponent field;
            JComboBox<Object> comboBox;
            Panel panel = new Panel();
            Label label = new Label();
            final CheckBox checkbox = new CheckBox();
            label.setText(Global.getNaturallyWritenString(pair.getKey()));
            if (pair.getKey().equals("pValue") || pair.getKey().equals("fdr")) {
                comboBox = new JComboBox<Object>();
                comboBox.addItem("0.01");
                comboBox.addItem("0.05");
                comboBox.addItem("not-use");
                field = comboBox;
            } else if (pair.getValue() == Integer.class || pair.getValue() == Float.class) {
                final JSpinner spinner = new JSpinner();
                spinner.setPreferredSize(new Dimension(90, 28));
                final Class type = pair.getValue();
                Object value = null;
                if (this.params.parameters.containsKey(pair.getKey())) {
                    value = this.params.parameters.get(pair.getKey());
                }
                spinner.setModel(this.getModel(type, pair.getKey(), value));
                spinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        if (type == Float.class) {
                            ParametersPanel.this.checkForNotUseFloat(spinner);
                        } else if (type == Integer.class) {
                            ParametersPanel.this.checkForNotUseInt(spinner);
                        }
                    }
                });
                field = spinner;
            } else if (pair.getValue() == GeneIdType.class) {
                comboBox = new JComboBox();
                for (String idType : GeneIdType.defaultIDTypes) {
                    comboBox.addItem(new GeneIdType(idType));
                }
                field = comboBox;
            } else if (pair.getValue() == Organism.class) {
                comboBox = new JComboBox();
                for (String idType : Organism.defaultDBs) {
                    comboBox.addItem(new Organism(idType));
                }
                field = comboBox;
            } else {
                field = null;
            }
            checkbox.setText("default:");
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (checkbox.isSelected()) {
                        field.setEnabled(false);
                    } else {
                        field.setEnabled(true);
                    }
                }
            });
            panel.add(checkbox);
            panel.add(label);
            panel.add(field);
            this.paramCheckboxes.put(pair.getKey(), checkbox);
            this.paramFields.put(pair.getKey(), field);
            this.paramLabels.put(pair.getKey(), label);
            this.paramPanels.put(pair.getKey(), panel);
            this.add(panel);
        }
    }

    private void checkForNotUseFloat(JSpinner Adjust) {
        if (Adjust.getValue().toString().contentEquals("0.001")) {
            Adjust.setModel(this.getSpinnerFloatModel());
        } else if (Adjust.getValue().toString().contentEquals("0.0")) {
            Adjust.setModel(this.getSpinnerNotUseOrFloatModel());
        }
    }

    private void checkForNotUseInt(JSpinner Adjust) {
        if (Adjust.getValue().toString().contentEquals("1")) {
            Adjust.setModel(this.getSpinnerIntModel());
        } else if (Adjust.getValue().toString().contentEquals("0")) {
            Adjust.setModel(this.getSpinnerNotUseOrIntModel());
        }
    }

    private SpinnerNumberModel getSpinnerIntModel() {
        return new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1);
    }

    private SpinnerNumberModel getSpinnerFloatModel() {
        return new SpinnerNumberModel(Float.valueOf(0.001f), Float.valueOf(0.0f), null, Float.valueOf(0.001f));
    }

    private SpinnerListModel getSpinnerNotUseOrFloatModel() {
        Object[] setDefault = new String[]{"Not Use", "0.001"};
        return new SpinnerListModel(setDefault);
    }

    private SpinnerListModel getSpinnerNotUseOrIntModel() {
        Object[] setDefault = new String[]{"Not Use", "1"};
        return new SpinnerListModel(setDefault);
    }
}

