/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import peridot.AnalysisData;
import peridot.AnalysisParameters;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.BiggerLabel;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.ScriptOutputDialog;
import peridot.GUI.panel.ScriptProgressMonitorPanel;
import peridot.Log;
import peridot.script.AnalysisModule;
import peridot.script.ScriptExec;
import peridot.script.Task;

public class ProcessingPanel
extends Panel {
    public ImageIcon failIcon = Resources.getImageIcon(this.getClass(), "Delete-icon-24.png");
    public ImageIcon failIconBig = Resources.getImageIcon(this.getClass(), "Delete-icon-32.png");
    public ImageIcon clearIcon = Resources.getImageIcon(this.getClass(), "Clear-Green-Button-icon24.png");
    public ImageIcon clearIconBig = Resources.getImageIcon(this.getClass(), "Clear-Green-Button-icon32.png");
    public ImageIcon stopIcon = Resources.getImageIcon(this.getClass(), "Stop-icon24.png");
    public ImageIcon stopAllIconBig = Resources.getImageIcon(this.getClass(), "Stop-All-icon32.png");
    public ImageIcon loaderIcon = Resources.getImageIcon(this.getClass(), "loading40.gif");
    JFrame parent;
    private static ProcessingPanel _instance;
    private ConcurrentHashMap<String, ScriptOutputDialog> outputDialogs;
    Set<String> scripts;
    private ConcurrentHashMap<String, ScriptProgressMonitorPanel> scriptMonitor;
    protected Thread scriptsStatusWatcher;
    public Runnable statusWatcher;
    public AtomicBoolean isProcessing = new AtomicBoolean(false);
    public Task task = null;
    private JLabel finalResultDescription;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JScrollPane otherResultsScroller;
    private JLabel othersLabel;
    private JPanel packagesBarsPanel;
    private JLabel packagesLabel;
    private JScrollPane packagesScroller;
    private JPanel scriptsBarsPanel;
    String noGenesFoundStr = "Warning: This Analysis Module did not found genes on the given data.";

    public ProcessingPanel(JFrame parent) {
        this.parent = parent;
        this.customInit();
        _instance = this;
    }

    public static void start(Set<String> scriptsToExec, AnalysisParameters params, Map<String, AnalysisParameters> specificParams, AnalysisData expression) {
        if (_instance == null) {
            return;
        }
        _instance.process(scriptsToExec, params, specificParams, expression);
    }

    public static void cleanMonitorPanels() {
        if (_instance == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            ProcessingPanel._instance.packagesBarsPanel.removeAll();
            ProcessingPanel._instance.scriptsBarsPanel.removeAll();
        });
    }

    public static void preparePanelToStart() {
        if (_instance == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            ProcessingPanel._instance.packagesBarsPanel.revalidate();
            ProcessingPanel._instance.packagesBarsPanel.repaint();
            ProcessingPanel._instance.scriptsBarsPanel.revalidate();
            ProcessingPanel._instance.scriptsBarsPanel.repaint();
            ProcessingPanel._instance.finalResultDescription.setIcon(ProcessingPanel._instance.loaderIcon);
            ProcessingPanel._instance.finalResultDescription.setText("Processing");
        });
    }

    public void process(Set<String> scriptsToExec, AnalysisParameters params, Map<String, AnalysisParameters> specificParams, AnalysisData expression) {
        MainGUI.goToProcessingPanel();
        this.scripts = new HashSet<String>();
        this.outputDialogs = new ConcurrentHashMap();
        this.scriptMonitor = new ConcurrentHashMap();
        this.task = new Task(scriptsToExec, params, specificParams, expression);
        this.scriptMonitor = new ConcurrentHashMap();
        ProcessingPanel.cleanMonitorPanels();
        this.isProcessing.set(true);
        this.task.start();
        MainGUI.updateResultsPanel();
        for (Map.Entry<String, ScriptExec> pair : this.task.scriptExecs.entrySet()) {
            ScriptOutputDialog outputDialog = new ScriptOutputDialog((Frame)this.parent, false, pair.getKey(), pair.getValue().output);
            ScriptProgressMonitorPanel monitorPanel = new ScriptProgressMonitorPanel(pair.getValue(), outputDialog);
            this.outputDialogs.put(pair.getKey(), outputDialog);
            this.scripts.add(pair.getKey());
            this.addScriptMonitor(pair.getKey(), monitorPanel, pair.getValue());
        }
        ProcessingPanel.preparePanelToStart();
        this.scriptsStatusWatcher = new Thread(() -> this.watchForUpdatesOnTask());
        this.scriptsStatusWatcher.start();
    }

    public static boolean isProcessing() {
        return ProcessingPanel._instance.isProcessing.get();
    }

    public void watchForUpdatesOnTask() {
        while (this.task.isProcessing() || this.task.isNotStarted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                break;
            }
            if (!this.task.isProcessing()) continue;
            this.updateMonitorState();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.updateMonitorState();
        this.allFinished();
        this.isProcessing.set(false);
    }

    private void updateMonitorState() {
        for (Map.Entry<String, ScriptExec> pair : this.task.scriptExecs.entrySet()) {
            Task.WaitState waitState = this.task.waitState.get(pair.getKey());
            ScriptProgressMonitorPanel panel = this.scriptMonitor.get(pair.getKey());
            if (panel == null) continue;
            if (waitState.equals((Object)Task.WaitState.WAITING) || waitState.equals((Object)Task.WaitState.READY)) {
                panel.switchToWaitingIcon();
                continue;
            }
            if (waitState.equals((Object)Task.WaitState.PRE_FAILED)) {
                panel.switchToFailIcon();
                continue;
            }
            if (this.task.successfulScripts.contains(pair.getKey())) {
                panel.switchToSuccessIcon();
                continue;
            }
            if (this.task.failedScripts.contains(pair.getKey())) {
                panel.switchToFailIcon();
                continue;
            }
            panel.switchToStopIcon();
        }
    }

    private void allFinished() {
        if (this.task.isFailed()) {
            this.finalResultDescription.setIcon(this.failIcon);
            this.finalResultDescription.setText("Failed");
        } else if (this.task.isSomeFailed()) {
            this.finalResultDescription.setIcon(this.failIcon);
            this.finalResultDescription.setText("Some failed");
        } else if (this.task.isSuccess()) {
            this.finalResultDescription.setIcon(this.clearIcon);
            this.finalResultDescription.setText("Success");
        }
        SwingUtilities.invokeLater(() -> {
            Log.logger.info("Updating resultsPanel now");
            MainGUI.updateResultsPanel();
            Log.logger.info("Switching to resultsPanel now");
            MainGUI.goToResultsPanel();
        });
        for (Map.Entry<String, ScriptOutputDialog> pair : this.outputDialogs.entrySet()) {
            pair.getValue().stopFlag.set(false);
        }
    }

    public void addScriptMonitor(String name, ScriptProgressMonitorPanel watcher, ScriptExec exec) {
        SwingUtilities.invokeLater(() -> {
            JPanel outerPanel = exec.script instanceof AnalysisModule ? this.packagesBarsPanel : this.scriptsBarsPanel;
            outerPanel.add(watcher);
            outerPanel.revalidate();
            outerPanel.repaint();
        });
        this.scriptMonitor.put(name, watcher);
    }

    private void customInit() {
        this.setMinimumSize(new Dimension(546, 495));
        this.setPreferredSize(MainGUI.defaultSize);
        this.setLayout(new FlowLayout(1, 13, 6));
        Dimension scriptPanelSize = new Dimension(250, MainGUI.defaultSize.height - 70);
        Dimension innerScriptPanelSize = new Dimension(scriptPanelSize.width - 5, scriptPanelSize.height - 36);
        Panel leftPanel = new Panel();
        leftPanel.setPreferredSize(scriptPanelSize);
        this.packagesLabel = new BiggerLabel();
        this.packagesLabel.setText("Analysis Modules:");
        this.packagesBarsPanel = new Panel();
        this.packagesBarsPanel.setMaximumSize(new Dimension(470, 3000));
        this.packagesBarsPanel.setLayout(new BoxLayout(this.packagesBarsPanel, 3));
        this.packagesScroller = new JScrollPane(this.packagesBarsPanel);
        this.packagesScroller.setPreferredSize(innerScriptPanelSize);
        leftPanel.add(this.packagesLabel);
        leftPanel.add(this.packagesScroller);
        this.jSeparator1 = new JSeparator();
        this.jSeparator1.setPreferredSize(new Dimension(2, innerScriptPanelSize.height));
        this.jSeparator1.setOrientation(1);
        Panel rightPanel = new Panel();
        rightPanel.setPreferredSize(scriptPanelSize);
        this.othersLabel = new BiggerLabel();
        this.othersLabel.setText("Post Analysis Modules:");
        this.scriptsBarsPanel = new Panel();
        this.scriptsBarsPanel.setMaximumSize(new Dimension(470, 3000));
        this.scriptsBarsPanel.setLayout(new BoxLayout(this.scriptsBarsPanel, 3));
        this.otherResultsScroller = new JScrollPane(this.scriptsBarsPanel);
        this.otherResultsScroller.setPreferredSize(innerScriptPanelSize);
        rightPanel.add(this.othersLabel);
        rightPanel.add(this.otherResultsScroller);
        this.jSeparator2 = new JSeparator();
        this.jSeparator2.setPreferredSize(new Dimension(500, 2));
        this.finalResultDescription = new BigLabel();
        this.finalResultDescription.setHorizontalAlignment(0);
        this.finalResultDescription.setText("No analysis running");
        this.finalResultDescription.setPreferredSize(new Dimension(200, 45));
        this.add(leftPanel);
        this.add(this.jSeparator1);
        this.add(rightPanel);
        this.add(this.jSeparator2);
        this.add(this.finalResultDescription);
    }
}

