/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import peridot.Archiver.Places;
import peridot.GUI.MainGUI;
import peridot.GUI.Resources;
import peridot.GUI.WrapLayout;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.BiggerLabel;
import peridot.GUI.component.Button;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.PackagesResultsDialog;
import peridot.GUI.dialog.ScriptResultsDialog;
import peridot.Log;
import peridot.Operations;
import peridot.script.RModule;

public class ResultsPanel
extends Panel {
    JFrame parent;
    private HashMap<String, File> analysisModules;
    private HashMap<String, File> postAnalysisModules = new HashMap();
    private File vennDiagramDir = null;
    private JPanel bottomPanel;
    private JSeparator bottomSeparator;
    private JPanel innerUpperPanel;
    private JPanel middlePanel;
    private JButton openSaveFolderFileChooser;
    private JPanel packListArea;
    private JPanel postAnalysisPanel;
    private JTextField saveFolderInputField;
    private JLabel saveInLabel;
    private JButton saveResultsButton;
    private JLabel successfulOthersLabel;
    private JLabel topLabel;
    private JSeparator topSeparator;
    private JPanel upperPanel;
    private JButton viewResultsButton;
    private JPanel consensusPanel;
    private JPanel individualPanel;
    private Dimension smallButtonSize;

    public ResultsPanel(JFrame parent) {
        this.analysisModules = new HashMap();
        this.parent = parent;
        this.customInit();
        this.updateData();
    }

    private void updateAvailableResults() {
        Set<File> scriptResultsFolders = this.getScriptResultsFolders();
        this.updatePostAnalysisModules(scriptResultsFolders);
        this.updateAnalysisModules(scriptResultsFolders);
    }

    private void updatePostAnalysisModules(Set<File> scriptResultsFolders) {
        this.vennDiagramDir = null;
        for (String scriptName : RModule.getAvailablePostAnalysisModules()) {
            File dir = null;
            for (File scriptDir : scriptResultsFolders) {
                if (!scriptDir.getName().contains(".PostAnalysisModule") || !scriptDir.getName().contains(scriptName)) continue;
                dir = scriptDir;
                break;
            }
            if (dir == null) continue;
            if (scriptName.equals("VennDiagram")) {
                this.vennDiagramDir = dir;
                ScriptResultsDialog.fillCountPlots(this.vennDiagramDir);
                continue;
            }
            this.postAnalysisModules.put(scriptName, dir);
        }
    }

    private void updateAnalysisModules(Set<File> scriptResultsFolders) {
        for (String packName : RModule.getAvailableAnalysisModules()) {
            File dir = null;
            for (File packDir : scriptResultsFolders) {
                if (!packDir.getName().contains(packName + ".AnalysisModule")) continue;
                dir = packDir;
                break;
            }
            if (dir == null) continue;
            this.analysisModules.put(packName, dir);
        }
    }

    public void updateData() {
        this.analysisModules.clear();
        this.postAnalysisModules.clear();
        this.updateAvailableResults();
        this.updateUpperPanel();
        this.updatePostAnalysisButtons();
    }

    private void updateUpperPanel() {
        this.viewResultsButton.setEnabled(this.vennDiagramDir != null);
        this.individualPanel.removeAll();
        if (this.analysisModules.isEmpty()) {
            this.individualPanel.add(new BigLabel("None"));
        } else {
            this.individualPanel.add(new BigLabel("Individual Packages:"));
            for (Map.Entry<String, File> entry : this.analysisModules.entrySet()) {
                Button newButton = new Button();
                newButton.setText(entry.getKey());
                newButton.addActionListener(evt -> new ScriptResultsDialog((Frame)this.parent, false, (String)entry.getKey(), (File)entry.getValue()).setVisible(true));
                newButton.setPreferredSize(this.smallButtonSize);
                this.individualPanel.add(newButton);
            }
        }
    }

    private void updatePackListArea() {
        this.packListArea.removeAll();
        if (this.analysisModules.isEmpty()) {
            this.packListArea.add(new Label("None"));
        } else {
            String[] packNames = this.analysisModules.keySet().toArray(new String[0]);
            for (int i = 0; i < packNames.length - 1; ++i) {
                this.packListArea.add(new Label(packNames[i] + ","));
            }
            this.packListArea.add(new Label(packNames[packNames.length - 1] + "."));
        }
    }

    private void updatePostAnalysisButtons() {
        this.postAnalysisPanel.removeAll();
        if (this.postAnalysisModules.isEmpty()) {
            BigButton button = new BigButton();
            button.setText("No post analysis available");
            button.setPreferredSize(new Dimension(400, 40));
            button.setEnabled(false);
            this.postAnalysisPanel.add(button);
        } else {
            for (Map.Entry<String, File> pair : this.postAnalysisModules.entrySet()) {
                BigButton button = new BigButton();
                button.setText(pair.getKey());
                button.addActionListener(evt -> new ScriptResultsDialog((Frame)this.parent, false, (String)pair.getKey(), (File)pair.getValue()).setVisible(true));
                button.setPreferredSize(new Dimension(400, 40));
                button.setIcon(Resources.getImageIcon(this.getClass(), "Document-icon-32.png"));
                this.postAnalysisPanel.add(button);
            }
        }
    }

    private Set<File> getScriptResultsFolders() {
        TreeSet<File> subDirs = new TreeSet<File>();
        TreeSet<File> subFiles = new TreeSet<File>(FileUtils.listFilesAndDirs(Places.finalResultsDir, TrueFileFilter.TRUE, TrueFileFilter.TRUE));
        for (File file : subFiles) {
            String filePath = file.getAbsolutePath();
            if (filePath.equals(Places.finalResultsDir.getAbsolutePath()) || !file.getAbsolutePath().contains(".AnalysisModule") && !file.getAbsolutePath().contains(".PostAnalysisModule") || !file.isDirectory()) continue;
            subDirs.add(file);
        }
        return subDirs;
    }

    private void customInit() {
        this.setMinimumSize(new Dimension(546, 495));
        this.setPreferredSize(MainGUI.defaultSize);
        this.makeNewUpperPanel();
        this.makeMiddlePanel();
        this.makeBottomPanel();
    }

    private void makeNewUpperPanel() {
        Dimension size = new Dimension(546, 160);
        Dimension innerSize = new Dimension(size.width, size.height - 32);
        Dimension subSize = new Dimension(160, innerSize.height);
        this.smallButtonSize = new Dimension((subSize.width - 5) / 2, 30);
        this.upperPanel = new Panel();
        this.upperPanel.setPreferredSize(size);
        this.upperPanel.setLayout(new WrapLayout(1, 5, 5));
        this.topLabel = new BiggerLabel();
        this.topLabel.setText("Differential Expression:");
        this.upperPanel.add(this.topLabel);
        Panel innerPanel = new Panel();
        innerPanel.setPreferredSize(innerSize);
        innerPanel.setLayout(new WrapLayout(1, 5, 0));
        this.viewResultsButton = new BigButton();
        this.viewResultsButton.setText("Consensus");
        this.viewResultsButton.setPreferredSize(subSize);
        this.viewResultsButton.setMinimumSize(subSize);
        this.viewResultsButton.addActionListener(evt -> {
            if (this.vennDiagramDir != null) {
                new ScriptResultsDialog((Frame)this.parent, false, "VennDiagram", this.vennDiagramDir).setVisible(true);
            }
        });
        this.viewResultsButton.setIcon(Resources.getImageIcon(this.getClass(), "Clear-Green-Button-icon32.png"));
        innerPanel.add(this.viewResultsButton);
        JSeparator middleSeparator = new JSeparator(1);
        middleSeparator.setPreferredSize(new Dimension(3, 90));
        innerPanel.add(middleSeparator);
        this.individualPanel = new Panel();
        this.individualPanel.setPreferredSize(new Dimension(subSize.width, subSize.height));
        this.individualPanel.setLayout(new WrapLayout(1, 3, 3));
        innerPanel.add(this.individualPanel);
        this.upperPanel.add(innerPanel);
        this.topSeparator = new JSeparator();
        this.topSeparator.setPreferredSize(new Dimension(520, 3));
        this.add(this.upperPanel);
        this.add(this.topSeparator);
    }

    private void makeUpperPanel() {
        this.upperPanel = new Panel();
        this.upperPanel.setPreferredSize(new Dimension(546, 140));
        this.upperPanel.setLayout(new FlowLayout(1, 0, 0));
        this.topLabel = new BiggerLabel();
        this.topLabel.setText("Differential Expression:");
        this.viewResultsButton = new BigButton();
        this.viewResultsButton.setText("View All");
        this.viewResultsButton.setPreferredSize(new Dimension(190, 120));
        this.viewResultsButton.setMinimumSize(new Dimension(190, 120));
        this.viewResultsButton.addActionListener(evt -> this.viewResultsButtonActionPerformed(evt));
        this.viewResultsButton.setIcon(Resources.getImageIcon(this.getClass(), "many-documents-32.png"));
        this.packListArea = new Panel();
        this.packListArea.setPreferredSize(new Dimension(140, 80));
        this.packListArea.setLayout(new WrapLayout());
        this.innerUpperPanel = new Panel();
        GroupLayout innerUpperPanelLayout = new GroupLayout(this.innerUpperPanel);
        this.innerUpperPanel.setLayout(innerUpperPanelLayout);
        innerUpperPanelLayout.setHorizontalGroup(innerUpperPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 354, Short.MAX_VALUE).addGroup(innerUpperPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerUpperPanelLayout.createSequentialGroup().addContainerGap().addGroup(innerUpperPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.topLabel, -1, -1, Short.MAX_VALUE).addComponent(this.packListArea, -2, 156, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewResultsButton, -2, 130, -2).addContainerGap(-1, Short.MAX_VALUE))));
        innerUpperPanelLayout.setVerticalGroup(innerUpperPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 131, Short.MAX_VALUE).addGroup(innerUpperPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerUpperPanelLayout.createSequentialGroup().addContainerGap().addGroup(innerUpperPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(innerUpperPanelLayout.createSequentialGroup().addComponent(this.topLabel, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.packListArea, -2, 0, Short.MAX_VALUE)).addComponent(this.viewResultsButton, -2, 107, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        this.topSeparator = new JSeparator();
        this.topSeparator.setPreferredSize(new Dimension(520, 2));
        this.upperPanel.add(this.innerUpperPanel);
        this.upperPanel.add(this.topSeparator);
        this.add(this.upperPanel);
    }

    private void makeMiddlePanel() {
        this.middlePanel = new Panel();
        this.middlePanel.setPreferredSize(new Dimension(546, 330));
        this.successfulOthersLabel = new BigLabel();
        this.successfulOthersLabel.setHorizontalAlignment(0);
        this.successfulOthersLabel.setText("Post Analysis:");
        this.postAnalysisPanel = new Panel();
        this.postAnalysisPanel.setPreferredSize(new Dimension(545, 270));
        this.middlePanel.add(this.successfulOthersLabel);
        this.middlePanel.add(this.postAnalysisPanel);
        this.add(this.middlePanel);
    }

    private void makeBottomPanel() {
        this.bottomPanel = new Panel();
        this.bottomPanel.setPreferredSize(new Dimension(546, 80));
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.bottomSeparator = new JSeparator();
        this.bottomSeparator.setPreferredSize(new Dimension(540, 2));
        this.saveInLabel = new Label();
        this.saveInLabel.setText("Save in:");
        this.saveFolderInputField = new JTextField();
        this.saveFolderInputField.setMinimumSize(new Dimension(40, 25));
        this.saveFolderInputField.setPreferredSize(new Dimension(380, 25));
        this.saveFolderInputField.setEditable(false);
        this.openSaveFolderFileChooser = new Button();
        this.openSaveFolderFileChooser.setText("");
        this.openSaveFolderFileChooser.setPreferredSize(new Dimension(90, 30));
        this.openSaveFolderFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResultsPanel.this.openSaveFolderFileChooserActionPerformed(evt);
            }
        });
        this.openSaveFolderFileChooser.setIcon(Resources.getImageIcon(this.getClass(), "open-icon-24.png"));
        this.saveResultsButton = new Button();
        this.saveResultsButton.setText("Save");
        this.saveResultsButton.setPreferredSize(new Dimension(90, 30));
        this.saveResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResultsPanel.this.saveResultsButtonActionPerformed(evt);
            }
        });
        this.saveResultsButton.setIcon(Resources.getImageIcon(this.getClass(), "save-icon-24.png"));
        this.saveResultsButton.setEnabled(false);
        this.bottomPanel.add(this.bottomSeparator);
        this.bottomPanel.add(this.saveInLabel);
        this.bottomPanel.add(this.saveFolderInputField);
        this.bottomPanel.add(this.openSaveFolderFileChooser);
        this.bottomPanel.add(this.saveResultsButton);
        this.add(this.bottomPanel);
    }

    private void openSaveFolderFileChooserActionPerformed(ActionEvent evt) {
        File folder;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(this.parent);
        if (result == 0 && (folder = fileChooser.getSelectedFile()).exists()) {
            this.saveFolderInputField.setText(folder.getAbsolutePath());
            this.saveResultsButton.setEnabled(true);
        }
    }

    private void viewResultsButtonActionPerformed(ActionEvent evt) {
        new PackagesResultsDialog((Frame)this.parent, false, this.analysisModules).setVisible(true);
    }

    private void saveResultsButtonActionPerformed(ActionEvent evt) {
        try {
            File saveFolder = new File(this.saveFolderInputField.getText());
            Operations.saveResultsAt(saveFolder);
        }
        catch (Exception ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

