/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.Dimension;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import peridot.GUI.Resources;
import peridot.GUI.component.BigLabel;
import peridot.GUI.component.Button;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.dialog.ScriptOutputDialog;
import peridot.script.ScriptExec;

public class ScriptProgressMonitorPanel
extends Panel {
    private static ImageIcon failIcon = Resources.getImageIcon(ScriptProgressMonitorPanel.class, "Delete-icon-24.png");
    private static ImageIcon clearIcon = Resources.getImageIcon(ScriptProgressMonitorPanel.class, "Clear-Green-Button-icon24.png");
    private static ImageIcon stopIcon = Resources.getImageIcon(ScriptProgressMonitorPanel.class, "Stop-icon24.png");
    private static ImageIcon consoleIcon = Resources.getImageIcon(ScriptProgressMonitorPanel.class, "Terminal-icon-32.png");
    private static ImageIcon waitingIcon = Resources.getImageIcon(ScriptProgressMonitorPanel.class, "waiting32.gif");
    private JLabel nameLabel;
    private JLabel successLabel;
    private JLabel waitingLabel;
    private JLabel failLabel;
    public JButton stopButton;
    public JButton outputButton;
    private AtomicBoolean stoppable;
    private ScriptExec scriptExec;
    private IconState iconState;
    private ScriptOutputDialog outputDialog;

    public ScriptProgressMonitorPanel(ScriptExec scriptExec, ScriptOutputDialog outputDialog) {
        this.outputDialog = outputDialog;
        this.iconState = IconState.NONE;
        this.scriptExec = scriptExec;
        this.stoppable = new AtomicBoolean();
        this.stoppable.set(false);
        this.setPreferredSize(new Dimension(228, 50));
        this.nameLabel = new BigLabel();
        this.nameLabel.setText(scriptExec.getName());
        this.stopButton = new Button();
        this.stopButton.addActionListener(evt -> this.requireToAbort());
        this.stopButton.setIcon(stopIcon);
        this.stopButton.setText("");
        this.failLabel = new Label();
        this.failLabel.setText("");
        this.failLabel.setIcon(failIcon);
        this.waitingLabel = new Label();
        this.waitingLabel.setText("");
        this.waitingLabel.setIcon(waitingIcon);
        this.successLabel = new Label();
        this.successLabel.setText("");
        this.successLabel.setIcon(clearIcon);
        this.outputButton = new Button();
        this.outputButton.setIcon(consoleIcon);
        this.outputButton.addActionListener(evt -> this.showScriptOutputDialog());
        this.setStoppable(false);
        this.add(this.nameLabel);
        this.add(this.waitingLabel);
        this.add(this.outputButton);
    }

    public void switchToWaitingIcon() {
        if (this.iconState == IconState.WAITING) {
            return;
        }
        this.iconState = IconState.WAITING;
        this.setStoppable(false);
        SwingUtilities.invokeLater(() -> {
            this.remove(this.stopButton);
            this.remove(this.failLabel);
            this.remove(this.successLabel);
            this.remove(this.outputButton);
            this.add(this.waitingLabel);
            this.add(this.outputButton);
            this.revalidate();
            this.repaint();
        });
    }

    public void switchToStopIcon() {
        if (this.iconState == IconState.STOP) {
            return;
        }
        this.iconState = IconState.STOP;
        this.setStoppable(true);
        SwingUtilities.invokeLater(() -> {
            this.remove(this.successLabel);
            this.remove(this.failLabel);
            this.remove(this.waitingLabel);
            this.remove(this.outputButton);
            this.stopButton.setEnabled(true);
            this.stoppable.set(true);
            this.add(this.stopButton);
            this.add(this.outputButton);
            this.revalidate();
            this.repaint();
        });
    }

    public void switchToSuccessIcon() {
        if (this.iconState == IconState.SUCCESS) {
            return;
        }
        this.iconState = IconState.SUCCESS;
        this.setStoppable(false);
        SwingUtilities.invokeLater(() -> {
            this.remove(this.stopButton);
            this.remove(this.failLabel);
            this.remove(this.waitingLabel);
            this.remove(this.outputButton);
            this.add(this.successLabel);
            this.add(this.outputButton);
            this.revalidate();
            this.repaint();
        });
    }

    public void switchToFailIcon() {
        if (this.iconState == IconState.FAIL) {
            return;
        }
        this.iconState = IconState.FAIL;
        this.setStoppable(false);
        SwingUtilities.invokeLater(() -> {
            this.remove(this.stopButton);
            this.remove(this.successLabel);
            this.remove(this.waitingLabel);
            this.remove(this.outputButton);
            this.add(this.failLabel);
            this.add(this.outputButton);
            this.revalidate();
            this.repaint();
        });
    }

    private void setStoppable(boolean stoppable) {
        SwingUtilities.invokeLater(() -> this.stopButton.setEnabled(stoppable));
        this.stoppable.set(stoppable);
    }

    public void requireToAbort() {
        if (this.stoppable.get()) {
            this.scriptExec.abort();
        } else {
            this.scriptExec.output.appendLine("Cannot abort");
        }
    }

    private void showScriptOutputDialog() {
        SwingUtilities.invokeLater(() -> this.outputDialog.setVisible(true));
    }

    private static enum IconState {
        NONE,
        WAITING,
        STOP,
        SUCCESS,
        FAIL;

    }
}

