/*
 * Decompiled with CFR 0.152.
 */
package peridot.GUI.panel;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import peridot.Archiver.Manager;
import peridot.Archiver.Spreadsheet;
import peridot.GUI.JTableUtils;
import peridot.GUI.Resources;
import peridot.GUI.component.BigButton;
import peridot.GUI.component.BiggerLabel;
import peridot.GUI.component.Label;
import peridot.GUI.component.Panel;
import peridot.GUI.component.TabbedPane;
import peridot.Global;
import peridot.Log;
import peridot.script.RModule;

public class ViewResultsPanel
extends Panel {
    HashMap<String, JPanel> resultViewers;
    String scriptName;
    File resultsDir;
    boolean analysisModule;
    private JTabbedPane tabsPanel;

    public ViewResultsPanel(String scriptName, File resultsDir, boolean analysisModule) {
        this.scriptName = scriptName;
        this.resultsDir = resultsDir;
        this.analysisModule = analysisModule;
        this.initComponents();
        this.resultViewers = new HashMap();
        RModule script = RModule.availableModules.get(scriptName);
        Set<String> allResults = script.results;
        if (script.mandatoryResults.size() > 0) {
            Object[] mandatoryResults = script.mandatoryResults.toArray(new String[script.mandatoryResults.size()]);
            Arrays.sort(mandatoryResults);
            for (int i = mandatoryResults.length - 1; i >= 0; --i) {
                this.addResultTab((String)mandatoryResults[i]);
            }
        }
        for (String result : allResults) {
            if (script.mandatoryResults.contains(result)) continue;
            this.addResultTab(result);
        }
    }

    private void addResultTab(String result) {
        JComponent content = null;
        File file = new File(this.resultsDir.getAbsolutePath() + File.separator + result);
        if (file.exists()) {
            boolean unknownFormat = false;
            if (Manager.isImageFile(result)) {
                content = Label.getImageLabel(file);
            } else if (Global.fileIsPlainText(file)) {
                try {
                    Spreadsheet spreadsheet = new Spreadsheet(file);
                    content = JTableUtils.getJTable(spreadsheet);
                }
                catch (IOException ex) {
                    Log.logger.warning("Could not open file " + file.getAbsolutePath());
                    ex.printStackTrace();
                }
                if (content == null) {
                    content = ViewResultsPanel.getEmptyTableMessage(this.analysisModule);
                }
            } else {
                content = ViewResultsPanel.getUnknownFormatMessage(file);
                unknownFormat = true;
            }
            JScrollPane scroller = new JScrollPane(content);
            scroller.getViewport().setBackground(Color.white);
            Panel panel = new Panel();
            panel.setLayout(new CardLayout());
            panel.add(scroller);
            this.resultViewers.put(result, panel);
            if (unknownFormat) {
                this.tabsPanel.add("Open " + result, panel);
            } else {
                this.tabsPanel.add(result, panel);
            }
        }
    }

    private static JPanel getUnknownFormatMessage(final File file) {
        Panel panel = new Panel();
        panel.setMaximumSize(new Dimension(300, 3000));
        panel.setLayout(new BoxLayout(panel, 3));
        BiggerLabel message = new BiggerLabel();
        message.setText(file.getName() + " is in a format unknown to R-Peridot.");
        BigButton openButton = new BigButton();
        openButton.setText("Open With External Program");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Global.openFileWithSysApp(file);
            }
        });
        openButton.setSize(new Dimension(120, 70));
        openButton.setIcon(Resources.getImageIcon(ViewResultsPanel.class, "Write-Document-icon16.png"));
        panel.add(message);
        panel.add(openButton);
        return panel;
    }

    private static JPanel getEmptyTableMessage(boolean analysisModule) {
        Panel panel = new Panel();
        panel.setMaximumSize(new Dimension(300, 3000));
        panel.setLayout(new BoxLayout(panel, 3));
        BiggerLabel message = new BiggerLabel();
        if (analysisModule) {
            message.setText("No differential expression found by this module.");
        } else {
            message.setText("Empty table or list.");
        }
        panel.add(message);
        return panel;
    }

    private void initComponents() {
        this.tabsPanel = new TabbedPane();
        this.setLayout(new CardLayout());
        this.add((Component)this.tabsPanel, "card2");
    }
}

