/*
 * Decompiled with CFR 0.152.
 */
package peridot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import peridot.Archiver.Places;
import peridot.Log;

public final class Global {
    private Global() {
        throw new AssertionError();
    }

    public static boolean stringIsLettersAndDigits(String s) {
        String text = s;
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void openFileWithSysApp(File file) {
        String cmd = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            cmd = "CMD /C START \"\" \"" + file.getAbsolutePath() + "\"";
        } else if (SystemUtils.IS_OS_LINUX) {
            cmd = "xdg-open " + file.getAbsolutePath();
        }
        try {
            Log.logger.info("Executing " + cmd);
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception ex) {
            Log.logger.severe("Could not open " + file.getName() + " with external program.");
            Log.logger.severe("Failed to: " + cmd);
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static boolean deletePeridotFolder() {
        try {
            FileHandler f = null;
            for (Handler h : Log.logger.getHandlers()) {
                if (h instanceof FileHandler) {
                    f = (FileHandler)h;
                }
                Log.logger.removeHandler(h);
            }
            f.close();
            new File(Places.peridotDir + File.separator + "log.txt").delete();
            FileUtils.deleteDirectory(Places.peridotDir);
            return true;
        }
        catch (IOException ex) {
            Log.logger.severe("Could not delete ~/r-peridot-files");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    public static void setTimeout(Runnable runnable, int delay) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                runnable.run();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }).start();
    }

    public static String noSpaces(String string) {
        string = string.replaceAll(" ", "_");
        return string;
    }

    public static String[] split(String line, String sep) {
        return Global.joinArgsBetweenQuotes(line.split(sep));
    }

    public static boolean wordIsGeneID(String word) {
        return word.equals("gene-id") || word.equals("gene_id") || word.equals("gene") || word.equals("gene id") || word.equals("id");
    }

    public static boolean wordIsMicroArrayID(String word) {
        return word.toLowerCase().equals("micro array") || word.toLowerCase().equals("micro_array") || word.toLowerCase().equals("micro") || word.toLowerCase().equals("micro-array") || word.toLowerCase().equals("array") || word.toLowerCase().equals("id");
    }

    public static boolean lineIsWords(String[] row) {
        int countWords = 0;
        for (int i = 0; i < row.length; ++i) {
            try {
                int n = Integer.parseInt(row[i]);
                continue;
            }
            catch (Exception ex) {
                try {
                    double d = Double.parseDouble(row[i]);
                    continue;
                }
                catch (Exception ex2) {
                    ++countWords;
                }
            }
        }
        return countWords >= 2;
    }

    public static boolean lineIsDoubles(String[] row) {
        int countDoubles = 0;
        for (int i = 0; i < row.length; ++i) {
            try {
                double value = Double.parseDouble(row[i]);
                if (value == Math.ceil(value) && value == Math.floor(value)) continue;
                ++countDoubles;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return countDoubles > 0;
    }

    public static String getNaturallyWritenString(String string) {
        String res = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                if (Character.isLowerCase(c)) {
                    c = Character.toUpperCase(c);
                }
            } else if (Character.isUpperCase(c) || c == '-') {
                res = res + " ";
            }
            if (c == '-') continue;
            res = res + c;
        }
        return res;
    }

    public static void printArray(int[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            s = s + "" + array[i];
            if (i == array.length - 1) continue;
            s = s + ", ";
        }
        Log.logger.info(s);
    }

    public static void printArray(String[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            s = s + array[i];
            if (i == array.length - 1) continue;
            s = s + ", ";
        }
        Log.logger.info(s);
    }

    public static String[] spliceBySpacesAndTabs(String text) {
        String[] spliced = text.split(" ");
        int total = 0;
        for (int i = 0; i < spliced.length; ++i) {
            total += spliced[i].split("\t").length;
        }
        String[] spliceTotal = new String[total];
        int lastJ = 0;
        for (int i = 0; i < spliced.length; ++i) {
            String[] spliceTemp = spliced[i].split("\t");
            for (int j = 0; j < spliceTemp.length; ++j) {
                spliceTotal[lastJ + j] = spliceTemp[j];
            }
            lastJ += spliceTemp.length;
        }
        ArrayList<String> notEmpty = new ArrayList<String>();
        for (int i = 0; i < spliceTotal.length; ++i) {
            if (spliceTotal[i].length() <= 0) continue;
            notEmpty.add(spliceTotal[i]);
        }
        String[] splice = notEmpty.toArray(new String[1]);
        return splice;
    }

    public static String[] firstWordAndTheRest(String text) {
        String[] array = new String[2];
        String[] spliced = Global.spliceBySpacesAndTabs(text);
        array[0] = spliced[0];
        if (spliced.length == 1) {
            array[1] = null;
        } else {
            array[1] = "";
            for (int i = 1; i < spliced.length; ++i) {
                array[1] = array[1] + " " + spliced[i];
            }
        }
        return array;
    }

    public static int roundFloat(float x, RoundingMode roundingMode) {
        if (roundingMode == RoundingMode.DOWN) {
            return (int)Math.floor(x);
        }
        if (roundingMode == RoundingMode.UP) {
            return (int)Math.ceil(x);
        }
        int naturalPart = new Double(Math.floor(x)).intValue();
        float fraction = x - (float)naturalPart;
        if ((double)fraction < 0.5) {
            return naturalPart;
        }
        if ((double)fraction > 0.5) {
            return naturalPart + 1;
        }
        if (roundingMode == RoundingMode.HALF_DOWN) {
            return naturalPart;
        }
        return naturalPart + 1;
    }

    public static void printRoundingTable() {
        String str = "x\tUP\tDOWN\tHALF_UP\tHALF_DOWN\n";
        float[] val = new float[]{0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 3.1f, 3.25f, 3.5f, 3.75f, 4.0f};
        for (int i = 0; i < val.length; ++i) {
            str = str + val[i] + "\t" + Global.roundFloat(val[i], RoundingMode.UP) + "\t" + Global.roundFloat(val[i], RoundingMode.DOWN) + "\t" + Global.roundFloat(val[i], RoundingMode.HALF_UP) + "\t" + Global.roundFloat(val[i], RoundingMode.HALF_DOWN) + "\n";
        }
        System.out.println(str);
    }

    public static String listOfWordsToLine(List<String> words) {
        String s = "";
        for (String str : words) {
            s = s + str + " ";
        }
        return s;
    }

    public static boolean endsWithQuotes(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == '\"';
    }

    public static boolean startsWithQuotes(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(0) == '\"';
    }

    public static String[] joinArgsBetweenQuotes(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            boolean starts = Global.startsWithQuotes(args[i]);
            if (starts) {
                arg = arg.length() > 1 ? arg.substring(1) : "";
                String newArg = "";
                while (!Global.endsWithQuotes(arg) && i < args.length) {
                    newArg = newArg + " " + arg;
                    arg = args[i];
                    ++i;
                }
                if (Global.endsWithQuotes(arg) && arg.length() > 1) {
                    newArg = newArg + " " + arg.substring(0, arg.length() - 1);
                }
                newArgs.add(newArg);
                continue;
            }
            newArgs.add(arg);
        }
        return newArgs.toArray(new String[1]);
    }

    public static ArrayList<String> getFirstLinesFromFile(File tableFile, int nLines) {
        FileReader inputReader;
        try {
            inputReader = new FileReader(tableFile);
        }
        catch (FileNotFoundException ex) {
            Log.logger.severe("File does not exist");
            ex.printStackTrace();
            return null;
        }
        BufferedReader tableInput = new BufferedReader(inputReader);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = tableInput.readLine();
            for (int i = 1; i <= nLines && line != null; ++i) {
                lines.add(line);
                line = tableInput.readLine();
            }
            inputReader.close();
        }
        catch (IOException ex) {
            Log.logger.severe("IOException while reading file");
            ex.printStackTrace();
            return null;
        }
        if (lines.size() == 0) {
            Log.logger.severe("Could not read any line from file");
            return null;
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileIsPlainText(File file) {
        int total;
        if (file.getName().contains(".csv") || file.getName().contains(".tsv") || file.getName().contains(".txt")) {
            return true;
        }
        if (file.getName().contains(".pdf")) {
            return false;
        }
        FileReader inputStream = null;
        int validChars = 0;
        int invalidChars = 0;
        try {
            int c;
            inputStream = new FileReader(file);
            int maxChars = 2000;
            while ((c = inputStream.read()) != -1) {
                if (c == 10 || c == 11 || c == 13 || c >= 32 && c <= 126 || c == 153 || c >= 160 && c <= 255 || c == 884 || c == 885 || c == 890 || c == 894 || c >= 900 && c <= 974) {
                    ++validChars;
                } else {
                    ++invalidChars;
                }
                if (maxChars <= 0) {
                    break;
                }
                --maxChars;
            }
        }
        catch (FileNotFoundException c) {
        }
        catch (IOException c) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException c) {}
            }
        }
        if ((total = validChars + invalidChars) == 0) {
            return false;
        }
        return (float)validChars / (float)total >= 0.95f;
    }

    public static enum RoundingMode {
        HALF_UP,
        HALF_DOWN,
        UP,
        DOWN;

    }
}

