/*
 * Decompiled with CFR 0.152.
 */
package peridot;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import peridot.Archiver.PeridotConfig;
import peridot.CLI.UserInterface;
import peridot.Log;
import peridot.Operations;
import peridot.script.Task;
import peridot.script.r.InstallationBatch;

public class Main {
    public static AtomicBoolean finished;

    public static void main(String[] args) {
        finished = new AtomicBoolean(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Main.abortTasks();
                Main.abortInstallations();
            }
        });
        Operations.createNecessaryDirs();
        if (Operations.loadModules()) {
            if (args.length == 0) {
                UserInterface.printNoCommand();
            } else {
                UserInterface userInterface = new UserInterface(args);
            }
        }
        try {
            PeridotConfig.save();
        }
        catch (IOException ex) {
            Log.logger.severe("Error while saving the current configurations");
            ex.printStackTrace();
        }
        finished.set(true);
    }

    public static void abortTasks() {
        Task task = Task.getRunningTask();
        if (task != null && task.processingStatus.get() < 0) {
            System.out.println("\n[USER-INTERRUPT]\n");
            task.abortAll();
            try {
                while (!finished.get()) {
                }
            }
            catch (Exception ex) {
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static void abortInstallations() {
        if (InstallationBatch.lastInstallation != null) {
            System.out.println("\n[USER-INTERRUPT]\n");
            InstallationBatch.lastInstallation.stop();
            long startedWaiting = System.currentTimeMillis();
            while (InstallationBatch.lastInstallation.isRunning()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - 5000L < startedWaiting) continue;
                System.out.println("Waited 5 seconds for installations to finish, exiting anyway.");
                break;
            }
        }
    }
}

