/*
 * Decompiled with CFR 0.152.
 */
package peridot;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Output {
    String buffer;
    public LocalDateTime lastUpdate;
    ConcurrentLinkedQueue<String> toAdd;
    boolean printInConsole;

    public Output(boolean printInConsole) {
        this.make();
        this.printInConsole = printInConsole;
    }

    public Output() {
        this.make();
    }

    private void make() {
        this.toAdd = new ConcurrentLinkedQueue();
        this.buffer = "";
        this.storeTimeOfUpdate();
        this.printInConsole = false;
    }

    public void storeTimeOfUpdate() {
        this.lastUpdate = LocalDateTime.now();
    }

    public synchronized void appendLine(String text) {
        this.toAdd.add(text + System.lineSeparator());
        this.storeTimeOfUpdate();
        this.getFromQueue();
    }

    public synchronized void appendChar(char text) {
        this.toAdd.add(text + "");
        this.storeTimeOfUpdate();
        this.getFromQueue();
    }

    public synchronized void setText(String text) {
        this.buffer = "";
        this.toAdd.add(text);
        this.storeTimeOfUpdate();
        this.getFromQueue();
    }

    public String getText() {
        while (!this.toAdd.isEmpty()) {
            this.buffer = this.buffer + this.toAdd.poll();
        }
        return this.buffer;
    }

    public synchronized void getFromQueue() {
        while (!this.toAdd.isEmpty()) {
            String str = this.toAdd.poll();
            this.buffer = this.buffer + str;
            if (!this.printInConsole) continue;
            System.out.print(str);
        }
    }

    public HashMap<String, List<String>> getCommands() {
        while (!this.toAdd.isEmpty()) {
        }
        String[] infoLines = this.buffer.split(System.lineSeparator());
        String currentCommand = null;
        ArrayList<String> commandOutput = null;
        HashMap<String, List<String>> commands = new HashMap<String, List<String>>();
        for (int i = 0; i < infoLines.length; ++i) {
            if (infoLines[i].length() <= 0) continue;
            if (infoLines[i].charAt(0) == '>' || i == 0) {
                if (currentCommand != null) {
                    commands.put(currentCommand, commandOutput);
                }
                currentCommand = infoLines[i];
                commandOutput = new ArrayList<String>();
                continue;
            }
            if (commandOutput == null) continue;
            commandOutput.add(infoLines[i]);
        }
        return commands;
    }
}

