/*
 * Decompiled with CFR 0.152.
 */
package peridot.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import peridot.AnalysisParameters;
import peridot.Archiver.Manager;
import peridot.Archiver.Persistence;
import peridot.Archiver.Places;
import peridot.GeneIdType;
import peridot.Log;
import peridot.Organism;
import peridot.script.AnalysisModule;
import peridot.script.PostAnalysisModule;
import peridot.script.r.Interpreter;
import peridot.script.r.Package;

public class RModule
implements Serializable {
    public static HashMap<String, RModule> availableModules;
    public static Map<String, Class> availableParamTypes;
    public static final String binExtension = "PeridotModule";
    public Map<String, Class> requiredParameters = null;
    public Set<Package> requiredPackages = null;
    public Map<String, Object> parameters = null;
    public Set<String> requiredExternalFiles = null;
    public Set<String> requiredScripts = null;
    public Set<String> results = null;
    public Set<String> mandatoryResults = null;
    protected String scriptName = null;
    public File workingDirectory = null;
    protected File configFile = null;
    public File resultsFolder = null;
    public File scriptFile = null;
    public String name = null;
    public boolean environmentCreated;
    public boolean max2Conditions;
    public boolean needsReplicates;
    public boolean mandatoryFailed;
    public String info = null;
    public StringBuilder scriptContent = null;

    private static Map<String, Class> defineAvailableParamTypes() {
        TreeMap<String, Class> params = new TreeMap<String, Class>();
        params.put(Integer.class.getSimpleName(), Integer.class);
        params.put(Float.class.getSimpleName(), Float.class);
        params.put(GeneIdType.class.getSimpleName(), GeneIdType.class);
        params.put(Organism.class.getSimpleName(), Organism.class);
        return params;
    }

    public static void removeScriptResults() {
        File dir = Places.finalResultsDir;
        if (dir.exists()) {
            for (File file : FileUtils.listFilesAndDirs(dir, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE)) {
                if (file.isDirectory() && !file.getAbsolutePath().equals(dir.getAbsolutePath())) {
                    try {
                        FileUtils.deleteDirectory(file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Log.logger.info("Cant delete " + file.getName() + " results.");
                    }
                    continue;
                }
                if (!file.isFile() || !file.getAbsolutePath().contains(".output")) continue;
                FileUtils.deleteQuietly(file);
            }
        }
    }

    public static Vector<String> getAvailableAnalysisModules() {
        Vector<String> scripts = new Vector<String>();
        for (Map.Entry<String, RModule> pair : availableModules.entrySet()) {
            if (!pair.getValue().getWorkingDirectory().getName().contains(".AnalysisModule")) continue;
            scripts.add(pair.getKey());
        }
        return scripts;
    }

    public static Vector<String> getAvailablePostAnalysisModules() {
        Vector<String> scripts = new Vector<String>();
        for (Map.Entry<String, RModule> pair : availableModules.entrySet()) {
            if (!pair.getValue().getWorkingDirectory().getName().contains(".PostAnalysisModule")) continue;
            scripts.add(pair.getKey());
        }
        return scripts;
    }

    public static Vector<String> getAvailableModules() {
        Vector<String> scripts = new Vector<String>();
        for (Map.Entry<String, RModule> pair : availableModules.entrySet()) {
            scripts.add(pair.getKey());
        }
        return scripts;
    }

    public static Set<String> modulesWithUnmetDependencies() {
        if (Interpreter.isDefaultInterpreterDefined()) {
            return RModule.modulesWithUnmetDependencies(Interpreter.defaultInterpreter);
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(RModule.getAvailableModules());
        return set;
    }

    public static Set<String> modulesWithUnmetDependencies(Interpreter interpreter) {
        HashSet<String> cannotRun = new HashSet<String>();
        for (String module : RModule.getAvailableModules()) {
            if (availableModules.get(module).requiredPackagesInstalled(interpreter)) continue;
            cannotRun.add(module);
        }
        return cannotRun;
    }

    public static void updateUserScripts() {
        RModule.loadUserScripts();
    }

    public static boolean deleteScript(String script) {
        boolean reallyDeleted;
        try {
            FileUtils.deleteDirectory(availableModules.get(script).getWorkingDirectory());
            Log.logger.info("Deleting " + availableModules.get(script).getWorkingDirectory().getAbsolutePath());
        }
        catch (IOException ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
        boolean bl = reallyDeleted = !availableModules.get(script).getWorkingDirectory().exists();
        if (!reallyDeleted) {
            Log.logger.severe("Could not delete " + RModule.availableModules.get((Object)script).workingDirectory.getName());
        }
        return reallyDeleted;
    }

    public static void loadUserScripts() {
        HashMap<String, PostAnalysisModule> loadedScripts = new HashMap<String, PostAnalysisModule>();
        TreeSet<File> subDirs = new TreeSet<File>();
        TreeSet<File> subFiles = new TreeSet<File>(FileUtils.listFilesAndDirs(Places.modulesDir, TrueFileFilter.TRUE, TrueFileFilter.TRUE));
        for (File file : subFiles) {
            String filePath = file.getAbsolutePath();
            if (filePath.equals(Places.modulesDir.getAbsolutePath()) || file.getAbsolutePath().contains("results") || file.getAbsolutePath().contains("results" + File.separator) || !file.isDirectory()) continue;
            subDirs.add(file);
        }
        for (File file : subDirs) {
            try {
                RModule script;
                if (file.getName().contains(".PostAnalysisModule")) {
                    script = new PostAnalysisModule(file);
                    loadedScripts.put(script.name, (PostAnalysisModule)script);
                    continue;
                }
                if (!file.getName().contains(".AnalysisModule")) continue;
                script = new AnalysisModule(file);
                loadedScripts.put(((AnalysisModule)script).name, (PostAnalysisModule)script);
            }
            catch (Exception ex) {
                Log.logger.info("ERROR\nCould not import " + file.getName() + ", because: ");
                Log.logger.info(ex.getMessage());
                ex.printStackTrace();
            }
        }
        availableModules = loadedScripts;
        if (loadedScripts.size() <= 0) {
            Log.logger.severe("Could not load any script from user folder.");
        }
    }

    public static Map<String, Class> getRequiredParametersFromModules() {
        HashMap<String, Class> params = new HashMap<String, Class>();
        for (RModule script : availableModules.values()) {
            for (Map.Entry<String, Class> param : script.requiredParameters.entrySet()) {
                params.put(param.getKey(), param.getValue());
            }
        }
        return params;
    }

    public static Set<Package> requiredPackages() {
        HashSet<Package> req = new HashSet<Package>();
        for (RModule module : availableModules.values()) {
            req.addAll(module.requiredPackages);
        }
        return req;
    }

    public RModule(String name, String scriptFile, Map<String, Class> requiredParameters, Set<String> requiredExternalFiles, Set<String> results, Set<String> requiredScripts) {
        this.max2Conditions = false;
        this.name = name;
        this.scriptName = scriptFile;
        this.requiredParameters = requiredParameters;
        this.requiredExternalFiles = requiredExternalFiles;
        this.results = results;
        this.mandatoryResults = new TreeSet<String>();
        this.requiredScripts = requiredScripts;
        this.parameters = new HashMap<String, Object>();
        this.info = "";
        this.scriptFile = this.getScriptFile();
        this.workingDirectory = this.getWorkingDirectory();
        this.configFile = this.getConfigFile();
        this.environmentCreated = false;
        this.mandatoryFailed = false;
        this.loadScriptContent();
    }

    private void loadScriptContent() {
        if (this.getScriptFile().exists()) {
            this.scriptContent = Manager.fileToString(this.getScriptFile());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RModule(File dir) throws Exception {
        this.environmentCreated = true;
        this.parameters = new TreeMap<String, Object>();
        this.results = new TreeSet<String>();
        this.mandatoryResults = new TreeSet<String>();
        this.requiredScripts = new TreeSet<String>();
        this.requiredParameters = new TreeMap<String, Class>();
        this.requiredExternalFiles = new TreeSet<String>();
        this.requiredPackages = new HashSet<Package>();
        this.info = "";
        this.needsReplicates = false;
        this.max2Conditions = false;
        File descriptionFile = new File(dir.getAbsolutePath() + File.separator + "description");
        if (!descriptionFile.exists()) {
            throw new Exception("script description file not found in " + descriptionFile.getAbsolutePath());
        }
        FileReader fileReader = new FileReader(descriptionFile);
        BufferedReader reader = new BufferedReader(fileReader);
        String line = reader.readLine();
        while (line != null) {
            String[] words = line.split("\t");
            if (words.length <= 1) throw new Exception("Number of words in line different from 2 or 3: " + words.length + ". In:\n" + line + "\nModule: " + dir.getAbsolutePath());
            String category = words[0];
            String value = words[1];
            if (words.length == 2) {
                if (category.equals("[NAME]")) {
                    this.name = value;
                } else if (category.equals("[SCRIPT-NAME]")) {
                    this.scriptName = value;
                } else if (category.equals("[RESULT]")) {
                    this.results.add(value);
                } else if (category.equals("[MANDATORY-RESULT]")) {
                    this.results.add(value);
                    this.mandatoryResults.add(value);
                } else if (category.equals("[REQUIRED-INPUT-FILE]")) {
                    this.requiredExternalFiles.add(value);
                } else if (category.equals("[REQUIRED-SCRIPT]")) {
                    this.requiredScripts.add(value);
                } else if (category.equals("[MAX-2-CONDITIONS]")) {
                    this.max2Conditions = Boolean.parseBoolean(value);
                } else if (category.equals("[NEEDS-REPLICATES]")) {
                    this.needsReplicates = Boolean.parseBoolean(value);
                } else {
                    if (!category.equals("[INFO]")) throw new Exception("Unknown category: " + category + " " + value);
                    this.info = this.info + value + "\n";
                }
            } else {
                if (words.length != 3) throw new Exception("Number of words in line different from 2 or 3: " + words.length + ". In:\n" + line + "\nModule: " + dir.getAbsolutePath());
                String value2 = words[2];
                if (category.equals("[REQUIRED-PARAMETER]")) {
                    if (!AnalysisParameters.availableParamTypes.keySet().contains(value2)) throw new Exception("Unknown parameter type: " + value2);
                    this.requiredParameters.put(value, AnalysisParameters.availableParamTypes.get(value2));
                } else {
                    if (!category.equals("[PACKAGE]")) throw new Exception("Unknown category: " + category);
                    Package pack = new Package(value, value2);
                    this.requiredPackages.add(pack);
                }
            }
            line = reader.readLine();
        }
        reader.close();
        fileReader.close();
        this.workingDirectory = this.getWorkingDirectory();
        this.configFile = this.getConfigFile();
        this.scriptFile = this.getScriptFile();
        this.resultsFolder = new File(this.workingDirectory.getAbsolutePath() + File.separator + "results");
        if (!this.resultsFolder.exists()) {
            FileUtils.forceMkdir(this.resultsFolder);
        }
        this.loadScriptContent();
        this.mandatoryFailed = false;
    }

    public File getDescriptionFile() {
        return new File(this.getWorkingDirectoryPath() + File.separator + "description");
    }

    public void createClassDescription() throws IOException {
        File description = new File(this.getWorkingDirectoryPath() + File.separator + "description");
        description.createNewFile();
        FileWriter fileWriter = new FileWriter(description);
        BufferedWriter writer = new BufferedWriter(fileWriter);
        writer.write("[NAME]\t" + this.name + System.lineSeparator());
        writer.write("[SCRIPT-NAME]\t" + this.scriptName + System.lineSeparator());
        writer.write("[MAX-2-CONDITIONS]\t" + this.max2Conditions + System.lineSeparator());
        writer.write("[NEEDS-REPLICATES]\t" + this.needsReplicates + System.lineSeparator());
        for (String string : this.results) {
            if (this.mandatoryResults.contains(string)) {
                writer.write("[MANDATORY-RESULT]\t" + string + System.lineSeparator());
                continue;
            }
            writer.write("[RESULT]\t" + string + System.lineSeparator());
        }
        for (String string : this.requiredExternalFiles) {
            writer.write("[REQUIRED-INPUT-FILE]\t" + string + System.lineSeparator());
        }
        for (String string : this.requiredScripts) {
            writer.write("[REQUIRED-SCRIPT]\t" + string + System.lineSeparator());
        }
        for (Map.Entry entry : this.requiredParameters.entrySet()) {
            String className = ((Class)entry.getValue()).getSimpleName();
            writer.write("[REQUIRED-PARAMETER]\t" + (String)entry.getKey() + "\t" + className + System.lineSeparator());
        }
        for (Package package_ : this.requiredPackages) {
            writer.write("[PACKAGE]\t" + package_.name + "\t" + package_.version.toString() + System.lineSeparator());
        }
        String infoStr = "[INFO]\t";
        String[] stringArray = this.info.split("\n");
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String line = stringArray[i];
            if (line.length() <= 0 || line.length() == 1 && line.equals("\t")) continue;
            lines.add(line.replace(infoStr, ""));
        }
        for (String line : lines) {
            writer.write(infoStr + line + System.lineSeparator());
        }
        writer.close();
        fileWriter.close();
    }

    public void createEnvironment(String newScriptFilePath) {
        try {
            Log.logger.info("trying to create " + this.getWorkingDirectoryPath());
            FileUtils.deleteDirectory(this.getWorkingDirectory());
            this.getWorkingDirectory().mkdirs();
            this.getWorkingDirectory().mkdir();
            if (!this.getWorkingDirectory().exists()) {
                Log.logger.info("could not create " + this.getWorkingDirectory().getName());
            } else {
                Log.logger.info("created " + this.getWorkingDirectory().getName());
            }
            if (newScriptFilePath != null) {
                if (!this.copyExternalScriptToWorkingDir(newScriptFilePath, this.scriptName)) {
                    throw new IOException("Could not copy external script " + newScriptFilePath);
                }
            } else if (this.scriptContent != null) {
                this.exportScriptToDir();
            }
            this.loadScriptContent();
            this.resultsFolder = new File(this.getWorkingDirectoryPath() + File.separator + "results");
            FileUtils.forceMkdir(this.resultsFolder);
            if (!this.resultsFolder.exists()) {
                Log.logger.info("could not create " + this.resultsFolder.getAbsolutePath());
            }
            this.environmentCreated = true;
            this.createClassDescription();
        }
        catch (Exception ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void exportScriptToDir() {
        if (this.scriptContent != null && this.scriptContent.toString().length() > 1) {
            if (this.getScriptFile().exists()) {
                this.getScriptFile().delete();
                FileUtils.deleteQuietly(this.getScriptFile());
            }
            try {
                this.getScriptFile().createNewFile();
                PrintWriter out = new PrintWriter(this.getScriptFile());
                out.println(this.scriptContent.toString());
                out.close();
            }
            catch (Exception ex) {
                Log.logger.severe("Could not export script from RModule to script dir.");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setResultAsMandatory(String res) {
        if (this.results.contains(res)) {
            this.mandatoryResults.add(res);
        }
    }

    public Vector<String> getParamsDescription() {
        Vector<String> list = new Vector<String>();
        for (Map.Entry<String, Class> pair : this.requiredParameters.entrySet()) {
            String entry = "";
            entry = entry + pair.getKey() + ": ";
            entry = entry + pair.getValue().getSimpleName();
            list.add(entry);
        }
        return list;
    }

    public Object[] getInputFiles() {
        return this.requiredExternalFiles.toArray();
    }

    public String getScriptPath() {
        if (this.scriptFile != null) {
            return this.scriptFile.getAbsolutePath();
        }
        return this.getWorkingDirectoryPath() + File.separator + this.scriptName;
    }

    public File getScriptFile() {
        if (this.scriptFile != null) {
            return this.scriptFile;
        }
        return new File(this.getScriptPath());
    }

    public String getWorkingDirectoryPath() {
        if (this.workingDirectory != null) {
            return this.workingDirectory.getAbsolutePath();
        }
        return Places.modulesDir + File.separator + this.name + "." + this.getScriptType();
    }

    public File getWorkingDirectory() {
        if (this.workingDirectory != null) {
            return this.workingDirectory;
        }
        return new File(this.getWorkingDirectoryPath());
    }

    public String getConfigPath() {
        if (this.configFile != null) {
            return this.configFile.getAbsolutePath();
        }
        return this.getWorkingDirectory() + File.separator + "config.txt";
    }

    public File getConfigFile() {
        if (this.configFile != null) {
            return this.configFile;
        }
        return new File(this.getConfigPath());
    }

    public void passParameter(String parameterName, Object parameter) {
        this.parameters.put(parameterName, parameter);
    }

    public void passParameters(AnalysisParameters params) {
        for (Map.Entry<String, Class> pair : this.requiredParameters.entrySet()) {
            if (!params.parameters.containsKey(pair.getKey())) continue;
            this.passParameter(pair.getKey(), params.parameters.get(pair.getKey()));
        }
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public boolean requirementsSufficed() {
        return this.parametersSufficed() && this.filesSufficed();
    }

    public boolean parametersSufficed() {
        for (Map.Entry<String, Class> pair : this.requiredParameters.entrySet()) {
            Object parameter = this.parameters.get(pair.getKey());
            if (parameter == null) {
                Log.logger.info(pair.getKey() + " not received");
                return false;
            }
            if (parameter.getClass() == pair.getValue()) continue;
            Log.logger.info("expected a " + pair.getValue().toString() + " but received a " + this.parameters.getClass().toString() + ", in " + pair.getKey());
            return false;
        }
        return true;
    }

    public boolean filesSufficed() {
        for (String filePath : this.requiredExternalFiles) {
            if (Manager.fileExists(Places.finalResultsDir.getAbsolutePath() + File.separator + filePath)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getNotExistantResults() {
        TreeSet<String> notExist = new TreeSet<String>();
        String scriptTypeExtension = ".PostAnalysisModule";
        if (RModule.getAvailableAnalysisModules().contains(this.name)) {
            scriptTypeExtension = ".AnalysisModule";
        }
        for (String filePath : this.results) {
            if (Manager.fileExists(Places.finalResultsDir.getAbsolutePath() + File.separator + this.name + scriptTypeExtension + File.separator + filePath)) continue;
            notExist.add(filePath);
        }
        return notExist;
    }

    public Set<String> filesAreInRequirements(AbstractCollection<String> toVerify) {
        TreeSet<String> present = new TreeSet<String>();
        for (String filePath : this.requiredExternalFiles) {
            for (String otherPath : toVerify) {
                if (!otherPath.contains(filePath)) continue;
                present.add(otherPath);
            }
        }
        return present;
    }

    public boolean createConfig() {
        if (this.parametersSufficed() && this.environmentCreated) {
            this.createConfigFile();
            return true;
        }
        return false;
    }

    private void saveResultsAt(String newFolder) {
        Collection<File> subs = FileUtils.listFiles(this.resultsFolder, null, true);
        if (subs != null) {
            new File(newFolder).mkdir();
            for (File sub : subs) {
                if (!sub.isFile()) continue;
                String subLocation = sub.getAbsolutePath();
                String destLocation = subLocation.replace(this.resultsFolder.getAbsolutePath(), newFolder);
                File destination = new File(destLocation);
                try {
                    FileUtils.copyFile(sub, destination);
                }
                catch (Exception ex) {
                    Log.logger.severe("Failed copying " + sub.getAbsolutePath() + " to " + destination.getAbsolutePath());
                    ex.printStackTrace();
                }
            }
        }
    }

    public void saveResults() {
        this.saveResultsAt(Places.finalResultsDir.getAbsolutePath() + File.separator + this.name + "." + this.getClass().getSimpleName());
    }

    protected void createConfigFile() {
        if (this.parametersSufficed() && this.workingDirectory.exists()) {
            try {
                this.getConfigFile().createNewFile();
                FileWriter fileWriter = new FileWriter(this.getConfigFile());
                PrintWriter printWriter = new PrintWriter(fileWriter);
                LinkedList<String> names = new LinkedList<String>();
                LinkedList<Object> values = new LinkedList<Object>();
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    names.add(entry.getKey());
                    values.add(entry.getValue());
                }
                printWriter.print("id|");
                for (String string : names) {
                    printWriter.print(string);
                    if (string == names.getLast()) continue;
                    printWriter.print("|");
                }
                printWriter.print("\n");
                printWriter.print("1|");
                for (Map.Entry<String, Object> entry : values) {
                    printWriter.print(entry.toString());
                    if (entry == values.getLast()) continue;
                    printWriter.print("|");
                }
                printWriter.print("\n");
                printWriter.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean copyExternalScriptToWorkingDir(String path, String name) {
        try {
            File external = new File(path);
            File inner = new File(this.getWorkingDirectoryPath() + File.separator + name);
            FileUtils.copyFile(external, inner);
            this.scriptFile = inner;
            return true;
        }
        catch (IOException ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    public void clearResults() {
        Log.logger.info("cleaning " + this.name + " previous results");
        try {
            FileUtils.deleteDirectory(this.resultsFolder);
        }
        catch (Exception ex) {
            Log.logger.info("error cleaning results");
            ex.printStackTrace();
        }
    }

    public void clearEnvironment() {
        if (!this.getWorkingDirectory().exists()) {
            return;
        }
        Log.logger.info("cleaning " + this.name);
        try {
            FileUtils.deleteDirectory(this.getWorkingDirectory());
            this.environmentCreated = false;
        }
        catch (Exception ex) {
            Log.logger.info("error cleaning");
            ex.printStackTrace();
        }
    }

    public boolean verifyResults() {
        int nSuccessful = 0;
        for (String resultName : this.results) {
            if (!new File(this.resultsFolder + File.separator + resultName).exists()) {
                Log.logger.warning("The expected result does not exists: " + this.resultsFolder + File.separator + resultName);
                if (!this.mandatoryResults.contains(resultName)) continue;
                Log.logger.severe(resultName + " was a mandatory result  and it failed!");
                this.mandatoryFailed = true;
                return false;
            }
            ++nSuccessful;
        }
        this.mandatoryFailed = false;
        return nSuccessful > 0;
    }

    public void cleanLocalResults() {
        if (!this.resultsFolder.exists()) {
            return;
        }
        Iterator<File> iterator = FileUtils.iterateFiles(this.resultsFolder, null, false);
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                file.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void cleanTempFiles() {
        if (!this.getWorkingDirectory().exists()) {
            return;
        }
        Iterator<File> iterator = FileUtils.iterateFiles(this.getWorkingDirectory(), null, false);
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file.getAbsolutePath().equals(this.resultsFolder.getAbsolutePath()) || file.getName().equals("description") || file.getAbsolutePath().equals(this.getWorkingDirectoryPath()) || file.getAbsolutePath().equals(this.scriptFile.getAbsolutePath())) continue;
            try {
                file.delete();
            }
            catch (Exception ex) {
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void toBin(File file) throws IOException {
        Persistence.saveObjectAsBin(file, this);
    }

    public String getScriptType() {
        if (this instanceof AnalysisModule) {
            return "AnalysisModule";
        }
        if (this instanceof PostAnalysisModule) {
            return "PostAnalysisModule";
        }
        return "RModule";
    }

    public Set<Package> requiredPackagesNotInstalled() {
        if (Interpreter.isDefaultInterpreterDefined()) {
            return this.requiredPackagesNotInstalled(Interpreter.defaultInterpreter);
        }
        return this.requiredPackages;
    }

    public Set<Package> requiredPackagesNotInstalled(Interpreter interpreter) {
        if (interpreter != null) {
            Set<Package> installed = interpreter.availablePackages;
            TreeSet<String> installedNames = new TreeSet<String>();
            HashSet<Package> notInstalledPacks = new HashSet<Package>();
            for (Package pack : installed) {
                installedNames.add(pack.name);
            }
            for (Package pack : this.requiredPackages) {
                if (installedNames.contains(pack.name)) continue;
                notInstalledPacks.add(pack);
            }
            return notInstalledPacks;
        }
        return this.requiredPackages;
    }

    public boolean requiredPackagesInstalled() {
        return this.requiredPackagesNotInstalled().size() == 0;
    }

    public boolean requiredPackagesInstalled(Interpreter interpreter) {
        return this.requiredPackagesNotInstalled(interpreter).size() == 0;
    }

    static {
        availableParamTypes = RModule.defineAvailableParamTypes();
    }
}

