/*
 * Decompiled with CFR 0.152.
 */
package peridot.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import peridot.Archiver.Manager;
import peridot.Archiver.Places;
import peridot.Log;
import peridot.Output;
import peridot.script.RModule;
import peridot.script.ScriptRunnable;
import peridot.script.Task;
import peridot.script.r.Interpreter;

public class ScriptExec {
    public RModule script;
    public AtomicBoolean running;
    public AtomicBoolean started;
    public AtomicBoolean savingFlag;
    public AtomicBoolean successFlag;
    public Process process = null;
    public Integer exitStatus;
    private Thread scriptThread;
    private ScriptRunnable runnable;
    public Thread runningUpdater;
    Runnable isRunningRunnable;
    Task task;
    public Output output;
    public Interpreter interpreter;

    public ScriptExec(RModule script, Output output, Task task, Interpreter interpreter) {
        this.interpreter = interpreter;
        this.task = task;
        this.script = script;
        this.output = output;
        this.savingFlag = new AtomicBoolean();
        this.savingFlag.set(false);
        this.running = new AtomicBoolean();
        this.running.set(false);
        this.started = new AtomicBoolean();
        this.started.set(false);
        this.successFlag = new AtomicBoolean();
        this.started.set(false);
        this.process = null;
        this.runnable = new ScriptRunnable(this);
        this.scriptThread = new Thread(this.runnable);
        this.defineIsRunningRunnable();
        this.runningUpdater = new Thread(this.isRunningRunnable);
    }

    private void defineIsRunningRunnable() {
        this.isRunningRunnable = () -> {
            try {
                this.exitStatus = new Integer(this.process.waitFor());
                if (this.exitStatus != 0) {
                    Log.logger.severe(this.script.name + " exit status: " + this.exitStatus);
                }
            }
            catch (InterruptedException ex) {
                this.output.appendLine("Process Interrupted");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (NullPointerException ex) {
                this.output.appendLine("No process to monitor.");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.started.set(true);
            this.onEnd();
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateOutput() {
        if (this.process != null) {
            InputStream iStream = this.process.getInputStream();
            InputStreamReader iStreamReader = new InputStreamReader(iStream);
            BufferedReader buffReader = new BufferedReader(iStreamReader);
            try {
                int c;
                while ((c = buffReader.read()) != -1) {
                    this.output.appendChar((char)c);
                }
                if (this.process.isAlive() && this.running.get()) {
                    // empty if block
                }
            }
            catch (IOException ex) {
                this.output.appendLine("IOException in " + this.script.name + ": ");
                this.output.appendLine(ex.getMessage());
                this.output.appendLine(ex.toString());
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            this.output.appendLine("No process started!");
        }
        if (this.running.get()) {
            this.onEnd();
        }
    }

    public void cancel() {
        this.afterStart();
    }

    public void start() {
        this.scriptThread.start();
    }

    public void afterStart() {
        this.process = this.runnable.process;
        this.running.set(true);
        this.started.set(true);
        this.runningUpdater.start();
        new Thread(() -> this.updateOutput()).start();
    }

    public synchronized void onEnd() {
        if (!this.running.get()) {
            return;
        }
        String exitMessage = this.script.name + " finished.";
        Log.logger.info(exitMessage);
        this.savingFlag.set(true);
        this.output.appendLine("\n[End of input]");
        Manager.stringToFile(Places.finalResultsDir + File.separator + this.script.name + ".output", this.output.getText());
        if (this.script.verifyResults()) {
            this.successFlag.set(true);
            Log.logger.finer("Saving results of " + this.script.name);
            this.script.saveResults();
        } else {
            this.successFlag.set(false);
        }
        this.script.cleanLocalResults();
        this.savingFlag.set(false);
        this.started.set(true);
        this.running.set(false);
        this.task.addFinished(this.script.name, false);
    }

    public String getName() {
        return this.script.name;
    }

    public void abort() {
        if ((this.running.get() || this.process.isAlive()) && this.process != null) {
            this.process.destroyForcibly();
        }
        this.onEnd();
    }

    public boolean verifyResults() {
        return this.script.verifyResults();
    }
}

