/*
 * Decompiled with CFR 0.152.
 */
package peridot.script;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import peridot.Archiver.Places;
import peridot.Global;
import peridot.Log;
import peridot.script.ScriptExec;

public class ScriptRunnable
implements Runnable {
    ScriptExec exec;
    boolean preFailed;
    boolean ready;
    Runtime runtime = Runtime.getRuntime();
    String[] commandArray;
    String commandString;
    boolean firstRun;
    ProcessBuilder processBuilder;
    public Process process;

    ScriptRunnable(ScriptExec exec) {
        this.exec = exec;
        this.preFailed = false;
        this.ready = false;
        this.detectPreviousRunn();
        this.defineCommand();
        this.process = null;
    }

    @Override
    public void run() {
        ProcessBuilder processBuilder = this.makeProcessBuilder();
        if (processBuilder == null) {
            this.exec.output.appendLine("ProcessBuilder is null, not executing analysis.");
            Log.logger.severe("ProcessBuilder is null, not executing analysis.");
            return;
        }
        try {
            this.process = processBuilder.start();
            if (this.process == null) {
                throw new NullPointerException("Fatal Error: Failed to create " + this.exec.script.name + "'s process.");
            }
            this.exec.output.appendLine("Command line:\n" + Global.listOfWordsToLine(processBuilder.command()) + "\n---------------");
            this.exec.afterStart();
        }
        catch (IndexOutOfBoundsException ex) {
            this.exec.output.appendLine("IndexOutOfBoundsException: ");
            this.exec.output.appendLine(ex.getMessage());
            this.exec.output.appendLine(ex.toString());
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (SecurityException ex) {
            this.exec.output.appendLine("Security exception: ");
            this.exec.output.appendLine(ex.getMessage());
            this.exec.output.appendLine(ex.toString());
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            this.exec.output.appendLine("IO exception: ");
            this.exec.output.appendLine(ex.getMessage());
            this.exec.output.appendLine(ex.toString());
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NullPointerException ex) {
            this.exec.output.appendLine("NullPointerException: ");
            this.exec.output.appendLine(ex.getMessage());
            this.exec.output.appendLine(ex.toString());
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void detectPreviousRunn() {
        this.firstRun = true;
        Iterator<File> it = FileUtils.iterateFiles(this.exec.script.workingDirectory, null, false);
        while (it.hasNext()) {
            if (!it.next().getName().contains(".RData")) continue;
            this.firstRun = false;
            break;
        }
    }

    public void defineCommand() {
        boolean needsEnv = false;
        String rPath = this.exec.interpreter.exe;
        String notFirstExec = this.firstRun ? "0" : "1";
        String[] c = new String[]{rPath, "--no-save", "--no-restore", "--quiet", "--file=" + this.exec.script.scriptFile.getAbsolutePath(), "--args", this.exec.script.workingDirectory.getAbsolutePath(), Places.finalResultsDir.getAbsolutePath(), this.exec.script.resultsFolder.getAbsolutePath(), notFirstExec};
        this.commandArray = c;
        if (needsEnv) {
            int i;
            String[] envVars = this.exec.interpreter.getLinuxEnvVars();
            String[] commandArray2 = new String[this.commandArray.length + 1 + envVars.length];
            commandArray2[0] = "env";
            for (i = 0; i < envVars.length; ++i) {
                commandArray2[i + 1] = envVars[i];
            }
            for (i = 0; i < this.commandArray.length; ++i) {
                commandArray2[i + 1 + envVars.length] = this.commandArray[i];
            }
            this.commandArray = commandArray2;
        }
        this.commandString = "";
        for (int i = 0; i < this.commandArray.length; ++i) {
            this.commandString = this.commandString + this.commandArray[i];
            if (i == this.commandArray.length - 1) continue;
            this.commandString = this.commandString + " ";
        }
        Log.logger.fine(this.commandString);
    }

    public ProcessBuilder makeProcessBuilder() {
        this.processBuilder = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            this.processBuilder = new ProcessBuilder(this.commandArray);
        } else {
            File executeScript = new File(this.exec.script.workingDirectory.getAbsolutePath() + File.separator + "run.sh");
            try {
                if (executeScript.exists()) {
                    executeScript.delete();
                }
                executeScript.createNewFile();
                PrintWriter out = new PrintWriter(executeScript);
                out.println(this.commandString);
                out.close();
            }
            catch (IOException ex) {
                Log.logger.severe("Error, could not create " + executeScript.getAbsolutePath());
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
            TreeSet<PosixFilePermission> permsSet = new TreeSet<PosixFilePermission>();
            permsSet.add(PosixFilePermission.OWNER_EXECUTE);
            permsSet.add(PosixFilePermission.OWNER_READ);
            try {
                Files.setPosixFilePermissions(executeScript.toPath(), permsSet);
            }
            catch (UnsupportedOperationException ex) {
                Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because the file does not support PosixFileAttributeView");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
            catch (ClassCastException ex) {
                Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because some of the permissions granted are invalid.");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
            catch (SecurityException ex) {
                Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because of an SecurityException.");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
            catch (IOException ex) {
                Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because of an I/O Exception.");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
            String[] bashCmdArray = new String[]{"/bin/bash", executeScript.getAbsolutePath()};
            this.processBuilder = new ProcessBuilder(bashCmdArray);
        }
        this.processBuilder.redirectErrorStream(true);
        return this.processBuilder;
    }
}

