/*
 * Decompiled with CFR 0.152.
 */
package peridot.script.r;

import java.util.Collection;
import java.util.Deque;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import peridot.Log;
import peridot.script.r.Interpreter;
import peridot.script.r.Package;
import peridot.script.r.PackageInstaller;

public class InstallationBatch {
    public Deque<PackageInstaller> concluded;
    public Queue<PackageInstaller> installationQueue;
    public PackageInstaller currentInstallation;
    public AtomicBoolean stopFlag;
    public Status status = Status.WAITING;
    public AtomicBoolean running;
    private Interpreter installingTo;
    public static InstallationBatch lastInstallation = null;

    public InstallationBatch(Collection<Package> packsToInstall, Interpreter installTo) {
        this.installingTo = installTo;
        this.concluded = new ConcurrentLinkedDeque<PackageInstaller>();
        this.currentInstallation = null;
        this.installationQueue = new ConcurrentLinkedQueue<PackageInstaller>();
        this.stopFlag = new AtomicBoolean(false);
        this.running = new AtomicBoolean(false);
        for (Package pack : packsToInstall) {
            this.addToQueue(new PackageInstaller(installTo, pack));
        }
    }

    public void addToQueue(PackageInstaller installer) {
        this.installationQueue.add(installer);
    }

    public void installationThread() {
        this.running.set(true);
        while (this.status == Status.INSTALLING) {
            if (this.stopFlag.get()) {
                this.cancelInstallations();
                this.status = Status.STOPPED;
                break;
            }
            if (!this.installationQueue.isEmpty()) {
                PackageInstaller installation;
                this.currentInstallation = installation = this.installationQueue.poll();
                Log.logger.info("Installing: " + installation.getPackageName());
                installation.install();
                this.currentInstallation = null;
                this.concluded.add(installation);
                int total = this.concluded.size() + this.installationQueue.size();
                String totalStr = " (" + this.concluded.size() + "/" + total + ")";
                if (installation.status == PackageInstaller.Status.INSTALLED) {
                    Log.logger.info("Installed: " + installation.getPackageName() + totalStr);
                    continue;
                }
                if (installation.status == PackageInstaller.Status.ALREADY_INSTALLED) {
                    Log.logger.info("Already installed: " + installation.getPackageName() + totalStr);
                    continue;
                }
                if (installation.status == PackageInstaller.Status.FAILED) {
                    Log.logger.severe(installation.getOutputStr());
                    Log.logger.severe("Failed to install: " + installation.getPackageName() + totalStr);
                    continue;
                }
                if (installation.status != PackageInstaller.Status.NO_PERMISSION) continue;
                Log.logger.info("This installation probably failed because you do not have access to the packages library of the current R environment. Try using r-peridot as root next time.");
                continue;
            }
            this.status = Status.FINISHED;
            break;
        }
        this.installingTo.analyseInterpreter();
        this.running.set(false);
    }

    public void startInstallations() {
        if (lastInstallation != null) {
            while (lastInstallation.isRunning()) {
            }
        }
        lastInstallation = this;
        this.status = Status.INSTALLING;
        this.running.set(true);
        new Thread(() -> this.installationThread()).start();
    }

    private void cancelInstallations() {
        if (this.currentInstallation != null) {
            this.currentInstallation.stop();
            this.concluded.add(this.currentInstallation);
            this.currentInstallation = null;
        }
        for (PackageInstaller installer : this.installationQueue) {
            installer.stop();
            this.concluded.add(installer);
        }
    }

    public int nFinished() {
        return this.concluded.size();
    }

    public int nToInstall() {
        int res = this.installationQueue.size();
        if (this.currentInstallation != null) {
            ++res;
        }
        return res;
    }

    public void stop() {
        if (this.currentInstallation != null) {
            this.currentInstallation.stop();
        }
        this.stopFlag.set(true);
    }

    public boolean isRunning() {
        return this.status == Status.INSTALLING;
    }

    public void waitToFinish() {
        while (this.running.get()) {
        }
    }

    public Collection<Package> getAlreadyInstalled() {
        Vector<Package> success = new Vector<Package>();
        for (PackageInstaller installer : this.concluded) {
            if (installer.status != PackageInstaller.Status.ALREADY_INSTALLED) continue;
            success.add(installer.getPackage());
        }
        return success;
    }

    public Collection<Package> getSuccessful() {
        Vector<Package> success = new Vector<Package>();
        for (PackageInstaller installer : this.concluded) {
            if (installer.status != PackageInstaller.Status.INSTALLED) continue;
            success.add(installer.getPackage());
        }
        return success;
    }

    public Collection<Package> getFailed() {
        Vector<Package> failures = new Vector<Package>();
        for (PackageInstaller installer : this.concluded) {
            if (installer.status != PackageInstaller.Status.FAILED) continue;
            failures.add(installer.getPackage());
        }
        return failures;
    }

    public Collection<Package> getNoPermission() {
        Vector<Package> noPerm = new Vector<Package>();
        for (PackageInstaller installer : this.concluded) {
            if (installer.status != PackageInstaller.Status.NO_PERMISSION) continue;
            noPerm.add(installer.getPackage());
        }
        return noPerm;
    }

    public static enum Status {
        WAITING,
        INSTALLING,
        STOPPED,
        FINISHED;

    }
}

