/*
 * Decompiled with CFR 0.152.
 */
package peridot.script.r;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import peridot.Global;
import peridot.Output;
import peridot.script.r.Package;
import peridot.script.r.VersionNumber;

public class RInfoParser {
    public VersionNumber rVersion = null;
    public Set<Package> packages = null;
    private HashMap<String, List<String>> commands;

    public RInfoParser(Output info) {
        this.commands = info.getCommands();
        this.readLines();
    }

    public boolean validOutput() {
        boolean hasRVersion = this.rVersion != null;
        boolean hasPackages = this.packages != null;
        return hasRVersion && hasPackages;
    }

    private void readLines() {
        List<String> versionOutput = this.commands.get("> R.Version()");
        this.readVersion(versionOutput);
        List<String> packsTable = this.commands.get("> onlyNamesAndVersion");
        this.readPackages(packsTable);
    }

    private void readVersion(List<String> versionOutput) {
        if (versionOutput != null) {
            String versionLine = null;
            for (int i = 0; i < versionOutput.size(); ++i) {
                if (!versionOutput.get(i).contains("$version.string")) continue;
                versionLine = versionOutput.get(i + 1);
            }
            if (versionLine != null) {
                VersionNumber version;
                String[] splice = Global.spliceBySpacesAndTabs(versionLine);
                String number = splice[3];
                this.rVersion = version = new VersionNumber(number);
            }
        }
    }

    private void readPackages(List<String> packsTable) {
        if (packsTable != null) {
            HashSet<Package> packs = new HashSet<Package>();
            for (int i = 1; i < packsTable.size(); ++i) {
                String[] splice = Global.spliceBySpacesAndTabs(packsTable.get(i));
                if (splice.length != 3) continue;
                Package pack = new Package(splice[1], splice[2]);
                packs.add(pack);
            }
            this.packages = packs.size() > 0 ? packs : null;
        }
    }
}

