/*
 * Decompiled with CFR 0.152.
 */
package peridot.script.r;

import java.io.Serializable;

public class VersionNumber
implements Comparable<VersionNumber>,
Serializable {
    public int[] numbers;
    private String fullVersion;

    public VersionNumber(String version) {
        version = version.replace('.', '-');
        String[] strNumbers = version.split("-");
        this.numbers = new int[strNumbers.length];
        this.fullVersion = "";
        for (int i = 0; i < strNumbers.length; ++i) {
            this.numbers[i] = Integer.parseInt(strNumbers[i]);
            this.fullVersion = this.fullVersion + strNumbers[i];
            if (i == strNumbers.length - 1) continue;
            this.fullVersion = this.fullVersion + ".";
        }
    }

    public String toString() {
        return this.fullVersion;
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        int i;
        int[] otherNumbers;
        int[] localNumbers;
        if (versionNumber.numbers.length > this.numbers.length) {
            localNumbers = new int[versionNumber.numbers.length];
            otherNumbers = versionNumber.numbers;
            for (i = 0; i < localNumbers.length; ++i) {
                localNumbers[i] = i < this.numbers.length ? this.numbers[i] : 0;
            }
        } else if (versionNumber.numbers.length < this.numbers.length) {
            otherNumbers = new int[this.numbers.length];
            localNumbers = this.numbers;
            for (i = 0; i < otherNumbers.length; ++i) {
                otherNumbers[i] = i < versionNumber.numbers.length ? versionNumber.numbers[i] : 0;
            }
        } else {
            otherNumbers = versionNumber.numbers;
            localNumbers = this.numbers;
        }
        for (i = 0; i < otherNumbers.length; ++i) {
            if (otherNumbers[i] > localNumbers[i]) {
                return -1;
            }
            if (otherNumbers[i] >= localNumbers[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean into(VersionNumber n) {
        for (int i = 0; i < n.numbers.length; ++i) {
            if (this.numbers[i] == n.numbers[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionNumber) {
            return this.compareTo((VersionNumber)obj) == 0;
        }
        return false;
    }
}

