/*
 * Decompiled with CFR 0.152.
 */
package peridot;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import peridot.Archiver.Manager;
import peridot.Archiver.Places;
import peridot.Archiver.Spreadsheet;
import peridot.Global;
import peridot.IndexedString;
import peridot.Log;

public class AnalysisData {
    public Spreadsheet.Info info;
    public File conditionsFile;
    public File expressionFile;
    public SortedMap<IndexedString, String> conditions;
    protected int countReadsThreshold;
    protected Global.RoundingMode roundMode;
    protected boolean hasReplicates = false;
    protected boolean moreThanTwoConditions = false;
    protected File finalCountReadsFile;
    protected File finalConditionsFile;

    public AnalysisData(File expressionFile, File conditionsFile, Spreadsheet.Info info, String roundMode, int countReadsThreshold) throws IOException {
        this.defaultBuilderOperations(expressionFile, conditionsFile, info, roundMode, countReadsThreshold);
    }

    public AnalysisData(File expressionFile, SortedMap<IndexedString, String> conditions, Spreadsheet.Info info, String roundMode, int countReadsThreshold) throws IOException {
        File newConditionsFile = new File(expressionFile.getAbsolutePath() + ".conditions");
        this.setConditions(AnalysisData.applyConditionsToExprFileSamples(expressionFile, info, conditions));
        AnalysisData.createConditionsFile(newConditionsFile, conditions, false, true);
        this.defaultBuilderOperations(expressionFile, newConditionsFile, info, roundMode, countReadsThreshold);
    }

    public static SortedMap<IndexedString, String> applyConditionsToExprFileSamples(File exprFile, Spreadsheet.Info info, SortedMap<IndexedString, String> cond) {
        SortedMap<IndexedString, String> conditions = AnalysisData.getConditionsFromExpressionFile(exprFile, info);
        for (Map.Entry<IndexedString, String> entry : cond.entrySet()) {
            conditions.put(entry.getKey(), entry.getValue());
        }
        return conditions;
    }

    private void defaultBuilderOperations(File expressionFile, File conditionsFile, Spreadsheet.Info info, String roundMode, int countReadsThreshold) throws IOException {
        this.finalCountReadsFile = Places.countReadsInputFile;
        this.finalConditionsFile = Places.conditionInputFile;
        this.info = info;
        this.roundMode = roundMode.equals("HALF_UP") ? Global.RoundingMode.HALF_UP : (roundMode.equals("HALF_DOWN") ? Global.RoundingMode.HALF_DOWN : (roundMode.equals("UP") ? Global.RoundingMode.UP : Global.RoundingMode.DOWN));
        this.countReadsThreshold = countReadsThreshold;
        if (this.countReadsThreshold < 1) {
            this.countReadsThreshold = 1;
        }
        if (!Manager.fileExists(expressionFile.getAbsolutePath())) {
            throw new IOException("Expression file does not exists.");
        }
        this.expressionFile = expressionFile;
        if (!Manager.fileExists(conditionsFile.getAbsolutePath())) {
            throw new IOException("Conditions file does not exists.");
        }
        this.conditionsFile = conditionsFile;
        this.setConditions(AnalysisData.loadConditionsFromFile(conditionsFile));
    }

    public void setCountReadsFile(File file) {
        this.finalCountReadsFile = file;
    }

    public void setConditionsFile(File file) {
        this.finalConditionsFile = file;
    }

    public void setConditions(SortedMap<IndexedString, String> newCond) {
        this.conditions = newCond;
        HashMap<String, Integer> sampleCountInCondition = new HashMap<String, Integer>();
        for (Map.Entry<IndexedString, String> entry : this.getNamesAndConditions()) {
            if (sampleCountInCondition.containsKey(entry.getValue())) {
                sampleCountInCondition.put(entry.getValue(), (Integer)sampleCountInCondition.get(entry.getValue()) + 1);
                continue;
            }
            sampleCountInCondition.put(entry.getValue(), 1);
        }
        this.hasReplicates = false;
        int nConditions = 0;
        for (Map.Entry entry : sampleCountInCondition.entrySet()) {
            if (((String)entry.getKey()).equals("not-use")) continue;
            ++nConditions;
            if ((Integer)entry.getValue() <= 1) continue;
            this.hasReplicates = true;
        }
        this.moreThanTwoConditions = nConditions > 2;
    }

    public boolean hasReplicatesInSamples() {
        return this.hasReplicates;
    }

    public boolean hasMoreThanTwoConditions() {
        return this.moreThanTwoConditions;
    }

    public Set<Map.Entry<IndexedString, String>> getNamesAndConditions() {
        return this.conditions.entrySet();
    }

    public int numberOfColunns() {
        return this.conditions.size();
    }

    public int getNumberOfSamples() {
        int count = 0;
        for (Map.Entry<IndexedString, String> entry : this.conditions.entrySet()) {
            if (entry.getValue().equals("not-use")) continue;
            ++count;
        }
        return count;
    }

    public void setConditionOf(String name, String condition) {
        for (Map.Entry<IndexedString, String> sample : this.conditions.entrySet()) {
            if (!sample.getKey().getText().equals(name)) continue;
            this.conditions.put(sample.getKey(), condition);
            return;
        }
    }

    public String getConditionOf(String name) {
        for (Map.Entry<IndexedString, String> sample : this.conditions.entrySet()) {
            if (!sample.getKey().getText().equals(name)) continue;
            return sample.getValue();
        }
        return null;
    }

    public int getNumberOfGenes() {
        try {
            if (Spreadsheet.rowIsNames(Spreadsheet.getFirstRowFromFile(this.conditionsFile, "\t"))) {
                return Manager.countLines(this.expressionFile.getAbsolutePath()) - 1;
            }
            return Manager.countLines(this.expressionFile.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public int getNumberOfConditions() {
        LinkedList<String> valueList = new LinkedList<String>(this.conditions.values());
        HashSet<String> conditionsSet = new HashSet<String>();
        for (String string : valueList) {
            conditionsSet.add("" + string);
        }
        boolean hasNotUse = false;
        for (String string : conditionsSet) {
            if (!string.equals("not-use")) continue;
            hasNotUse = true;
            break;
        }
        if (hasNotUse) {
            return conditionsSet.size() - 1;
        }
        return conditionsSet.size();
    }

    public static SortedMap<IndexedString, String> loadConditionsFromFile(File file) {
        TreeMap<IndexedString, String> map = new TreeMap<IndexedString, String>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader buffReader = new BufferedReader(fileReader);
            String line = null;
            map.clear();
            int i = 0;
            while ((line = buffReader.readLine()) != null) {
                String[] nameAndCondition = line.split("\t");
                if (nameAndCondition.length != 2) continue;
                String name = nameAndCondition[0];
                String condition = nameAndCondition[1];
                map.put(new IndexedString(i, name), condition);
                ++i;
            }
            buffReader.close();
            fileReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static SortedMap<IndexedString, String> getConditionsFromExpressionFile(File file, Spreadsheet.Info info) {
        int i;
        String[] names;
        TreeMap<IndexedString, String> map = new TreeMap<IndexedString, String>();
        String[] firstRow = Spreadsheet.getFirstRowFromFile(file, info.separator);
        int nConditions = !info.getFirstCellPresent() || !info.getLabelsOnFirstCol() ? firstRow.length : firstRow.length - 1;
        if (info.getHeaderOnFirstLine()) {
            names = new String[nConditions];
            for (i = 0; i < names.length; ++i) {
                names[i] = info.getFirstCellPresent() && info.getLabelsOnFirstCol() ? firstRow[i + 1] : firstRow[i];
            }
        } else {
            names = Spreadsheet.getDefaultColumnNames(nConditions);
        }
        map.clear();
        for (i = 0; i < names.length; ++i) {
            map.put(new IndexedString(i, names[i]), "not-use");
        }
        return map;
    }

    protected void writeFinalConditions() {
        AnalysisData.createConditionsFile(this.finalConditionsFile, this.conditions, true, false);
    }

    public static void createConditionsFile(File file, SortedMap<IndexedString, String> conditions, boolean makeHeader, boolean writeNotUses) {
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            String text = "";
            if (makeHeader) {
                text = text + "sample\tcondition" + System.lineSeparator();
            }
            IndexedString[] sampleNames = conditions.keySet().toArray(new IndexedString[conditions.size()]);
            for (int i = 0; i < sampleNames.length; ++i) {
                String sampleName = Global.noSpaces(sampleNames[i].getText());
                String conditionName = (String)conditions.get(sampleNames[i]);
                if (conditionName.equals("not-use") && !writeNotUses) continue;
                text = text + sampleName + "\t" + conditionName + System.lineSeparator();
            }
            buffWriter.write(text);
            buffWriter.close();
            fileWriter.close();
        }
        catch (Exception ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void writeExpression() {
        try {
            this.writeCountReadsWithoutConditions();
            this.writeFinalConditions();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeCountReadsWithoutConditions() throws IOException {
        File newRNASeq = this.finalCountReadsFile;
        if (newRNASeq.exists()) {
            newRNASeq.delete();
        }
        newRNASeq.createNewFile();
        FileReader inputReader = new FileReader(this.expressionFile);
        FileWriter outputWriter = new FileWriter(newRNASeq);
        BufferedReader buffInput = new BufferedReader(inputReader);
        BufferedWriter buffOutput = new BufferedWriter(outputWriter);
        IndexedString[] sampleNames = new IndexedString[this.conditions.size()];
        String[] conditionNames = new String[this.conditions.size()];
        Object[] sampleNameWithCondition = new String[this.conditions.size()];
        block2: for (int i = 0; i < sampleNames.length; ++i) {
            for (Map.Entry<IndexedString, String> pair : this.conditions.entrySet()) {
                if (pair.getKey().getNumber() != i) continue;
                sampleNames[i] = pair.getKey();
                conditionNames[i] = pair.getValue();
                sampleNameWithCondition[i] = pair.getValue() + "-" + pair.getKey().getText();
                continue block2;
            }
        }
        Arrays.sort(sampleNameWithCondition);
        int[] sampleNameNewIndex = new int[sampleNames.length];
        block4: for (int i = 0; i < sampleNames.length; ++i) {
            for (int j = 0; j < sampleNameWithCondition.length; ++j) {
                if (!((String)sampleNameWithCondition[j]).contains("-" + sampleNames[i].getText())) continue;
                sampleNameNewIndex[i] = j;
                continue block4;
            }
        }
        block6: for (int j = 0; j < sampleNameWithCondition.length; ++j) {
            for (int i = 0; i < sampleNames.length; ++i) {
                if (!((String)sampleNameWithCondition[j]).contains("-" + sampleNames[i].getText())) continue;
                sampleNames[i].setIndex(j);
                continue block6;
            }
        }
        TreeMap<IndexedString, String> newConditions = new TreeMap<IndexedString, String>();
        for (int i = 0; i < sampleNames.length; ++i) {
            newConditions.put(sampleNames[i], conditionNames[i]);
        }
        String[] sortedSampleName = new String[sampleNameWithCondition.length];
        for (int i = 0; i < sortedSampleName.length; ++i) {
            if (((String)sampleNameWithCondition[i]).contains("not-use")) {
                sortedSampleName[i] = "not-use";
                continue;
            }
            Object nameWithCondition = sampleNameWithCondition[i];
            int sepIndex = ((String)nameWithCondition).indexOf("-");
            sortedSampleName[i] = ((String)nameWithCondition).substring(sepIndex + 1);
        }
        String firstLine = "gene-id\t";
        for (int i = 0; i < sortedSampleName.length; ++i) {
            if (sortedSampleName[i].equals("not-use")) continue;
            firstLine = firstLine + sortedSampleName[i];
            if (i == sortedSampleName.length - 1) continue;
            firstLine = firstLine + "\t";
        }
        buffOutput.write(firstLine);
        buffOutput.newLine();
        String line = buffInput.readLine();
        if (this.info.getHeaderOnFirstLine()) {
            line = buffInput.readLine();
        }
        int counter = 1;
        int removeCounter = 0;
        while (line != null) {
            int i;
            String[] values;
            String label;
            String[] lineSplited = Global.split(line, this.info.separator);
            if (this.info.getLabelsOnFirstCol()) {
                label = lineSplited[0];
                values = new String[lineSplited.length - 1];
                for (i = 0; i < values.length; ++i) {
                    values[i] = lineSplited[i + 1];
                }
            } else {
                label = "gene" + counter;
                values = new String[lineSplited.length];
                for (i = 0; i < values.length; ++i) {
                    values[i] = lineSplited[i];
                }
            }
            String[] sortedValues = new String[values.length];
            try {
                for (int i2 = 0; i2 < sortedValues.length; ++i2) {
                    sortedValues[sampleNameNewIndex[i2]] = values[i2];
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace();
                Log.logger.severe("Less samples tham values!");
            }
            int[] intSortedValues = this.roundValuesAndEraseNotUse(sortedValues, sortedSampleName);
            boolean eraseLine = this.filterValues(intSortedValues);
            if (eraseLine) {
                ++removeCounter;
                Log.logger.fine(label + " line dropped by threshold.");
            } else {
                String lineToWrite = label;
                for (int i3 = 0; i3 < intSortedValues.length; ++i3) {
                    lineToWrite = lineToWrite + "\t" + intSortedValues[i3];
                }
                buffOutput.write(lineToWrite);
                buffOutput.newLine();
            }
            line = buffInput.readLine();
            ++counter;
        }
        buffInput.close();
        inputReader.close();
        buffOutput.close();
        outputWriter.close();
        Log.logger.info((float)removeCounter / (float)counter * 100.0f + "% of the lines dropped by threshold");
        this.setConditions(newConditions);
    }

    protected int[] roundValuesAndEraseNotUse(String[] values, String[] names) {
        boolean[] isUsable = new boolean[values.length];
        int usableCount = 0;
        for (int i = 0; i < values.length; ++i) {
            boolean bl = isUsable[i] = !names[i].equals("not-use");
            if (!isUsable[i]) continue;
            ++usableCount;
        }
        int[] decimals = new int[usableCount];
        int decimalsIndex = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!isUsable[i]) continue;
            decimals[decimalsIndex] = Global.roundFloat(Float.parseFloat(values[i]), this.roundMode);
            if (decimals[decimalsIndex] < this.countReadsThreshold) {
                decimals[decimalsIndex] = 0;
            }
            ++decimalsIndex;
        }
        return decimals;
    }

    protected boolean filterValues(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] < this.countReadsThreshold) continue;
            return false;
        }
        return true;
    }
}

