/*
 * Decompiled with CFR 0.152.
 */
package peridot.Archiver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import peridot.Archiver.Places;
import peridot.Log;

public final class Manager {
    private Manager() {
        throw new AssertionError();
    }

    private static StringBuilder readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder;
    }

    public static StringBuilder fileToString(File file) {
        try {
            StringBuilder sBuilder = Manager.readFile(file);
            return sBuilder;
        }
        catch (IOException ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public static boolean dirExists(String path) {
        File f = new File(path);
        return f.exists() && f.isDirectory();
    }

    public static boolean fileExists(String path) {
        File f = new File(path);
        return f.exists() && !f.isDirectory();
    }

    public static boolean makeNewFile(String path) throws IOException {
        File f = new File(path);
        boolean alreadyExisted = f.exists();
        if (!alreadyExisted) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        } else {
            f.delete();
        }
        return alreadyExisted;
    }

    public static Set<File> getSubDirs(File dir) {
        TreeSet<File> subDirs = new TreeSet<File>();
        TreeSet<File> subFiles = new TreeSet<File>(FileUtils.listFilesAndDirs(Places.peridotDir, TrueFileFilter.TRUE, TrueFileFilter.TRUE));
        for (File file : subFiles) {
            String filePath = file.getAbsolutePath();
            if (filePath.equals(Places.peridotDir.getAbsolutePath()) || file.getAbsolutePath().contains("results") || file.getAbsolutePath().contains("results" + File.separator) || !file.isDirectory()) continue;
            subDirs.add(file);
        }
        return subDirs;
    }

    public static boolean isImageFile(String fileName) {
        return fileName.contains(".jpg") || fileName.contains(".jpeg") || fileName.contains(".png") || fileName.contains(".img");
    }

    public static int countLines(String filename) throws IOException {
        FileReader reader = new FileReader(filename);
        BufferedReader buffReader = new BufferedReader(reader);
        int count = 0;
        while (buffReader.readLine() != null) {
            ++count;
        }
        reader.close();
        buffReader.close();
        return count;
    }

    public static File stringToFile(String path, String content) {
        File file = new File(path);
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(content);
            bufferedWriter.close();
            writer.close();
            return file;
        }
        catch (IOException ex) {
            Log.logger.severe("Error: could not write " + path);
            return null;
        }
    }

    public static File getAlternativeFileName(File file) {
        int pathLength = file.getAbsolutePath().length();
        char lastChar = file.getAbsolutePath().charAt(pathLength - 1);
        try {
            int lastCharInt = Integer.parseInt(Character.toString(lastChar), 10);
            String subStr = file.getAbsolutePath().substring(0, pathLength - 1);
            subStr = subStr + (lastCharInt + 1);
            File nextFile = new File(subStr);
            if (nextFile.exists()) {
                return Manager.getAlternativeFileName(nextFile);
            }
            return nextFile;
        }
        catch (NumberFormatException ex) {
            return new File(file.getAbsolutePath() + "0");
        }
    }

    public static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static String makeTildeIntoHomeDir(String path) {
        if (path.length() > 0 && path.charAt(0) == '~') {
            String userDir = Places.getUserHomePath();
            return userDir + path.substring(1);
        }
        return path;
    }

    public static String getCurrentWorkingDir() {
        Path currentRelativePath = Paths.get("", new String[0]);
        return currentRelativePath.toAbsolutePath().toString();
    }
}

