/*
 * Decompiled with CFR 0.152.
 */
package peridot.Archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import peridot.Global;
import peridot.Log;

public class Spreadsheet {
    private Info info;
    private List<String[]> rows;
    public File tableFile;
    private boolean reloadFlag = true;
    private int lastMax = -2;

    public static boolean lineIsHeader(String line, String sep) {
        String[] row = Global.split(line, sep);
        String firstWord = row[0];
        if (Global.lineIsWords(row)) {
            Log.logger.fine("The first line is made of words");
            return true;
        }
        return false;
    }

    private static List<String[]> getRowsFromTable(File tableFile, int max, String separator) {
        LinkedList<String[]> allRows = new LinkedList<String[]>();
        int nLines = 0;
        try {
            FileReader inputReader = new FileReader(tableFile);
            BufferedReader buffInput = new BufferedReader(inputReader);
            String line = buffInput.readLine();
            while (line != null) {
                String[] cells = Global.split(line, separator);
                allRows.add(cells);
                line = buffInput.readLine();
                if (max < 0 || ++nLines <= max) continue;
                break;
            }
        }
        catch (Exception ex) {
            Log.logger.severe("Could not read input from file " + tableFile.getAbsolutePath());
            ex.printStackTrace();
        }
        return allRows;
    }

    public static void correctNoFirstCell(List<String[]> allRows) {
        String[] line2;
        if (allRows.size() <= 1) {
            return;
        }
        String[] line1 = allRows.get(0);
        if (line1.length < (line2 = allRows.get(1)).length) {
            int i;
            int diff = line2.length - line1.length;
            String[] newLine1 = new String[line2.length];
            for (i = 0; i < diff; ++i) {
                newLine1[i] = "";
            }
            for (i = diff; i < newLine1.length; ++i) {
                newLine1[i] = line1[i - diff];
            }
            allRows.set(0, newLine1);
        }
    }

    public static String[] getDefaultHeader(int x) {
        String[] names = new String[x];
        for (int i = 0; i < x; ++i) {
            names[i] = "Column" + i;
        }
        return names;
    }

    public static String[] getFirstRowFromFile(File file, String sep) {
        String[] line = null;
        try {
            FileReader reader = new FileReader(file);
            BufferedReader buffReader = new BufferedReader(reader);
            String firstLine = buffReader.readLine();
            line = Global.split(firstLine, sep);
            buffReader.close();
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return line;
    }

    public static boolean lineIsSampleNames(String line, String sep) {
        String[] row = Global.split(line, sep);
        return Spreadsheet.lineIsSampleNames(row);
    }

    public static boolean lineIsSampleNames(String[] row) {
        if (row[0].equals("gene-id") || row[0].equals("gene_id") || row[0].equals("gene") || row[0].equals("gene id") || row[0].equals("id")) {
            return true;
        }
        return Spreadsheet.rowIsNames(row);
    }

    public static boolean rowIsNames(String[] row) {
        for (int i = 1; i < row.length; ++i) {
            try {
                double d = Double.parseDouble(row[i]);
                continue;
            }
            catch (Exception ex) {
                return true;
            }
        }
        return false;
    }

    public static String[] getDefaultColumnNames(int n) {
        String[] defaultNames = new String[n];
        for (int i = 0; i < defaultNames.length; ++i) {
            defaultNames[i] = "Colunn " + (i + 1);
        }
        return defaultNames;
    }

    public Spreadsheet(File tableFile) throws IOException {
        Log.logger.info("Reading spreadsheet for " + tableFile.getName());
        this.info = new Info(tableFile);
        this.tableFile = tableFile;
        Log.logger.info("Read spreadsheet for " + tableFile.getName());
    }

    public Spreadsheet(File tableFile, Info info) {
        this.info = info;
        this.tableFile = tableFile;
    }

    public void setSeparator(String sep) {
        boolean reload = !sep.equals(this.info.separator);
        this.info.separator = sep;
        this.reloadFlag = true;
    }

    public String getSeparator() {
        return this.info.separator;
    }

    private void reloadRows(int max) {
        this.rows = Spreadsheet.getRowsFromTable(this.tableFile, max, this.info.separator);
    }

    public List<String[]> getRows() {
        return this.getRows(-1);
    }

    public List<String[]> getRows(int max) {
        if (this.reloadFlag || this.lastMax == -2 || this.lastMax != max) {
            this.reloadRows(max);
        }
        this.reloadFlag = false;
        this.lastMax = max;
        return this.rows;
    }

    public void setInfo(Info info) {
        boolean reload = false;
        if (!info.separator.equals(this.info.separator) || info.getHeaderOnFirstLine() != this.info.getHeaderOnFirstLine() || info.getFirstCellPresent() != this.info.getFirstCellPresent() || info.getLabelsOnFirstCol() != this.info.getLabelsOnFirstCol()) {
            reload = true;
        }
        this.info = info;
        this.reloadFlag = reload;
    }

    public Info getInfo() {
        return this.info;
    }

    public static class Info {
        public String separator;
        private Boolean labelsOnFirstCol;
        private Boolean headerOnFirstLine;
        private Boolean firstCellPresent;

        public static String guessLineSeparator(File tableFile) {
            ArrayList<String> lines = Global.getFirstLinesFromFile(tableFile, 20);
            if (lines == null) {
                Log.logger.warning("Could not precisely determine the line separator of '" + tableFile.getAbsolutePath() + "' because R-Peridot failed to read it.");
                return ",";
            }
            String[] separators = new String[]{"\t", ",", " ", ";"};
            float[] avgCellsPerLine = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
            for (int i = 0; i < separators.length; ++i) {
                for (String line : lines) {
                    String[] split = line.split(separators[i]);
                    if (split.length <= 0) continue;
                    split = Global.joinArgsBetweenQuotes(split);
                    if (avgCellsPerLine[i] < 0.0f) {
                        avgCellsPerLine[i] = split.length;
                        continue;
                    }
                    avgCellsPerLine[i] = avgCellsPerLine[i] * (float)split.length;
                }
            }
            int max = 0;
            for (int i = 1; i < separators.length; ++i) {
                if (!(avgCellsPerLine[i] >= avgCellsPerLine[max])) continue;
                max = i;
            }
            return separators[max];
        }

        public Info(File tableFile) throws IOException {
            Log.logger.info("Reading info of " + tableFile.getName());
            FileReader inputReader = new FileReader(tableFile);
            BufferedReader tableInput = new BufferedReader(inputReader);
            String line = tableInput.readLine();
            String line2 = tableInput.readLine();
            tableInput.close();
            inputReader.close();
            this.separator = Info.guessLineSeparator(tableFile);
            if (line != null) {
                if (line2 != null) {
                    this.setFirstCellPresent(Global.split(line, this.separator).length >= Global.split(line2, this.separator).length);
                } else {
                    this.setFirstCellPresent(true);
                }
            } else {
                this.setFirstCellPresent(false);
            }
            if (this.getFirstCellPresent()) {
                this.setHeaderOnFirstLine(Spreadsheet.lineIsHeader(line, this.separator));
            } else {
                this.setHeaderOnFirstLine(true);
            }
            this.setLabelsOnFirstCol(true);
            Log.logger.info("Read info of " + tableFile.getName());
        }

        public Info(boolean labelsOnFirstCol, boolean headerOnFirstLine, boolean firstCellPresent, String sep) {
            this.labelsOnFirstCol = new Boolean(labelsOnFirstCol);
            this.headerOnFirstLine = new Boolean(headerOnFirstLine);
            this.firstCellPresent = new Boolean(firstCellPresent);
            this.separator = sep;
        }

        public Info() {
        }

        public boolean allInfoSet() {
            return this.labelsOnFirstCol != null && this.headerOnFirstLine != null && this.separator != null;
        }

        public boolean getFirstCellPresent() {
            return this.firstCellPresent;
        }

        public boolean getLabelsOnFirstCol() {
            return this.labelsOnFirstCol;
        }

        public boolean getHeaderOnFirstLine() {
            return this.headerOnFirstLine;
        }

        public void setFirstCellPresent(boolean newValue) {
            this.firstCellPresent = this.firstCellPresent == null ? new Boolean(newValue) : new Boolean(newValue);
        }

        public void setLabelsOnFirstCol(boolean newValue) {
            this.labelsOnFirstCol = this.labelsOnFirstCol == null ? new Boolean(newValue) : new Boolean(newValue);
        }

        public void setHeaderOnFirstLine(boolean newValue) {
            this.headerOnFirstLine = this.headerOnFirstLine == null ? new Boolean(newValue) : new Boolean(newValue);
        }
    }
}

