/*
 * Decompiled with CFR 0.152.
 */
package peridot.CLI;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import peridot.AnalysisData;
import peridot.AnalysisParameters;
import peridot.Archiver.Manager;
import peridot.Archiver.Spreadsheet;
import peridot.IndexedString;
import peridot.Log;
import peridot.script.RModule;

public class AnalysisFile {
    public boolean valid;
    public boolean allInfo;
    public Set<String> scriptsToExec;
    public AnalysisParameters params;
    public Map<String, AnalysisParameters> specificParams;
    public AnalysisData expression;
    public File outputFolder;

    public AnalysisFile(File file) {
        this.valid = true;
        this.allInfo = false;
    }

    public AnalysisFile() {
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasAllInfo() {
        return this.allInfo;
    }

    public static void createExampleFileFor(File countReadsFile) {
        try {
            String content = "";
            Spreadsheet.Info info = new Spreadsheet.Info(countReadsFile);
            File parentDir = countReadsFile.getParentFile();
            if (parentDir == null) {
                parentDir = new File(Manager.getCurrentWorkingDir());
            }
            content = content + "[data] " + countReadsFile.getAbsolutePath() + "\n";
            content = content + "[separator] " + info.separator;
            SortedMap<IndexedString, String> conditions = AnalysisData.getConditionsFromExpressionFile(countReadsFile, info);
            File condFile = new File(countReadsFile.getAbsolutePath() + ".conditions");
            AnalysisData.createConditionsFile(condFile, conditions, false, true);
            content = content + "[count-reads-threshold] 5\n";
            content = content + "[rounding-mode] HALF_UP\n";
            content = content + "[labels] " + info.getLabelsOnFirstCol() + "\n";
            content = content + "[header] " + info.getHeaderOnFirstLine() + "\n\n";
            content = content + "[conditions] " + condFile.getAbsolutePath() + "\n\n";
            content = content + "[output] " + parentDir.getAbsolutePath() + File.separator + countReadsFile.getName() + "-output\n\n";
            content = content + "[modules]\n";
            for (String string : RModule.getAvailableAnalysisModules()) {
                content = content + "#" + string + "\n";
            }
            for (String string : RModule.getAvailablePostAnalysisModules()) {
                content = content + "#" + string + "\n";
            }
            content = content + "[/end]\n\n";
            content = content + "[parameters]\n";
            HashMap<String, Object> defaultValues = AnalysisParameters.getDefaultValues();
            for (Map.Entry<String, Class> entry : RModule.getRequiredParametersFromModules().entrySet()) {
                if (defaultValues.containsKey(entry.getKey())) {
                    content = content + entry.getValue().getSimpleName() + " " + entry.getKey() + "=" + defaultValues.get(entry.getKey()).toString() + "\n";
                    continue;
                }
                content = content + entry.getValue().getSimpleName() + " " + entry.getKey() + "=INSERT_VALUE\n";
            }
            content = content + "[/end]\n\n";
            File file = new File(countReadsFile.getAbsolutePath() + ".af");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            buffWriter.write(content);
            buffWriter.close();
            fileWriter.close();
            System.out.println("Created " + file.getAbsolutePath());
        }
        catch (IOException ex) {
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static String getSpecification() {
        String string = "\n\n\t---SPECIFICATION---\n# Comments start with '#'\n";
        string = string + "[data] path/to/file\n# Specify count reads table file. ##############\n# Only plain text with cells separated by ######\n# tabs, spaces, commas and semi-colons are #####\n# supported. ###################################\n[separator] \",\"\n# Cell separator character, can be \" \", \"\\t\",####\n# \",\" or \";\". ##################################\n";
        string = string + "[count-reads-threshold] Integer\n# Minimum count read value to be considered. ###\n# Lines without values equal/above are ignored #\n[rounding-mode] HALF_UP|HALF_DOWN|UP|DOWN\n# The diff. expression packages require int ####\n# values, but the values at the count reads ####\n# can be real numbers. In that case, r-peridot #\n# rounds the number according to a rounding ####\n# rule: ########################################\n#     UP: Round away from zero #################\n#     DOWN: Round towards zero #################\n#     HALF_UP: Round to the closest integer ####\n#         but if the value ends with *.5, ######\n#         round UP. ############################\n#     HALF_DOWN: Round to the closest integer ##\n#         but if the value ends with *.5, ######\n#         round DOWN. ##########################\n";
        string = string + "# Meta-data about the count reads file:\n[labels] True|False\n# True if there are labels on the first column,#\n# False otherwise. #############################\n[header] True|False\n# True if there is a header on the first line, #\n# False otherwise. #############################\n\n";
        string = string + "# Specify conditions (groups) of samples:\n[conditions] path/to/file.conditions\n";
        string = string + "# Directory where the results will be saved: \n[output] path/to/dir/\n# The directory must exist #####################\n\n";
        string = string + "################################################\n### Example Conditions File: ###################\nsample1\tgroupX\nsample2\tgroupX\nsample3\tgroupZ\nsample4\tgroupY\nsample5\tgroupY\nsample6\tnot-use\n### Use tabulation, not ',' or ' ' to separate #\n### sample from condition. #####################\n### Sample names must be on their original #####\n### order. #####################################\n### No comments on this file, only content. ####\n### The 'not-use' condition is ignored. ########\n################################################\n\n";
        string = string + "# Specifying Modules:\n[modules]\nmoduleName1\nmoduleName2\nmoduleName3\n[/end]\n### Use r-peridot ls <module-name> to verify ###\n### if a module depends on the results of ######\n### other module. If it does, the module it ####\n### depends on must be listed too. #############\n\n";
        string = string + "# Specifying parameters (general and specific):\n[parameters]\nType parameterName=value\nType otherParameter=otherValue\nType targetModule::aSpecificParameter=anotherValue\n[/end]\n### All parameters needed by the modules ######\n### must have values specified for them here. #\n### Type can be Float, Integer or GeneIdType. #\n### 'targetModule' can be any module. #########\n";
        string = string + "######################################################\n### Don't be scared, it's not that hard. The command #\n### 'r-peridot run --create-example path/to/file' ####\n### can create a file with most of these #############\n### descriptions ready. You only have to modify the ##\n### conditions of each sample and the parameter's ####\n### default values. ##################################\n######################################################\n";
        return string;
    }
}

