/*
 * Decompiled with CFR 0.152.
 */
package peridot.CLI.Commands;

import peridot.CLI.Command;
import peridot.CLI.PeridotCmd;

public class LS
extends Command {
    public LS(String[] args) {
        super(args);
    }

    @Override
    public void defineCmdNameAndDetails() {
        this.commandStr = "ls";
        this.detail = "R-Peridot's Command: ls\nOptions:\n\tls\t\t\tList all of the R-Peridot modules currently available\n\tls [module-name]\tDisplay all details about a module\n\tls -h\t\t\tDisplays this help message\n\tls --help\t\tDisplays this help message\n";
    }

    @Override
    public void evaluateArgs() throws Command.CmdParseException {
        this.needsREnvironments = false;
        if (this.args.length > 1) {
            this.fail("'r-peridot ls' takes only zero or one arguments.");
        } else if (this.args.length == 1 && !LS.isHelpArg(this.args[0]) && !LS.isAModule(this.args[0])) {
            this.fail("Not a module name or --help: " + this.args[0]);
        }
    }

    @Override
    public void run() {
        if (this.args.length == 0) {
            PeridotCmd.listModules();
        } else if (this.args.length == 1) {
            if (LS.isHelpArg(this.args[0])) {
                this.printDetails();
            } else if (LS.isAModule(this.args[0])) {
                PeridotCmd.scriptDetails(this.args[0]);
            }
        }
    }
}

