/*
 * Decompiled with CFR 0.152.
 */
package peridot.script;

import java.io.File;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import peridot.AnalysisData;
import peridot.AnalysisParameters;
import peridot.Archiver.Manager;
import peridot.Archiver.Places;
import peridot.Log;
import peridot.Output;
import peridot.script.AnalysisModule;
import peridot.script.RModule;
import peridot.script.ScriptExec;
import peridot.script.r.Interpreter;
import peridot.script.r.Package;

public class Task {
    public Set<String> queryModules;
    public Set<String> validQueryModules;
    public Set<String> modulesToExec;
    public AnalysisParameters params;
    public Map<String, AnalysisParameters> specificParams;
    public AnalysisData expression;
    public AtomicBoolean packagesFinishedFlag;
    public AtomicBoolean abortAllFlag;
    public AtomicInteger processingStatus;
    public Runnable statusWatcher;
    public Runnable zombieFinder;
    public ConcurrentLinkedDeque<String> successfulScripts;
    public ConcurrentLinkedDeque<String> noDiffExpFound;
    public ConcurrentLinkedDeque<String> failedResults;
    public ConcurrentLinkedDeque<String> failedScripts;
    public ConcurrentLinkedDeque<String> runningScripts;
    public ConcurrentLinkedDeque<String> finishedScripts;
    public ConcurrentHashMap<String, ScriptExec> scriptExecs;
    public ConcurrentHashMap<String, WaitState> waitState;
    public ConcurrentHashMap<String, Output> scriptOutputs;
    private int remainingAnalysisScripts;
    protected Thread scriptsStatusWatcher;
    private static Task _instance;

    public Task(Set<String> scriptsToExec, AnalysisParameters params, Map<String, AnalysisParameters> specificParams, AnalysisData expression) {
        this.queryModules = scriptsToExec;
        this.params = params;
        this.specificParams = specificParams;
        this.expression = expression;
        this.packagesFinishedFlag = new AtomicBoolean(false);
        this.processingStatus = new AtomicInteger(-2);
        this.modulesToExec = new TreeSet<String>();
        this.validQueryModules = new TreeSet<String>();
        this.successfulScripts = new ConcurrentLinkedDeque();
        this.noDiffExpFound = new ConcurrentLinkedDeque();
        this.failedScripts = new ConcurrentLinkedDeque();
        this.runningScripts = new ConcurrentLinkedDeque();
        this.finishedScripts = new ConcurrentLinkedDeque();
        this.scriptExecs = new ConcurrentHashMap();
        this.waitState = new ConcurrentHashMap();
        this.scriptOutputs = new ConcurrentHashMap();
        this.packagesFinishedFlag = new AtomicBoolean(false);
        this.defineStatusWatcher();
        this.defineZombieFinder();
        for (String name : scriptsToExec) {
            if (!this.evaluateScriptInput(name)) continue;
            this.validQueryModules.add(name);
        }
        for (String scriptName : this.validQueryModules) {
            boolean canExecute = this.evaluateScriptForExecution(scriptName);
            if (!canExecute) continue;
            this.modulesToExec.add(scriptName);
        }
    }

    public void start() {
        this.abortAllFlag = new AtomicBoolean();
        this.abortAllFlag.set(false);
        _instance = this;
        RModule.removeScriptResults();
        this.failedResults = new ConcurrentLinkedDeque();
        this.remainingAnalysisScripts = 0;
        for (String name : this.modulesToExec) {
            this.queueScriptForExecution(name);
        }
        this.updateStates();
        this.updateStatus();
        this.playReady();
        new Thread(this.zombieFinder).start();
    }

    private boolean evaluateScriptInput(String name) {
        RModule script = RModule.availableModules.get(name);
        if (script != null) {
            script.passParameters(this.params);
            if (this.specificParams.containsKey(name)) {
                script.passParameters(this.specificParams.get(name));
            }
            if (script.parametersSufficed()) {
                return true;
            }
            String paramsList = "";
            for (String entry : script.requiredParameters.keySet()) {
                paramsList = paramsList + entry + "\n";
            }
            Log.logger.severe(name + "'s parameters not sufficed. Required parameters are:\n " + paramsList + "Read the module details for more information.");
        } else {
            Log.logger.severe("No module named '" + name + "' is available.");
        }
        return false;
    }

    private boolean evaluateScriptForExecution(String name) {
        RModule script = RModule.availableModules.get(name);
        HashSet<String> modulesNotFound = new HashSet<String>();
        for (String module : script.requiredScripts) {
            if (this.validQueryModules.contains(module)) continue;
            modulesNotFound.add(module);
        }
        if (modulesNotFound.size() == 0) {
            if (script.requiredPackagesInstalled()) {
                boolean createdConfig = script.createConfig();
                if (createdConfig) {
                    return true;
                }
                Log.logger.severe("An error occurred while creating config.txt, the parameters file, for " + name + ". The module will not be executed.");
            } else {
                Set<Package> notInstalled = script.requiredPackagesNotInstalled();
                String notFoundList = "";
                for (Package entry : notInstalled) {
                    notFoundList = notFoundList + entry.name + "\t" + entry.version + "\n";
                }
                Log.logger.severe(name + "'s requirements not sufficed. The following required packages are not installed in the R environment:\n " + notFoundList + "The module will not be executed. Please install the required packages in the R environment.");
            }
        } else {
            String notFoundList = "";
            for (String entry : modulesNotFound) {
                notFoundList = notFoundList + entry + "\n";
            }
            Log.logger.severe(name + "'s requirements not sufficed. The following required modules were not selected or have invalid input:\n " + notFoundList + "The module will not be executed. Read the modules details for more information.");
        }
        return false;
    }

    private void queueScriptForExecution(String name) {
        RModule script = RModule.availableModules.get(name);
        if (script instanceof AnalysisModule) {
            ++this.remainingAnalysisScripts;
        }
        Output output = new Output();
        ScriptExec exec = new ScriptExec(script, output, this, Interpreter.defaultInterpreter);
        this.scriptOutputs.put(name, output);
        this.scriptExecs.put(name, exec);
        this.waitState.put(name, WaitState.WAITING);
    }

    public boolean isNotStarted() {
        return this.processingStatus.get() == -2;
    }

    public boolean isProcessing() {
        return this.processingStatus.get() == -1;
    }

    public boolean isFailed() {
        return this.processingStatus.get() == 0;
    }

    public boolean isSomeFailed() {
        return this.processingStatus.get() == 1;
    }

    public boolean isSuccess() {
        return this.processingStatus.get() == 2;
    }

    private void defineStatusWatcher() {
        this.statusWatcher = () -> {
            while (this.processingStatus.get() < 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        };
    }

    private void defineZombieFinder() {
        this.zombieFinder = () -> {
            while (this.processingStatus.get() < 0) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                this.updateStatus();
                this.playReady();
                for (String s : this.runningScripts) {
                    LocalDateTime lastUpdate = this.scriptOutputs.get((Object)s).lastUpdate;
                    if (!lastUpdate.isBefore(LocalDateTime.now().minusMinutes(2L))) continue;
                    this.scriptOutputs.get(s).appendLine("[PERIDOT WARNING] This process may not be responding.");
                    Log.logger.warning(s + " process may not be responding.");
                }
            }
        };
    }

    private synchronized void updateStatus() {
        if (this.finishedScripts.size() == this.scriptExecs.size()) {
            if (this.failedScripts.size() == 0) {
                this.processingStatus.set(2);
            } else if (this.successfulScripts.size() > 0) {
                this.processingStatus.set(1);
            } else {
                this.processingStatus.set(0);
            }
            _instance = null;
        } else {
            this.processingStatus.set(-1);
        }
    }

    public synchronized void addFinished(String name, boolean prefailed) {
        Log.logger.finer("Adding " + name + " to finished scripts.");
        if (RModule.getAvailableAnalysisModules().contains(name)) {
            --this.remainingAnalysisScripts;
            Log.logger.fine(this.remainingAnalysisScripts + " analysis scripts remaining.");
            if (this.remainingAnalysisScripts <= 0) {
                this.packagesFinishedFlag.set(true);
                Log.logger.fine("Finished all analysis scripts.");
            }
        }
        this.finishedScripts.add(name);
        this.checkForSuccess(name);
        if (!prefailed) {
            this.runningScripts.remove(name);
        } else {
            ScriptExec exec = this.scriptExecs.get(name);
            exec.started.set(true);
            exec.running.set(false);
            exec.process = null;
            exec.successFlag.set(false);
            this.scriptOutputs.get(name).appendLine("preFailed");
        }
        this.updateStatus();
        this.updateStates();
        this.playReady();
    }

    private void checkForSuccess(String name) {
        if (this.scriptExecs.get((Object)name).successFlag.get()) {
            String path;
            this.successfulScripts.add(name);
            if (RModule.getAvailableAnalysisModules().contains(name) && Manager.fileExists(path = Places.finalResultsDir.getAbsolutePath() + File.separator + name + ".AnalysisModule" + File.separator + "res.tsv")) {
                try {
                    if (Manager.countLines(path) <= 1) {
                        this.noDiffExpFound.add(name);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Log.logger.info(name + " is successful");
        } else {
            Set<String> faileds = this.scriptExecs.get((Object)name).script.getNotExistantResults();
            for (String result : faileds) {
                this.failedResults.add(result);
            }
            this.failedScripts.add(name);
            Log.logger.info(name + " is not successful");
        }
    }

    private synchronized void playReady() {
        while (true) {
            boolean found = false;
            String foundName = "";
            for (Map.Entry<String, WaitState> pair : this.waitState.entrySet()) {
                if (this.abortAllFlag.get()) {
                    if (!pair.getValue().equals((Object)WaitState.WAITING) && !pair.getValue().equals((Object)WaitState.WAITING)) continue;
                    found = true;
                    foundName = pair.getKey();
                    break;
                }
                if (!pair.getValue().equals((Object)WaitState.READY)) continue;
                found = true;
                foundName = pair.getKey();
                break;
            }
            if (!found) break;
            this.waitState.replace(foundName, WaitState.STARTED);
            if (this.abortAllFlag.get()) {
                this.scriptExecs.get(foundName).cancel();
            } else {
                this.scriptExecs.get(foundName).start();
                Log.logger.info(foundName + " has started");
            }
            this.runningScripts.add(foundName);
        }
    }

    private void preFailed(String name) {
        this.addFinished(name, true);
    }

    private synchronized void updateStates() {
        boolean foundPreFailed;
        do {
            foundPreFailed = false;
            HashSet<String> toPutPrefailed = new HashSet<String>();
            for (Map.Entry<String, WaitState> pair : this.waitState.entrySet()) {
                if (!pair.getValue().equals((Object)WaitState.WAITING) || this.scriptExecs.get((Object)pair.getKey()).script.filesAreInRequirements(this.failedResults).size() <= 0) continue;
                toPutPrefailed.add(pair.getKey());
                foundPreFailed = true;
                break;
            }
            for (String name : toPutPrefailed) {
                this.waitState.replace(name, WaitState.PRE_FAILED);
                Log.logger.severe(name + " has failed previously to execution");
                this.preFailed(name);
            }
        } while (foundPreFailed);
        HashSet<String> toPutReady = new HashSet<String>();
        for (Map.Entry<String, WaitState> pair : this.waitState.entrySet()) {
            if (!pair.getValue().equals((Object)WaitState.WAITING)) continue;
            ScriptExec exec = this.scriptExecs.get(pair.getKey());
            if (exec.script instanceof AnalysisModule) {
                toPutReady.add(pair.getKey());
                continue;
            }
            if (!this.packagesFinishedFlag.get()) continue;
            Log.logger.finer("Checking if " + pair.getKey() + " is ready...");
            if (exec.script.requirementsSufficed()) {
                toPutReady.add(pair.getKey());
                continue;
            }
            Log.logger.finer("...not ready;");
        }
        for (String name : toPutReady) {
            this.waitState.replace(name, WaitState.READY);
            Log.logger.finer(name + " is now ready");
        }
    }

    public void abortAll() {
        this.abortAllFlag.set(true);
        for (ScriptExec exec : this.scriptExecs.values()) {
            if (!exec.running.get()) continue;
            exec.abort();
        }
    }

    public static Task getRunningTask() {
        return _instance;
    }

    public static enum WaitState {
        WAITING,
        PRE_FAILED,
        READY,
        STARTED;

    }
}

