/*
 * Decompiled with CFR 0.152.
 */
package peridot.script.r;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import peridot.Archiver.PeridotConfig;
import peridot.Archiver.Places;
import peridot.Output;
import peridot.script.RModule;
import peridot.script.r.Package;
import peridot.script.r.RInfoParser;
import peridot.script.r.Script;
import peridot.script.r.VersionNumber;

public class Interpreter {
    public static List<Interpreter> interpreters = null;
    public static Interpreter defaultInterpreter = null;
    public Set<Package> availablePackages;
    public String exe;
    public boolean validInterpreter = true;
    private float value = 0.0f;
    private VersionNumber rVersion;

    public static boolean isDefaultInterpreterDefined() {
        return defaultInterpreter != null;
    }

    public static boolean interpretersAreLoaded() {
        return interpreters != null;
    }

    public static void loadDefaultInterpreter() {
        if (PeridotConfig.get().defaultInterpreter != null) {
            for (Interpreter interpreter : interpreters) {
                if (!interpreter.exe.equals(PeridotConfig.get().defaultInterpreter)) continue;
                defaultInterpreter = interpreter;
                return;
            }
        }
        defaultInterpreter = null;
    }

    public static void getAvailableInterpreters() {
        Set<String> execs = PeridotConfig.get().availableInterpreters;
        ArrayList<Interpreter> interpreters = new ArrayList<Interpreter>();
        for (String exec : execs) {
            Interpreter interpreter = new Interpreter(exec);
            if (!interpreter.validInterpreter) continue;
            interpreters.add(interpreter);
        }
        Comparator<Interpreter> comparator = Comparator.comparing(Interpreter::getRVersion).reversed();
        Collections.sort(interpreters, comparator);
        Interpreter.interpreters = interpreters;
    }

    public static boolean addInterpreter(String exec) {
        Interpreter toRemove = null;
        if (interpreters != null && interpreters.size() > 0) {
            for (Interpreter interp : interpreters) {
                if (!interp.exe.equals(exec)) continue;
                toRemove = interp;
            }
        }
        Interpreter interpreter = new Interpreter(exec);
        if (interpreter.validInterpreter) {
            if (toRemove != null) {
                interpreters.remove(toRemove);
            }
            if (interpreters == null) {
                interpreters = new ArrayList<Interpreter>();
            }
            interpreters.add(interpreter);
        }
        return interpreter.validInterpreter;
    }

    public static boolean removeInterpreter(int i) {
        if (i >= 0 && i < interpreters.size()) {
            boolean removed;
            boolean removeDefault = false;
            Interpreter toRm = interpreters.get(i);
            if (Interpreter.isDefaultInterpreterDefined() && toRm.exe.equals(Interpreter.defaultInterpreter.exe)) {
                removeDefault = true;
            }
            boolean bl = removed = interpreters.remove(i) != null;
            if (removed && removeDefault) {
                defaultInterpreter = null;
            }
            return removed;
        }
        return false;
    }

    public static boolean setDefault(int i) {
        if (i >= 0 && i < interpreters.size()) {
            defaultInterpreter = interpreters.get(i);
            return true;
        }
        return false;
    }

    public static String getInterpretersStr() {
        String s = "";
        int i = 0;
        for (Interpreter interpreter : interpreters) {
            String str = "[" + ++i + "] " + interpreter.toString() + "\n";
            if (Interpreter.isDefaultInterpreterDefined() && Interpreter.defaultInterpreter.exe.equals(interpreter.exe)) {
                str = "* " + str;
            }
            s = s + str;
        }
        if (Interpreter.isDefaultInterpreterDefined()) {
            s = s + "\n* = Default interpreter";
        }
        return s;
    }

    public Interpreter(String exe) {
        this.exe = exe;
        this.analyseInterpreter();
    }

    public void analyseInterpreter() {
        Output testOutput = null;
        try {
            testOutput = this.readPackagesAvailable();
        }
        catch (Exception exp) {
            this.validInterpreter = false;
        }
        if (this.validInterpreter) {
            this.validInterpreter = this.readPackagesFromOutput(testOutput);
        }
    }

    private Output readPackagesAvailable() throws Exception {
        Script readPackagesScript = new Script(Places.readPackagesScript);
        readPackagesScript.run(this, true);
        return readPackagesScript.getOutputStream();
    }

    boolean readPackagesFromOutput(Output output) {
        RInfoParser parser = new RInfoParser(output);
        if (parser.validOutput()) {
            this.rVersion = parser.rVersion;
            this.availablePackages = parser.packages;
            this.evaluate();
        } else {
            System.out.println(output.getText());
        }
        return parser.validOutput();
    }

    public VersionNumber getRVersion() {
        return this.rVersion;
    }

    public String[] getLinuxEnvVars() {
        File exeFile = new File(this.exe);
        if (exeFile.exists()) {
            String[] strings = new String[]{"R_HOME='" + exeFile.getParentFile().getAbsolutePath() + "'"};
            return strings;
        }
        String[] strings = new String[]{""};
        return strings;
    }

    public Set<Package> getPackagesToInstall() {
        TreeMap<String, Package> required = new TreeMap<String, Package>();
        for (Package package_ : RModule.requiredPackages()) {
            required.put(package_.name, package_);
        }
        HashSet installed = new HashSet();
        for (Package pack : this.availablePackages) {
            if (!required.keySet().contains(pack.name)) continue;
            installed.add(required.get(pack.name));
        }
        HashSet<Package> hashSet = new HashSet<Package>();
        hashSet.addAll(RModule.requiredPackages());
        hashSet.removeAll(installed);
        return hashSet;
    }

    public String titleString() {
        return this.exe + ":\n\tVersion: " + this.rVersion.toString() + "\tScore: " + String.format("%.2f", Float.valueOf(this.value * 10.0f));
    }

    public String packagesToInstallString() {
        Set<String> cannotRun;
        String str = "";
        Set<Package> toInstall = this.getPackagesToInstall();
        if (toInstall.size() > 0) {
            str = str + "To Install:\n";
            for (Package pack : toInstall) {
                str = str + "\t" + pack.name + "\t" + pack.version.toString() + "\n";
            }
        }
        if ((cannotRun = RModule.modulesWithUnmetDependencies(this)).size() > 0) {
            str = str + "Modules with unmet dependencies:\n\t";
            for (String module : cannotRun) {
                str = str + module + "; ";
            }
        }
        return str;
    }

    public String toString() {
        String str = this.titleString() + "\n";
        str = str + this.packagesToInstallString();
        return str;
    }

    private float evaluate() {
        Set<Package> requiredPackages = RModule.requiredPackages();
        HashMap<String, Package> packsMap = new HashMap<String, Package>();
        for (Package pack : requiredPackages) {
            packsMap.put(pack.name, pack);
        }
        float nRequiredPackages = requiredPackages.size();
        float value = 0.0f;
        for (Package pack : this.availablePackages) {
            if (!packsMap.keySet().contains(pack.name)) continue;
            int comparison = pack.version.compareTo(((Package)packsMap.get((Object)pack.name)).version);
            if (comparison >= 0) {
                if (comparison == 0) {
                    value = (float)((double)value + 1.0);
                    continue;
                }
                value = (float)((double)value + 0.75);
                continue;
            }
            value = (float)((double)value + 0.5);
        }
        value /= nRequiredPackages;
        float rValue = 0.0f;
        if (this.rVersion.compareTo(PeridotConfig.minimalRVersion) < 0) {
            rValue = 0.0f;
        } else {
            int comparison = this.rVersion.compareTo(PeridotConfig.preferredRVersion);
            if (comparison > 0) {
                rValue = 0.9f;
            } else if (comparison < 0) {
                rValue = 0.5f;
            } else if (comparison == 0) {
                rValue = 1.0f;
            }
        }
        this.value = value * 0.6f + rValue * 0.4f;
        return value;
    }

    public boolean update() {
        return false;
    }

    public static class InvalidExeException
    extends Exception {
    }
}

