/*
 * Decompiled with CFR 0.152.
 */
package peridot.script.r;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import peridot.Archiver.PeridotConfig;
import peridot.Archiver.Places;
import peridot.Log;
import peridot.Output;
import peridot.script.r.Interpreter;
import peridot.script.r.Package;
import peridot.script.r.Script;

public class PackageInstaller {
    private Interpreter interpreter;
    private Package pack;
    public Status status;
    public Script script;
    private AtomicBoolean running;
    public boolean writeAccessError;

    public PackageInstaller(Interpreter interpreter, Package pack) {
        this.interpreter = interpreter;
        this.pack = pack;
        this.status = Status.NOT_STARTED;
        String[] args = new String[]{pack.name, "0.0.0.0"};
        if (interpreter.getRVersion().into(PeridotConfig.preferredRVersion)) {
            String[] args2 = new String[]{pack.name, PeridotConfig.get().packagesRepository};
            args = args2;
        }
        this.script = new Script(Places.installPackageScript, args, true);
        this.running = new AtomicBoolean(false);
    }

    public String getPackageName() {
        return this.pack.name;
    }

    public Package getPackage() {
        return this.pack;
    }

    public boolean finished() {
        return this.status != Status.NOT_STARTED && this.status != Status.INSTALLING;
    }

    public boolean install() {
        if (this.status == Status.FAILED || this.status == Status.NO_PERMISSION) {
            return false;
        }
        try {
            this.status = Status.INSTALLING;
            this.running.set(true);
            this.script.run(this.interpreter, true);
            Output output = this.script.getOutputStream();
            this.parseOutput(output);
            this.running.set(false);
            return true;
        }
        catch (Exception e) {
            this.status = Status.FAILED;
            e.printStackTrace();
            return false;
        }
    }

    private boolean lookForPermissionError(String output) {
        if (output != null) {
            return output.contains("not writable");
        }
        return false;
    }

    private void parseOutput(Output output) {
        this.writeAccessError = this.lookForPermissionError(output.getText());
        HashMap<String, List<String>> commands = output.getCommands();
        List<String> ifCommand = commands.get("> if(packIsInstalled(packageToInstall)){");
        if (ifCommand != null) {
            String resultLine = null;
            for (String line : ifCommand) {
                if (!line.contains("[1]")) continue;
                resultLine = line;
                break;
            }
            if (resultLine.contains("Package already installed")) {
                this.status = Status.ALREADY_INSTALLED;
            } else if (resultLine.contains("The package could not")) {
                this.status = Status.FAILED;
                if (this.writeAccessError) {
                    this.script.getOutputStream().appendLine("This installation probably failed because you do not have access to the packages library of the current R environment. Try using r-peridot as root next time.");
                    this.status = Status.NO_PERMISSION;
                }
            } else if (resultLine.contains("Package successfully installed")) {
                this.status = Status.INSTALLED;
            } else {
                this.reportInvalidOutput();
            }
        } else {
            this.reportInvalidOutput();
        }
    }

    public String getOutputStr() {
        return this.script.getOutputString();
    }

    private void reportInvalidOutput() {
        Log.logger.severe("Invalid output from installation script");
        this.status = Status.FAILED;
    }

    public void stop() {
        this.status = Status.FAILED;
        this.script.kill();
    }

    public static enum Status {
        NOT_STARTED,
        INSTALLING,
        ALREADY_INSTALLED,
        FAILED,
        NO_PERMISSION,
        INSTALLED;

    }
}

